/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.grids;

import java.util.ArrayList;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.geometry.Point;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.grids.GridEnvelope;
import org.citygml4j.model.gml.grids.GridLimits;

public class Grid
extends AbstractGeometry {
    private GridLimits limits;
    private List<String> axisName;
    private int dimension;

    public GridLimits getLimits() {
        return this.limits;
    }

    public List<String> getAxisName() {
        if (this.axisName == null) {
            this.axisName = new ArrayList<String>();
        }
        return this.axisName;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public boolean isSetLimits() {
        return this.limits != null;
    }

    public boolean isSetAxisName() {
        return this.axisName != null && !this.axisName.isEmpty();
    }

    public boolean isSetDimension() {
        return true;
    }

    public void setLimits(GridLimits limits) {
        this.limits = ModelObjects.setParent(limits, (ModelObject)this);
    }

    public void addAxisName(String axisName) {
        this.getAxisName().add(axisName);
    }

    public void setAxisName(List<String> axisName) {
        this.axisName = axisName;
    }

    public void setDimension(Integer dimension) {
        if (dimension > 0) {
            this.dimension = dimension;
        }
    }

    public void unsetLimits() {
        this.limits = ModelObjects.setNull(this.limits);
    }

    public void unsetAxisName() {
        this.axisName = null;
    }

    @Override
    public BoundingBox calcBoundingBox() {
        if (!this.isSetLimits()) {
            return null;
        }
        GridEnvelope gridEnvelope = this.limits.getGridEnvelope();
        if (!gridEnvelope.isSetHigh() || !gridEnvelope.isSetLow() || gridEnvelope.getHigh().size() < this.dimension || gridEnvelope.getLow().size() < this.dimension) {
            return null;
        }
        BoundingBox bbox = new BoundingBox();
        Point low = new Point();
        low.setX(this.dimension >= 1 ? (double)gridEnvelope.getLow().get(0).intValue() : 0.0);
        low.setY(this.dimension >= 2 ? (double)gridEnvelope.getLow().get(1).intValue() : 0.0);
        low.setZ(this.dimension >= 3 ? (double)gridEnvelope.getLow().get(2).intValue() : 0.0);
        bbox.update(low);
        Point high = new Point();
        high.setX(this.dimension >= 1 ? (double)gridEnvelope.getHigh().get(0).intValue() : 0.0);
        high.setY(this.dimension >= 2 ? (double)gridEnvelope.getHigh().get(1).intValue() : 0.0);
        high.setZ(this.dimension >= 3 ? (double)gridEnvelope.getHigh().get(2).intValue() : 0.0);
        bbox.update(high);
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.GRID;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Grid copy = target == null ? new Grid() : (Grid)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetLimits()) {
            copy.setLimits((GridLimits)copyBuilder.copy(this.limits));
            if (copy.getLimits() == this.limits) {
                this.limits.setParent(this);
            }
        }
        if (this.isSetAxisName()) {
            copy.setAxisName((List)copyBuilder.copy(this.axisName));
        }
        copy.setDimension(this.dimension);
        copy.unsetParent();
        return copy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Grid(), copyBuilder);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

