/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.module;

import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.ModuleType;
import org.citygml4j.model.module.ModuleVersion;

public abstract class AbstractModule
implements Module {
    private final ModuleType type;
    private final ModuleVersion version;
    private final String namespaceURI;
    protected String namespacePrefix;
    private final String schemaLocation;
    private final Module[] dependencies;

    public AbstractModule(ModuleType type, ModuleVersion version, String namespaceURI, String namespacePrefix, String schemaLocation, Module ... dependencies) {
        this.type = type;
        this.version = version;
        this.namespaceURI = namespaceURI;
        this.namespacePrefix = namespacePrefix;
        this.schemaLocation = schemaLocation;
        this.dependencies = dependencies;
    }

    @Override
    public ModuleType getType() {
        return this.type;
    }

    @Override
    public ModuleVersion getVersion() {
        return this.version;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public Module[] getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isDependentOn(Module module, boolean transitive) {
        if (this.dependencies != null) {
            for (Module dependency : this.dependencies) {
                if (module == dependency) {
                    return true;
                }
                if (!transitive || !dependency.isDependentOn(module, transitive)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasFeatureProperty(String name) {
        return false;
    }

    @Override
    public boolean hasFeature(String name) {
        return false;
    }

    @Override
    public Class<? extends AbstractFeature> getFeatureClass(String name) {
        return null;
    }

    @Override
    public QName getFeatureName(Class<? extends AbstractFeature> featureClass) {
        return null;
    }

    @Override
    public Map<String, Class<? extends AbstractFeature>> getFeatures() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isTopLevelFeature(String name) {
        return false;
    }
}

