/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.module.citygml;

import java.util.ArrayList;
import java.util.List;
import org.citygml4j.model.module.AbstractModuleConfiguration;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.citygml.AppearanceModule;
import org.citygml4j.model.module.citygml.BridgeModule;
import org.citygml4j.model.module.citygml.BuildingModule;
import org.citygml4j.model.module.citygml.CityFurnitureModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.model.module.citygml.CityGMLModuleType;
import org.citygml4j.model.module.citygml.CityObjectGroupModule;
import org.citygml4j.model.module.citygml.CoreModule;
import org.citygml4j.model.module.citygml.GenericsModule;
import org.citygml4j.model.module.citygml.LandUseModule;
import org.citygml4j.model.module.citygml.ReliefModule;
import org.citygml4j.model.module.citygml.TexturedSurfaceModule;
import org.citygml4j.model.module.citygml.TransportationModule;
import org.citygml4j.model.module.citygml.TunnelModule;
import org.citygml4j.model.module.citygml.VegetationModule;
import org.citygml4j.model.module.citygml.WaterBodyModule;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.model.module.gml.GMLModule;
import org.citygml4j.model.module.gml.XLinkModule;
import org.citygml4j.model.module.xal.AbstractXALModule;
import org.citygml4j.model.module.xal.XALCoreModule;

public class CityGMLVersion
extends AbstractModuleConfiguration {
    private static final List<CityGMLVersion> instances = new ArrayList<CityGMLVersion>();
    public static final CityGMLVersion DEFAULT;
    public static final CityGMLVersion v2_0_0;
    public static final CityGMLVersion v1_0_0;

    private CityGMLVersion(Module ... modules) {
        super(modules);
        instances.add(this);
    }

    public List<CityGMLModule> getCityGMLModules() {
        ArrayList<CityGMLModule> citygml = new ArrayList<CityGMLModule>();
        for (Module module : this.modules) {
            if (!(module instanceof CityGMLModule)) continue;
            citygml.add((CityGMLModule)module);
        }
        return citygml;
    }

    public CityGMLModule getCityGMLModule(CityGMLModuleType type) {
        for (CityGMLModule module : this.getCityGMLModules()) {
            if (module.getType() != type) continue;
            return module;
        }
        return null;
    }

    public List<GMLModule> getGMLModules() {
        ArrayList<GMLModule> gml = new ArrayList<GMLModule>();
        for (Module module : this.modules) {
            if (!(module instanceof GMLModule)) continue;
            gml.add((GMLModule)module);
        }
        return gml;
    }

    public List<AbstractXALModule> getXALModules() {
        ArrayList<AbstractXALModule> xal = new ArrayList<AbstractXALModule>();
        for (Module module : this.modules) {
            if (!(module instanceof AbstractXALModule)) continue;
            xal.add((AbstractXALModule)module);
        }
        return xal;
    }

    public static CityGMLVersion fromCityGMLModule(CityGMLModule module) {
        for (CityGMLVersion version : instances) {
            if (!version.contains(module)) continue;
            return version;
        }
        return null;
    }

    public static CityGMLVersion fromCityGMLNamespaceURI(String namespaceURI) {
        for (CityGMLVersion version : instances) {
            for (CityGMLModule module : version.getCityGMLModules()) {
                if (!module.getNamespaceURI().equals(namespaceURI)) continue;
                return version;
            }
        }
        return null;
    }

    public static List<CityGMLVersion> getInstances() {
        return instances;
    }

    public String toString() {
        if (this == v2_0_0) {
            return "2.0.0";
        }
        if (this == v1_0_0) {
            return "1.0.0";
        }
        return super.toString();
    }

    static {
        v2_0_0 = new CityGMLVersion(AppearanceModule.v2_0_0, BridgeModule.v2_0_0, BuildingModule.v2_0_0, CityFurnitureModule.v2_0_0, CityObjectGroupModule.v2_0_0, CoreModule.v2_0_0, GenericsModule.v2_0_0, LandUseModule.v2_0_0, ReliefModule.v2_0_0, TexturedSurfaceModule.v2_0_0, TransportationModule.v2_0_0, TunnelModule.v2_0_0, VegetationModule.v2_0_0, WaterBodyModule.v2_0_0, GMLCoreModule.v3_1_1, XLinkModule.v3_1_1, XALCoreModule.v2_0);
        v1_0_0 = new CityGMLVersion(AppearanceModule.v1_0_0, BuildingModule.v1_0_0, CityFurnitureModule.v1_0_0, CityObjectGroupModule.v1_0_0, CoreModule.v1_0_0, GenericsModule.v1_0_0, LandUseModule.v1_0_0, ReliefModule.v1_0_0, TexturedSurfaceModule.v1_0_0, TransportationModule.v1_0_0, VegetationModule.v1_0_0, WaterBodyModule.v1_0_0, GMLCoreModule.v3_1_1, XLinkModule.v3_1_1, XALCoreModule.v2_0);
        DEFAULT = v2_0_0;
    }
}

