/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.child;

import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.geometry.AbstractGeometry;

public class ChildInfo {
    public AbstractFeature getParentFeature(Child child) {
        if (child == null) {
            return null;
        }
        ModelObject parent = null;
        while ((parent = child.getParent()) != null) {
            if (parent instanceof AbstractFeature) {
                return (AbstractFeature)parent;
            }
            if (!(parent instanceof Child)) break;
            child = (Child)parent;
        }
        return null;
    }

    public <T extends AbstractFeature> T getParentFeature(Child child, Class<T> type) {
        while ((child = this.getParentFeature(child)) != null) {
            if (!type.isInstance(child)) continue;
            return (T)((AbstractFeature)child);
        }
        return null;
    }

    public AbstractFeature getRootFeature(Child child) {
        AbstractFeature parent = null;
        AbstractFeature root = null;
        while ((parent = this.getParentFeature(child)) != null) {
            root = parent;
            child = root;
        }
        return root;
    }

    public AbstractCityObject getParentCityObject(Child child) {
        AbstractFeature parent = null;
        while ((parent = this.getParentFeature(child)) != null) {
            if (parent instanceof AbstractCityObject) {
                return (AbstractCityObject)parent;
            }
            if (!(parent instanceof Child)) break;
            child = parent;
        }
        return null;
    }

    public <T extends AbstractCityObject> T getParentCityObject(Child child, Class<T> type) {
        while ((child = this.getParentCityObject(child)) != null) {
            if (!type.isInstance(child)) continue;
            return (T)((AbstractCityObject)child);
        }
        return null;
    }

    public AbstractCityObject getRootCityObject(Child child) {
        AbstractCityObject parent = null;
        AbstractCityObject root = null;
        while ((parent = this.getParentCityObject(child)) != null) {
            root = parent;
            child = root;
        }
        return root;
    }

    public CityGML getParentCityGML(Child child) {
        if (child == null) {
            return null;
        }
        ModelObject parent = null;
        while ((parent = child.getParent()) != null) {
            if (parent instanceof CityGML) {
                return (CityGML)parent;
            }
            if (!(parent instanceof Child)) break;
            child = (Child)parent;
        }
        return null;
    }

    public <T extends CityGML> T getParentCityGML(Child child, Class<T> type) {
        CityGML cityGML = this.getParentCityGML(child);
        if (type.isInstance(cityGML)) {
            return (T)cityGML;
        }
        if (cityGML instanceof Child) {
            return this.getParentCityGML((Child)((Object)cityGML), type);
        }
        return null;
    }

    public CityGML getRootCityGML(Child child) {
        if (child == null) {
            return null;
        }
        ModelObject parent = null;
        CityGML root = null;
        while ((parent = child.getParent()) != null) {
            if (parent instanceof CityGML) {
                root = (CityGML)parent;
            }
            if (!(parent instanceof Child)) break;
            child = (Child)parent;
        }
        return root instanceof CityGML ? (CityGML)root : null;
    }

    public AbstractGeometry getParentGeometry(Child child) {
        if (child == null) {
            return null;
        }
        ModelObject parent = null;
        while ((parent = child.getParent()) != null) {
            if (parent instanceof AbstractGeometry) {
                return (AbstractGeometry)parent;
            }
            if (parent instanceof AbstractFeature || !(parent instanceof Child)) break;
            child = (Child)parent;
        }
        return null;
    }

    public <T extends AbstractGeometry> T getParentGeometry(Child child, Class<T> type) {
        while ((child = this.getParentGeometry(child)) != null) {
            if (!type.isInstance(child)) continue;
            return (T)((AbstractGeometry)child);
        }
        return null;
    }

    public AbstractGeometry getRootGeometry(Child child) {
        AbstractGeometry parent = null;
        AbstractGeometry root = null;
        while ((parent = this.getParentGeometry(child)) != null) {
            root = parent;
            child = root;
        }
        return root;
    }
}

