/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.internal.xml;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.citygml4j.util.internal.xml.TransformerChain;

public class TransformerChainFactory {
    private final SAXTransformerFactory factory;
    private Templates[] templates;

    public TransformerChainFactory(Templates[] templates) throws TransformerConfigurationException {
        if (templates == null || templates.length == 0) {
            throw new IllegalArgumentException("no transformation templates provided.");
        }
        this.templates = templates;
        this.factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    public TransformerChain buildChain() throws TransformerConfigurationException {
        TransformerHandler[] handlers = new TransformerHandler[this.templates.length];
        for (int i = this.templates.length - 1; i >= 0; --i) {
            handlers[i] = this.factory.newTransformerHandler(this.templates[i]);
            if (i >= this.templates.length - 1) continue;
            handlers[i].setResult(new SAXResult(handlers[i + 1]));
        }
        return new TransformerChain(handlers[0], handlers[handlers.length - 1]);
    }

    public void updateTemplates(Templates[] templates) {
        if (templates == null || templates.length == 0) {
            throw new IllegalArgumentException("no transformation templates provided.");
        }
        this.templates = templates;
    }

    public SAXTransformerFactory getTransformerFactory() {
        return this.factory;
    }

    public Templates[] getTemplates() {
        return this.templates;
    }
}

