/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.lod;

import java.lang.reflect.Field;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.common.annotation.Lod;
import org.citygml4j.model.gml.base.AssociationByRepOrRef;
import org.citygml4j.model.gml.geometry.GeometryProperty;

public class LodRepresentationBuilder {
    private LodRepresentationBuilder() {
    }

    public static LodRepresentation buildRepresentation(Object object) {
        return LodRepresentationBuilder.buildFor(object, false);
    }

    public static LodRepresentation buildFor(Object object, boolean getLodFromAttributeName) {
        LodRepresentation lods = new LodRepresentation();
        Class<?> objectType = object.getClass();
        do {
            for (Field field : objectType.getDeclaredFields()) {
                String name;
                Class<?> type = field.getType();
                if (!GeometryProperty.class.isAssignableFrom(type) && !ImplicitRepresentationProperty.class.isAssignableFrom(type)) continue;
                Integer lod = null;
                if (field.isAnnotationPresent(Lod.class)) {
                    Lod lodProperty = field.getAnnotation(Lod.class);
                    lod = lodProperty.value();
                } else if (getLodFromAttributeName && (name = field.getName()).length() > 3 && name.toLowerCase().startsWith("lod")) {
                    try {
                        lod = Integer.valueOf(name.substring(3, 4));
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    AssociationByRepOrRef property = (AssociationByRepOrRef)field.get(object);
                    if (lod != null) {
                        lods.addRepresentation((int)lod, property);
                        continue;
                    }
                    lods.addRepresentation(property);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        } while ((objectType = objectType.getSuperclass()) != Object.class && objectType != null);
        return lods;
    }
}

