/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.copy.Copyable;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureArrayProperty;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.module.Modules;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.model.module.gml.XLinkModule;
import org.citygml4j.util.child.ChildInfo;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;
import org.citygml4j.util.gmlid.GMLIdManager;
import org.citygml4j.util.transform.FeatureSplitMode;
import org.citygml4j.util.walker.FeatureWalker;
import org.citygml4j.xml.schema.ElementDecl;
import org.citygml4j.xml.schema.Schema;
import org.citygml4j.xml.schema.SchemaHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureSplitter {
    private final Splitter splitter;
    private final List<CityGML> result = new ArrayList<CityGML>();
    private final ChildInfo childInfo;
    private final SplitCopyBuilder copyBuilder;
    private GMLIdManager gmlIdManager;
    private FeatureSplitMode splitMode;
    private Set<Class<? extends CityGML>> excludes;
    private boolean keepInlineAppearance = true;
    private boolean splitCopy = false;

    public FeatureSplitter() {
        this.splitter = new Splitter();
        this.childInfo = new ChildInfo();
        this.copyBuilder = new SplitCopyBuilder();
        this.gmlIdManager = DefaultGMLIdManager.getInstance();
        this.splitMode = FeatureSplitMode.SPLIT_PER_FEATURE;
        this.excludes = new HashSet<Class<? extends CityGML>>();
    }

    public void reset() {
        this.result.clear();
        this.splitter.reset();
        this.splitMode = FeatureSplitMode.SPLIT_PER_FEATURE;
        this.excludes.clear();
        this.keepInlineAppearance = true;
        this.splitCopy = false;
    }

    public FeatureSplitter setSchemaHandler(SchemaHandler schemaHandler) {
        this.splitter.setSchemaHandler(schemaHandler);
        return this;
    }

    public SchemaHandler getSchemaHandler() {
        return this.splitter.getSchemaHandler();
    }

    public FeatureSplitter setGMLIdManager(GMLIdManager gmlIdManager) {
        this.gmlIdManager = gmlIdManager;
        return this;
    }

    public FeatureSplitter setSplitMode(FeatureSplitMode splitMode) {
        if (splitMode == null) {
            throw new IllegalArgumentException("split mode may not be null.");
        }
        this.splitMode = splitMode;
        return this;
    }

    public FeatureSplitMode getSplitMode() {
        return this.splitMode;
    }

    public FeatureSplitter exclude(Class<? extends CityGML> cityGMLClass) {
        this.excludes.add(cityGMLClass);
        return this;
    }

    public FeatureSplitter exclude(Set<Class<? extends CityGML>> excludes) {
        if (excludes == null) {
            throw new IllegalArgumentException("set of excludes may not be null.");
        }
        this.excludes = excludes;
        return this;
    }

    public void clearExcludes() {
        this.excludes.clear();
    }

    public Set<Class<? extends CityGML>> getExcludes() {
        return this.excludes;
    }

    public FeatureSplitter keepInlineAppearance(boolean keepInlineAppearance) {
        this.keepInlineAppearance = keepInlineAppearance;
        return this;
    }

    public boolean isKeepInlineAppearance() {
        return this.keepInlineAppearance;
    }

    public FeatureSplitter splitCopy(boolean splitCopy) {
        this.splitCopy = splitCopy;
        return this;
    }

    public boolean isSplitCopy() {
        return this.splitCopy;
    }

    public List<CityGML> split(Object object) {
        this.result.clear();
        if (this.splitCopy) {
            object = this.copyBuilder.copy(object);
            this.copyBuilder.visited.clear();
        }
        if (object instanceof AbstractFeature) {
            ((AbstractFeature)object).accept(this.splitter);
        } else if (object instanceof ADEGenericElement) {
            this.splitter.visit((ADEGenericElement)object);
        } else if (object instanceof Element) {
            this.splitter.visit((Element)object, null);
        }
        this.splitter.reset();
        return this.result;
    }

    private class Splitter
    extends FeatureWalker {
        private Splitter() {
        }

        @Override
        public void visit(Appearance appearance) {
            if (FeatureSplitter.this.keepInlineAppearance && FeatureSplitter.this.childInfo.getParentCityObject(appearance) != null) {
                return;
            }
            super.visit(appearance);
        }

        @Override
        public void visit(AbstractFeature feature) {
            if (!FeatureSplitter.this.excludes.isEmpty()) {
                for (Class exclude : FeatureSplitter.this.excludes) {
                    if (!exclude.isInstance(feature)) continue;
                    return;
                }
            }
            ModelObject parent = feature.getParent();
            boolean addToResult = false;
            if (FeatureSplitter.this.splitMode == FeatureSplitMode.SPLIT_PER_COLLECTION_MEMBER && feature instanceof ADEModelObject) {
                boolean accept = false;
                for (ADEModule module : Modules.getADEModules()) {
                    if (module.getFeatureName(feature.getClass()) == null) continue;
                    accept = true;
                    break;
                }
                if (!accept) {
                    super.visit(feature);
                    return;
                }
            }
            if (parent != null) {
                if (parent instanceof FeatureProperty) {
                    FeatureProperty property = (FeatureProperty)parent;
                    property.setHref('#' + this.getAndSetGmlId(feature));
                    property.unsetFeature();
                    addToResult = true;
                } else if (parent instanceof FeatureArrayProperty) {
                    FeatureArrayProperty featureArray = (FeatureArrayProperty)parent;
                    featureArray.unsetFeature(feature);
                    addToResult = true;
                }
            } else {
                addToResult = true;
            }
            if (addToResult && feature instanceof CityGML) {
                FeatureSplitter.this.result.add((CityGML)((Object)feature));
            }
            super.visit(feature);
        }

        @Override
        public void visit(ADEGenericElement adeGenericElement) {
            if (!FeatureSplitter.this.excludes.isEmpty()) {
                for (Class exclude : FeatureSplitter.this.excludes) {
                    if (!exclude.isInstance(adeGenericElement)) continue;
                    return;
                }
            }
            if (adeGenericElement.isSetContent() && this.shouldWalk && this.schemaHandler != null) {
                boolean addToResult = false;
                ModelObject parent = adeGenericElement.getParent();
                if (parent != null) {
                    ElementDecl elementDecl;
                    Schema schema = this.schemaHandler.getSchema(adeGenericElement.getNamespaceURI());
                    if (schema != null && (elementDecl = schema.getElementDecl(adeGenericElement.getLocalName(), null)) != null && this.splitElement(elementDecl)) {
                        if (parent instanceof FeatureProperty) {
                            FeatureProperty property = (FeatureProperty)parent;
                            property.setHref('#' + this.getAndSetGmlId(adeGenericElement.getContent()));
                            property.unsetGenericADEElement();
                            addToResult = true;
                        } else if (parent instanceof FeatureArrayProperty) {
                            FeatureArrayProperty featureArray = (FeatureArrayProperty)parent;
                            featureArray.unsetGenericADEElement(adeGenericElement);
                            addToResult = true;
                        }
                    }
                } else {
                    addToResult = true;
                }
                if (addToResult) {
                    FeatureSplitter.this.result.add(adeGenericElement);
                }
                this.adeGenericElement(adeGenericElement.getContent(), null, null);
            }
        }

        protected void adeGenericElement(Element element, Element parent, ElementDecl lastElement) {
            Schema schema = this.schemaHandler.getSchema(element.getNamespaceURI());
            if (schema != null) {
                ElementDecl tmp = schema.getElementDecl(element.getLocalName(), lastElement);
                if (tmp != null && parent != null && lastElement != null && this.splitElement(tmp, parent) && lastElement.hasXLinkAttribute()) {
                    parent.setAttributeNS(XLinkModule.v3_1_1.getNamespaceURI(), "href", '#' + this.getAndSetGmlId(element));
                    parent.removeChild(element);
                    if (parent.getTextContent().trim().length() == 0) {
                        parent.setTextContent("");
                    }
                    FeatureSplitter.this.result.add(new ADEGenericElement(element));
                }
                lastElement = tmp;
            }
            NodeList nodeList = element.getChildNodes();
            ArrayList<Element> children = new ArrayList<Element>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                children.add((Element)node);
            }
            for (Element child : children) {
                this.adeGenericElement(child, element, lastElement);
            }
        }

        private boolean splitElement(ElementDecl elementDecl) {
            boolean split = elementDecl.isFeature();
            if (FeatureSplitter.this.splitMode == FeatureSplitMode.SPLIT_PER_COLLECTION_MEMBER && split) {
                split = elementDecl.isGlobal() && elementDecl.substitutesFeature();
            }
            return split;
        }

        private boolean splitElement(ElementDecl elementDecl, Element parent) {
            boolean split = this.splitElement(elementDecl);
            if (split && FeatureSplitter.this.keepInlineAppearance && parent.getNamespaceURI().startsWith("http://www.opengis.net/citygml") && parent.getLocalName().equals("appearance")) {
                split = false;
            }
            return split;
        }

        private String getAndSetGmlId(AbstractFeature feature) {
            String gmlId = feature.getId();
            if (gmlId == null) {
                gmlId = FeatureSplitter.this.gmlIdManager.generateUUID();
                feature.setId(gmlId);
            }
            return gmlId;
        }

        private String getAndSetGmlId(Element element) {
            String gmlId = element.getAttributeNS(GMLCoreModule.v3_1_1.getNamespaceURI(), "id");
            if (gmlId.length() == 0) {
                gmlId = element.getAttribute("id");
            }
            if (gmlId.length() == 0) {
                gmlId = FeatureSplitter.this.gmlIdManager.generateUUID();
                element.setAttributeNS(GMLCoreModule.v3_1_1.getNamespaceURI(), "id", gmlId);
            }
            return gmlId;
        }
    }

    private class SplitCopyBuilder
    extends CopyBuilder {
        private IdentityHashMap<Object, Object> visited = new IdentityHashMap();

        private SplitCopyBuilder() {
        }

        @Override
        public Object copy(Object target) {
            Object copy = this.visited.get(target);
            if (copy != null) {
                return copy;
            }
            if (target instanceof AbstractFeature || target instanceof FeatureProperty || target instanceof FeatureArrayProperty) {
                copy = ((Copyable)target).copy(this);
            } else if (target instanceof ADEGenericElement) {
                copy = ((Copyable)target).copy(this);
                ADEGenericElement tmp = (ADEGenericElement)copy;
                tmp.setContent((Element)tmp.getContent().cloneNode(true));
            } else {
                copy = target;
            }
            if (copy != null) {
                this.visited.put(target, copy);
            }
            return copy;
        }
    }
}

