/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.xlink;

import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.appearance.AppearanceModuleComponent;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.util.walker.GMLFunctionWalker;
import org.citygml4j.xml.schema.SchemaHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XLinkResolver {
    private SchemaHandler schemaHandler;

    public XLinkResolver setSchemaHandler(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        return this;
    }

    private ModelObject resolveXlink(String target, AbstractGML root, GMLIdWalker walker) {
        if (target == null || target.length() == 0) {
            return null;
        }
        if (root == null) {
            return null;
        }
        return root.accept(walker);
    }

    public ModelObject getObject(String target, AbstractGML root) {
        return this.resolveXlink(target, root, new GMLWalker(this.clipGMLId(target), this.schemaHandler));
    }

    public AbstractGeometry getGeometry(String target, AbstractGML root) {
        ModelObject object = this.resolveXlink(target, root, new GeometryWalker(this.clipGMLId(target), this.schemaHandler));
        return object instanceof AbstractGeometry ? (AbstractGeometry)object : null;
    }

    public AbstractFeature getFeature(String target, AbstractGML root) {
        ModelObject object = this.resolveXlink(target, root, new FeatureWalker(this.clipGMLId(target), this.schemaHandler));
        return object instanceof AbstractFeature ? (AbstractFeature)object : null;
    }

    public <T extends AbstractGML> T getAbstractGML(String target, AbstractGML root, Class<T> type) {
        if (type == null) {
            return null;
        }
        ModelObject object = this.getObject(target, root);
        return (T)(type.isInstance(object) ? (AbstractGML)object : null);
    }

    private String clipGMLId(String target) {
        return target.replaceAll("^.*?#+?", "");
    }

    private static abstract class GMLIdWalker
    extends GMLFunctionWalker<ModelObject> {
        private final String gmlId;

        GMLIdWalker(String gmlId, SchemaHandler schemaHandler) {
            this.gmlId = gmlId;
            this.setSchemaHandler(schemaHandler);
        }

        @Override
        public ModelObject apply(ADEGenericElement adeGenericElement) {
            ADEGenericElement result;
            if (adeGenericElement.isSetContent() && (result = this.adeGenericElement(adeGenericElement.getContent(), null)) != null) {
                return result.getContent() == adeGenericElement.getContent() ? adeGenericElement : result;
            }
            return null;
        }

        protected ADEGenericElement adeGenericElement(Element element, Element parent) {
            String elementId = element.getAttribute("id");
            if (elementId.length() == 0) {
                for (GMLCoreModule gml : GMLCoreModule.getInstances()) {
                    switch (gml.getVersion()) {
                        case v3_1_1: {
                            elementId = element.getAttributeNS(gml.getNamespaceURI(), "id");
                        }
                    }
                    if (elementId.length() <= 0) continue;
                    break;
                }
            }
            if (elementId.length() > 0 && this.gmlId.equals(elementId)) {
                return new ADEGenericElement(element);
            }
            NodeList childs = element.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                ADEGenericElement ade;
                Node node = childs.item(i);
                if (node.getNodeType() != 1 || (ade = this.adeGenericElement((Element)node, element)) == null) continue;
                return ade;
            }
            return null;
        }
    }

    private static final class GeometryWalker
    extends GMLIdWalker {
        GeometryWalker(String gmlId, SchemaHandler schemaHandler) {
            super(gmlId, schemaHandler);
        }

        @Override
        public ModelObject apply(AbstractGeometry abstractGeometry) {
            return abstractGeometry.isSetId() && ((GMLIdWalker)this).gmlId.equals(abstractGeometry.getId()) ? abstractGeometry : null;
        }

        @Override
        public <E extends AbstractFeature> ModelObject apply(FeatureProperty<E> featureProperty) {
            if (featureProperty.isSetObject() && featureProperty.getObject() instanceof AppearanceModuleComponent) {
                return null;
            }
            return (ModelObject)super.apply(featureProperty);
        }

        @Override
        public ModelObject apply(AbstractFeature abstractFeature) {
            if (abstractFeature instanceof AppearanceModuleComponent) {
                return null;
            }
            return (ModelObject)super.apply(abstractFeature);
        }
    }

    private static final class FeatureWalker
    extends GMLIdWalker {
        FeatureWalker(String gmlId, SchemaHandler schemaHandler) {
            super(gmlId, schemaHandler);
        }

        @Override
        public ModelObject apply(AbstractFeature abstractFeature) {
            return abstractFeature.isSetId() && ((GMLIdWalker)this).gmlId.equals(abstractFeature.getId()) ? abstractFeature : null;
        }
    }

    private static final class GMLWalker
    extends GMLIdWalker {
        GMLWalker(String gmlId, SchemaHandler schemaHandler) {
            super(gmlId, schemaHandler);
        }

        @Override
        public ModelObject apply(AbstractGML abstractGML) {
            return abstractGML.isSetId() && ((GMLIdWalker)this).gmlId.equals(abstractGML.getId()) ? abstractGML : null;
        }
    }
}

