/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.xml;

import java.lang.reflect.Array;

public class ArrayBuffer<T> {
    private static final int DEFAULT_SIZE = 512;
    private T[] items;
    private ArrayBuffer<T> next;
    private ArrayBuffer<T> previous;
    private int ptr;

    protected ArrayBuffer(Class<T> c, int size, ArrayBuffer<T> previous) {
        this.items = (Object[])Array.newInstance(c, size);
        this.previous = previous;
    }

    protected ArrayBuffer(Class<T> c, int size) {
        this(c, size, null);
    }

    protected ArrayBuffer(Class<T> c, ArrayBuffer<T> previous) {
        this(c, 512, previous);
    }

    protected ArrayBuffer(Class<T> c) {
        this(c, 512, null);
    }

    public int size() {
        return this.items.length;
    }

    public int currentPtr() {
        return this.ptr;
    }

    public void decrementPtr() {
        if (this.ptr > 0) {
            --this.ptr;
        }
    }

    public ArrayBuffer<T> nextBuffer() {
        return this.next;
    }

    public ArrayBuffer<T> previousBuffer() {
        return this.previous;
    }

    public void dropPreviousBuffer() {
        this.previous = null;
    }

    public ArrayBuffer<T> appendBuffer() {
        ArrayBuffer next = new ArrayBuffer(this.items.getClass().getComponentType(), this.items.length, this);
        this.next = next;
        return next;
    }

    public ArrayBuffer<T> rewindToHeadBuffer() {
        ArrayBuffer<T> head = this;
        this.ptr = 1;
        while (head.previous != null) {
            head = head.previous;
            head.ptr = 1;
        }
        return head;
    }

    public ArrayBuffer<T> dropBuffer() {
        if (this.previous == null) {
            return this;
        }
        ArrayBuffer<T> previous = this.previous;
        previous.next = null;
        return previous;
    }

    public void push(T item) {
        if (this.ptr == this.items.length) {
            throw new IllegalStateException("Cannot push onto a full buffer.");
        }
        this.items[this.ptr++] = item;
    }

    public T peek() {
        if (this.ptr == 0) {
            return this.previous != null ? (T)this.previous.peek() : null;
        }
        return this.items[this.ptr - 1];
    }

    public T pop() {
        if (this.ptr == 0) {
            throw new IllegalStateException("Cannot pop from on an empty buffer.");
        }
        T tmp = this.items[--this.ptr];
        this.items[this.ptr] = null;
        return tmp;
    }

    public T next(boolean release) {
        if (this.ptr == 0) {
            throw new IllegalStateException("Cannot call next on an empty buffer.");
        }
        T tmp = this.items[this.ptr - 1];
        if (release) {
            this.items[this.ptr - 1] = null;
        }
        ++this.ptr;
        return tmp;
    }
}

