/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.xml;

import javax.xml.namespace.QName;
import org.citygml4j.util.xml.SAXEventBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class SAXFragmentWriter
extends XMLFilterImpl {
    private final ContentHandler writer;
    private final QName breakElement;
    private WriteMode mode;
    private boolean shouldWrite;
    private boolean hasStartElement;

    public SAXFragmentWriter(QName breakElement, ContentHandler writer, WriteMode mode) {
        this.breakElement = breakElement;
        this.writer = writer;
        this.mode = mode;
        this.shouldWrite = mode == WriteMode.HEAD;
    }

    public SAXFragmentWriter(QName breakElement, ContentHandler writer) {
        this(breakElement, writer, WriteMode.HEAD);
    }

    public WriteMode getWriteMode() {
        return this.mode;
    }

    public void setWriteMode(WriteMode mode) {
        this.mode = mode;
        this.shouldWrite = mode == WriteMode.HEAD;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.shouldWrite) {
            this.writer.characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.shouldWrite && this.mode == WriteMode.TAIL) {
            this.writer.endDocument();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.mode == WriteMode.HEAD && localName.equals(this.breakElement.getLocalPart()) && uri.equals(this.breakElement.getNamespaceURI())) {
            this.shouldWrite = false;
        }
        if (this.shouldWrite) {
            if (!this.hasStartElement && this.writer instanceof SAXEventBuffer) {
                ((SAXEventBuffer)this.writer).addEndElement(uri, localName);
                return;
            }
            this.writer.endElement(uri, localName, qName);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.shouldWrite) {
            this.writer.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.shouldWrite && this.mode == WriteMode.HEAD) {
            this.writer.startDocument();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.shouldWrite) {
            this.writer.startElement(uri, localName, qName, atts);
            this.hasStartElement = true;
        }
        if (this.mode == WriteMode.TAIL && localName.equals(this.breakElement.getLocalPart()) && uri.equals(this.breakElement.getNamespaceURI())) {
            this.shouldWrite = true;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.shouldWrite) {
            this.writer.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.shouldWrite) {
            this.writer.startPrefixMapping(prefix, uri);
        }
    }

    public static enum WriteMode {
        HEAD,
        TAIL;

    }
}

