/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.xml;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;
import org.citygml4j.xml.CityGMLNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class SAXWriter
extends XMLFilterImpl
implements AutoCloseable {
    private final String OPEN_COMMENT = "<!--";
    private final String END_COMMENT = "-->";
    private final String XML_DECL_ENCODING = " encoding=";
    private final String XML_DECL_VERSION = " version=\"1.0\"";
    private final String XML_DECL_STANDALONE = " standalone=\"yes\"";
    private final String OPEN_XML_DECL = "<?xml";
    private final String CLOSE_XML_DECL = "?>";
    private final char CLOSE_START_TAG = (char)62;
    private final char OPEN_START_TAG = (char)60;
    private final String OPEN_END_TAG = "</";
    private final char CLOSE_END_TAG = (char)62;
    private final String OPEN_PI = "<?";
    private final String CLOSE_PI = "?>";
    private final String CLOSE_EMPTY_ELEMENT = "/>";
    private final String SPACE = " ";
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String SCHEMA_LOCATION_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private final String SCHEMA_LOCATION = "schemaLocation";
    private final String SCHEMA_LOCATION_NS_PREFIX = "xsi";
    private Writer writer;
    private CharsetEncoder charsetEncoder;
    private String streamEncoding;
    private CityGMLNamespaceContext userDefinedNS;
    private NamespaceSupport reportedNS;
    private LocalNamespaceContext localNS;
    private boolean needNSContext = true;
    private boolean writeReportedNamespaces = false;
    private boolean escapeCharacters = true;
    private boolean writeEncoding = false;
    private boolean writeXMLDecl = true;
    private String indent;
    private String[] headerComment;
    private HashMap<String, String> schemaLocations;
    private int depth = 0;
    private int nsCounter = 1;
    private XMLContentType lastXMLContent;

    public SAXWriter() {
        this.init();
    }

    public SAXWriter(StreamResult streamResult, String encoding) throws IOException {
        this();
        this.setOutput(streamResult, encoding);
    }

    public SAXWriter(OutputStream outputStream) throws IOException {
        this(outputStream, null);
    }

    public SAXWriter(OutputStream outputStream, String encoding) throws IOException {
        this();
        this.setOutput(outputStream, encoding);
    }

    public SAXWriter(Writer writer) throws IOException {
        this();
        this.setOutput(writer);
    }

    private void init() {
        this.userDefinedNS = new CityGMLNamespaceContext();
        this.reportedNS = new NamespaceSupport();
        this.localNS = new LocalNamespaceContext();
        this.schemaLocations = new HashMap();
        this.lastXMLContent = XMLContentType.UNDEFINED;
    }

    public void reset() {
        this.userDefinedNS.reset();
        this.reportedNS.reset();
        this.localNS.reset();
        this.streamEncoding = null;
        this.needNSContext = true;
        this.writeReportedNamespaces = false;
        this.escapeCharacters = true;
        this.writeEncoding = false;
        this.writeXMLDecl = true;
        this.indent = null;
        this.headerComment = null;
        this.schemaLocations.clear();
        this.depth = 0;
        this.nsCounter = 1;
        this.lastXMLContent = XMLContentType.UNDEFINED;
    }

    public void setOutput(StreamResult streamResult) throws IOException {
        this.setOutput(streamResult, null);
    }

    public void setOutput(StreamResult streamResult, String encoding) throws IOException {
        if (streamResult.getOutputStream() != null) {
            this.setOutput(streamResult.getOutputStream(), encoding);
        } else if (streamResult.getWriter() != null) {
            this.setOutput(streamResult.getWriter());
        } else if (streamResult.getSystemId() != null) {
            this.setOutput(new FileOutputStream(streamResult.getSystemId()), encoding);
        }
    }

    public void setOutput(Writer writer) {
        this.writer = writer;
        if (writer instanceof OutputStreamWriter) {
            this.writer = new BufferedWriter(writer);
            String encoding = ((OutputStreamWriter)writer).getEncoding();
            if (encoding != null) {
                Charset charset = Charset.forName(encoding);
                this.streamEncoding = charset.name();
                this.writeEncoding = true;
                if (!this.streamEncoding.equalsIgnoreCase("utf-8")) {
                    this.charsetEncoder = charset.newEncoder();
                }
            }
        }
    }

    public void setOutput(OutputStream outputStream) throws IOException {
        this.setOutput(outputStream, null);
    }

    public void setOutput(OutputStream outputStream, String encoding) throws IOException {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding != null) {
            Charset charset = Charset.forName(encoding);
            this.streamEncoding = charset.name();
            this.writeEncoding = true;
            this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
            if (!this.streamEncoding.equalsIgnoreCase("utf-8")) {
                this.charsetEncoder = charset.newEncoder();
            }
        }
    }

    public Writer getOutputWriter() {
        return this.writer;
    }

    public void flush() throws SAXException {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void close() throws SAXException {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.writer = null;
        this.charsetEncoder = null;
        this.userDefinedNS.reset();
        this.reportedNS.reset();
        this.localNS.reset();
        this.headerComment = null;
        this.schemaLocations.clear();
    }

    public boolean isEscapeCharacters() {
        return this.escapeCharacters;
    }

    public void setEscapeCharacters(boolean escapeCharacters) {
        this.escapeCharacters = escapeCharacters;
    }

    public boolean isWriteReportedNamespaces() {
        return this.writeReportedNamespaces;
    }

    public void setWriteReportedNamespaces(boolean writeReportedNamespaces) {
        this.writeReportedNamespaces = writeReportedNamespaces;
    }

    public void setNamespaceContext(CityGMLNamespaceContext context) {
        if (context == null) {
            throw new IllegalArgumentException("namespace context may not be null.");
        }
        this.userDefinedNS = context;
        if (this.depth > 0) {
            Iterator<String> iter = this.userDefinedNS.getNamespaceURIs();
            while (iter.hasNext()) {
                String userDefinedURI = iter.next();
                this.localNS.declarePrefix(this.userDefinedNS.getPrefix(userDefinedURI), userDefinedURI);
            }
        }
    }

    public CityGMLNamespaceContext getNamespaceContext() {
        return this.userDefinedNS;
    }

    public void setPrefix(String prefix, String uri) {
        if (prefix == null || uri == null) {
            return;
        }
        if (this.depth == 0) {
            this.userDefinedNS.setPrefix(prefix, uri);
        }
        this.localNS.declarePrefix(prefix, uri);
    }

    public String getPrefix(String uri) {
        String prefix = this.userDefinedNS.getPrefix(uri);
        if (prefix == null) {
            prefix = this.getReportedPrefix(uri);
        }
        return prefix;
    }

    public String getNamespaceURI(String prefix) {
        String uri = this.userDefinedNS.getNamespaceURI(prefix);
        if (uri.equals("")) {
            uri = this.getReportedURI(prefix);
        }
        return uri;
    }

    public void setDefaultNamespace(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("namespace URI may not be null.");
        }
        if (this.depth == 0) {
            this.userDefinedNS.setDefaultNamespace(uri);
        }
        this.localNS.declarePrefix("", uri);
    }

    public String getIndentString() {
        return this.indent;
    }

    public void setIndentString(String indent) {
        if (indent == null) {
            throw new IllegalArgumentException("indentation string may not be null.");
        }
        this.indent = indent;
    }

    public boolean isWriteEncoding() {
        return this.writeEncoding;
    }

    public void setWriteEncoding(boolean writeEncoding) {
        this.writeEncoding = writeEncoding;
    }

    public boolean isWriteXMLDecl() {
        return this.writeXMLDecl;
    }

    public void setWriteXMLDecl(boolean writeXMLDecl) {
        this.writeXMLDecl = writeXMLDecl;
    }

    public void setHeaderComment(String ... headerMessage) {
        if (headerMessage == null) {
            throw new IllegalArgumentException("header comment may not be null.");
        }
        this.headerComment = headerMessage;
    }

    public String[] getHeaderComment() {
        return this.headerComment;
    }

    public void unsetHeaderComment() {
        this.headerComment = null;
    }

    public void setSchemaLocation(String namespaceURI, String schemaLocation) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespace URI may not be null.");
        }
        if (schemaLocation == null || schemaLocation.trim().isEmpty()) {
            return;
        }
        this.schemaLocations.put(namespaceURI, schemaLocation);
    }

    public String getSchemaLocation(String namespaceURI) {
        return this.schemaLocations.get(namespaceURI);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (length > 0) {
                if (this.lastXMLContent == XMLContentType.START_ELEMENT) {
                    this.writer.write(62);
                }
                this.writeXMLContent(ch, start, length, this.escapeCharacters);
                this.lastXMLContent = XMLContentType.CHARACTERS;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            --this.depth;
            if (this.lastXMLContent == XMLContentType.START_ELEMENT) {
                this.writer.write("/>");
            } else {
                if (this.lastXMLContent == XMLContentType.END_ELEMENT) {
                    this.writeIndent();
                }
                this.writer.write("</");
                this.writeQName(this.localNS.getPrefix(uri), localName);
                this.writer.write(62);
            }
            this.lastXMLContent = XMLContentType.END_ELEMENT;
            this.localNS.popContext();
            this.reportedNS.popContext();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.lastXMLContent != XMLContentType.END_ELEMENT) {
                if (length > 0 && this.lastXMLContent == XMLContentType.START_ELEMENT) {
                    this.writer.write(62);
                }
                this.writeXMLContent(ch, start, length, this.escapeCharacters);
                this.lastXMLContent = XMLContentType.CHARACTERS;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.lastXMLContent == XMLContentType.START_ELEMENT) {
                this.writer.write(62);
                this.writeIndent();
            }
            if (target == null || data == null) {
                throw new SAXException("PI target cannot be null.");
            }
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(" ");
            this.writer.write(data);
            this.writer.write("?>");
            this.writeIndent();
            this.lastXMLContent = XMLContentType.PI;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            if (this.depth == 0) {
                if (this.writeXMLDecl) {
                    if (this.streamEncoding == null && this.writer instanceof OutputStreamWriter) {
                        this.streamEncoding = ((OutputStreamWriter)this.writer).getEncoding();
                        if (this.streamEncoding != null) {
                            this.streamEncoding = Charset.forName(this.streamEncoding).name();
                        }
                    }
                    this.writer.write("<?xml");
                    this.writer.write(" version=\"1.0\"");
                    if (this.writeEncoding && this.streamEncoding != null) {
                        this.writer.write(" encoding=");
                        this.writer.write("\"");
                        this.writer.write(this.streamEncoding);
                        this.writer.write("\"");
                    }
                    this.writer.write(" standalone=\"yes\"");
                    this.writer.write("?>");
                    this.writeIndent();
                    this.lastXMLContent = XMLContentType.PI;
                }
                if (this.headerComment != null) {
                    this.writeHeader(this.headerComment);
                    this.lastXMLContent = XMLContentType.COMMENT;
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (this.needNSContext) {
                this.reportedNS.pushContext();
            }
            if (this.depth > 0) {
                if (this.lastXMLContent == XMLContentType.START_ELEMENT) {
                    this.writer.write(62);
                }
                this.writeIndent();
            } else if (this.depth == 0) {
                Iterator<String> iter = this.userDefinedNS.getNamespaceURIs();
                while (iter.hasNext()) {
                    String userDefinedURI = iter.next();
                    this.localNS.declarePrefix(this.userDefinedNS.getPrefix(userDefinedURI), userDefinedURI);
                }
            }
            this.writer.write(60);
            boolean writeLocalNS = false;
            String prefix = this.localNS.getPrefix(uri);
            if (prefix == null) {
                prefix = this.getReportedPrefix(uri);
                if (prefix == null) {
                    throw new IllegalStateException("namespace URI " + uri + " is not bound to a prefix.");
                }
                writeLocalNS = true;
            }
            this.writeQName(prefix, localName);
            if (this.depth == 0) {
                this.writeDeclaredNamespaces();
                this.writeSchemaLocations();
            }
            if (writeLocalNS) {
                this.localNS.declarePrefix(prefix, uri);
                this.writeNamespace(prefix, uri);
            }
            if (this.writeReportedNamespaces && this.depth > 0) {
                this.writeReportedNamespaces();
            }
            this.writeAttributes(atts);
            this.lastXMLContent = XMLContentType.START_ELEMENT;
            this.needNSContext = true;
            ++this.depth;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.needNSContext) {
            this.reportedNS.pushContext();
            this.needNSContext = false;
        }
        if (this.getReportedPrefix(uri) == null) {
            this.reportedNS.declarePrefix(prefix, uri);
        }
    }

    private String getReportedPrefix(String uri) {
        String prefix = this.reportedNS.getPrefix(uri);
        if (prefix == null && uri.equals(this.reportedNS.getURI(""))) {
            prefix = "";
        }
        return prefix;
    }

    private String getReportedURI(String prefix) {
        return this.reportedNS.getURI(prefix);
    }

    private void writeAttributes(Attributes atts) throws SAXException {
        try {
            for (int i = 0; i < atts.getLength(); ++i) {
                String localName = atts.getLocalName(i);
                String uri = atts.getURI(i);
                String prefix = null;
                if (uri != null && uri.length() > 0) {
                    if (uri.equals("http://www.w3.org/2000/xmlns/")) continue;
                    prefix = this.localNS.getPrefix(uri);
                    if (prefix == null) {
                        prefix = this.getReportedPrefix(uri);
                        this.localNS.declarePrefix(prefix, uri);
                        this.writeNamespace(prefix, uri);
                    }
                }
                this.writer.write(" ");
                this.writeQName(prefix, localName);
                this.writer.write("=\"");
                this.writeXMLContent(atts.getValue(i), true, true);
                this.writer.write(34);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeQName(String prefix, String localName) throws SAXException {
        try {
            if (prefix != null && !prefix.equals("")) {
                this.writer.write(prefix);
                this.writer.write(58);
            }
            this.writer.write(localName);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeDeclaredNamespaces() throws SAXException {
        Iterator<String> iter = this.userDefinedNS.getNamespaceURIs();
        while (iter.hasNext()) {
            String uri = iter.next();
            String prefix = this.userDefinedNS.getPrefix(uri);
            this.writeNamespace(prefix, uri);
        }
    }

    private void writeReportedNamespaces() throws SAXException {
        Enumeration<String> e = this.reportedNS.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String reportedPrefix = e.nextElement().toString();
            String reportedUri = this.reportedNS.getURI(reportedPrefix);
            if (this.userDefinedNS.getPrefix(reportedUri) != null || this.localNS.getPrefix(reportedUri) != null) continue;
            if (this.userDefinedNS.containsPrefix(reportedPrefix) || this.localNS.containsPrefix(reportedPrefix)) {
                reportedPrefix = reportedPrefix + this.nsCounter++;
            }
            this.localNS.declarePrefix(reportedPrefix, reportedUri);
            this.writeNamespace(reportedPrefix, reportedUri);
        }
    }

    private void writeNamespace(String prefix, String uri) throws SAXException {
        if (prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        try {
            this.writer.write(" ");
            this.writer.write("xmlns");
            if (prefix.length() > 0) {
                this.writer.write(58);
                this.writer.write(prefix);
            }
            this.writer.write("=\"");
            this.writeXMLContent(uri, true, true);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void writeSchemaLocations() throws SAXException {
        if (!this.schemaLocations.isEmpty()) {
            try {
                String uri = "http://www.w3.org/2001/XMLSchema-instance";
                String prefix = this.localNS.getPrefix(uri);
                if (prefix == null) {
                    prefix = "xsi";
                    this.localNS.declarePrefix(prefix, uri);
                    this.writeNamespace(prefix, uri);
                }
                this.writer.write(" ");
                this.writeQName(prefix, "schemaLocation");
                this.writer.write("=\"");
                Iterator<Map.Entry<String, String>> iter = this.schemaLocations.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    this.writeXMLContent(entry.getKey(), true, true);
                    this.writer.write(" ");
                    this.writeXMLContent(entry.getValue(), true, true);
                    if (!iter.hasNext()) continue;
                    this.writer.write(" ");
                }
                this.writer.write(34);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    public void writeHeader(String ... data) throws SAXException {
        try {
            if (this.lastXMLContent == XMLContentType.START_ELEMENT) {
                this.writer.write(62);
                this.writeIndent();
            }
            if (data == null) {
                throw new SAXException("comment target cannot be null.");
            }
            for (String line : data) {
                if (line == null) continue;
                this.writer.write("<!--");
                this.writer.write(" ");
                this.writer.write(line);
                this.writer.write(" ");
                this.writer.write("-->");
                this.writeIndent();
            }
            this.lastXMLContent = XMLContentType.COMMENT;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeIndent() throws SAXException {
        if (this.indent == null || this.indent.length() == 0) {
            return;
        }
        if (this.lastXMLContent == XMLContentType.CHARACTERS) {
            return;
        }
        try {
            this.writer.write(this.LINE_SEPARATOR);
            for (int i = 0; i < this.depth; ++i) {
                this.writer.write(this.indent);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeXMLContent(char[] content, int start, int length, boolean escapeChars) throws IOException {
        if (!escapeChars) {
            this.writer.write(content, start, length);
            return;
        }
        int startWritePos = start;
        int end = start + length;
        block5: for (int index = start; index < end; ++index) {
            char ch = content[index];
            if (this.charsetEncoder != null && !this.charsetEncoder.canEncode(ch)) {
                this.writer.write(content, startWritePos, index - startWritePos);
                this.writer.write("&#x");
                this.writer.write(Integer.toHexString(ch));
                this.writer.write(59);
                startWritePos = index + 1;
                continue;
            }
            switch (ch) {
                case '<': {
                    this.writer.write(content, startWritePos, index - startWritePos);
                    this.writer.write("&lt;");
                    startWritePos = index + 1;
                    continue block5;
                }
                case '&': {
                    this.writer.write(content, startWritePos, index - startWritePos);
                    this.writer.write("&amp;");
                    startWritePos = index + 1;
                    continue block5;
                }
                case '>': {
                    this.writer.write(content, startWritePos, index - startWritePos);
                    this.writer.write("&gt;");
                    startWritePos = index + 1;
                }
            }
        }
        this.writer.write(content, startWritePos, end - startWritePos);
    }

    private void writeXMLContent(String content, boolean escapeChars, boolean escapeDoubleQuotes) throws IOException {
        if (!escapeChars) {
            this.writer.write(content);
            return;
        }
        int startWritePos = 0;
        int end = content.length();
        block6: for (int index = 0; index < end; ++index) {
            char ch = content.charAt(index);
            if (this.charsetEncoder != null && !this.charsetEncoder.canEncode(ch)) {
                this.writer.write(content, startWritePos, index - startWritePos);
                this.writer.write("&#x");
                this.writer.write(Integer.toHexString(ch));
                this.writer.write(59);
                startWritePos = index + 1;
                continue;
            }
            switch (ch) {
                case '<': {
                    this.writer.write(content, startWritePos, index - startWritePos);
                    this.writer.write("&lt;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '&': {
                    this.writer.write(content, startWritePos, index - startWritePos);
                    this.writer.write("&amp;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '>': {
                    this.writer.write(content, startWritePos, index - startWritePos);
                    this.writer.write("&gt;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '\"': {
                    this.writer.write(content, startWritePos, index - startWritePos);
                    if (escapeDoubleQuotes) {
                        this.writer.write("&quot;");
                    } else {
                        this.writer.write(34);
                    }
                    startWritePos = index + 1;
                }
            }
        }
        this.writer.write(content, startWritePos, end - startWritePos);
    }

    private class LocalNamespaceMap {
        private HashMap<String, String> namespaces;
        private int level;

        LocalNamespaceMap(int level) {
            this.level = level;
            this.namespaces = new HashMap();
        }
    }

    private class LocalNamespaceContext {
        Deque<LocalNamespaceMap> contexts = new ArrayDeque<LocalNamespaceMap>();

        private LocalNamespaceContext() {
        }

        void pushContext() {
            if (this.contexts.isEmpty() || this.contexts.getFirst().level != SAXWriter.this.depth) {
                this.contexts.push(new LocalNamespaceMap(SAXWriter.this.depth));
            }
        }

        void popContext() {
            if (!this.contexts.isEmpty() && this.contexts.getFirst().level == SAXWriter.this.depth) {
                this.contexts.pop();
            }
        }

        void reset() {
            this.contexts.clear();
        }

        void declarePrefix(String prefix, String uri) {
            this.pushContext();
            this.contexts.getFirst().namespaces.put(uri, prefix);
        }

        String getPrefix(String uri) {
            for (LocalNamespaceMap context : this.contexts) {
                String prefix = (String)context.namespaces.get(uri);
                if (prefix == null) continue;
                if (context != this.contexts.getFirst()) {
                    for (LocalNamespaceMap recent : this.contexts) {
                        if (recent == context) break;
                        if (!recent.namespaces.values().contains(prefix)) continue;
                        return null;
                    }
                }
                return prefix;
            }
            return null;
        }

        boolean containsPrefix(String prefix) {
            for (LocalNamespaceMap context : this.contexts) {
                if (!context.namespaces.containsValue(prefix)) continue;
                return true;
            }
            return false;
        }
    }

    private static enum XMLContentType {
        UNDEFINED,
        START_ELEMENT,
        END_ELEMENT,
        CHARACTERS,
        PI,
        COMMENT;

    }
}

