/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.citygml4j.util.xml.SAXEventBuffer;

public class StAXStream2SAX {
    private final SAXEventBuffer buffer;

    public StAXStream2SAX(SAXEventBuffer buffer) {
        this.buffer = buffer;
    }

    public void bridgeEvent(XMLStreamReader reader) throws XMLStreamException {
        switch (reader.getEventType()) {
            case 1: {
                this.handleStartElement(reader);
                break;
            }
            case 2: {
                this.handleEndElement(reader);
                break;
            }
            case 4: {
                this.handleCharacters(reader);
            }
        }
    }

    private void handleCharacters(XMLStreamReader reader) throws XMLStreamException {
        int len;
        char[] buf = new char[reader.getTextLength()];
        int start = 0;
        do {
            len = reader.getTextCharacters(start, buf, 0, buf.length);
            start += len;
        } while (len == buf.length);
        this.buffer.addCharacters(buf);
    }

    private void handleEndElement(XMLStreamReader reader) throws XMLStreamException {
        this.buffer.addEndElement();
    }

    private void handleStartElement(XMLStreamReader reader) throws XMLStreamException {
        int i;
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            this.buffer.addNamespacePrefixMapping(reader.getNamespaceURI(i), reader.getNamespacePrefix(i));
        }
        this.buffer.addStartElement(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix());
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            this.buffer.addAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributePrefix(i), reader.getAttributeType(i), reader.getAttributeValue(i));
        }
    }
}

