/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.schema;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.citygml4j.model.module.citygml.CoreModule;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.model.module.gml.XLinkModule;
import org.citygml4j.xml.schema.Schema;
import org.citygml4j.xml.schema.SchemaWalker;

public class ElementDecl {
    private final XSElementDecl element;
    private final Schema schema;
    private final EnumSet<TypeFlag> typeFlag;

    public ElementDecl(XSElementDecl decl, Schema schema) {
        this.element = decl;
        this.schema = schema;
        this.typeFlag = EnumSet.noneOf(TypeFlag.class);
    }

    public XSElementDecl getXSElementDecl() {
        return this.element;
    }

    public boolean isGlobal() {
        return this.element.isGlobal();
    }

    public boolean isLocal() {
        return this.element.isLocal();
    }

    public boolean isAbstract() {
        return this.element.isAbstract();
    }

    public String getNamespaceURI() {
        return this.element.getTargetNamespace();
    }

    public String getLocalName() {
        return this.element.getName();
    }

    public QName getSubsitutionGroup() {
        XSElementDecl head = this.element.getSubstAffiliation();
        return head != null ? new QName(head.getTargetNamespace(), head.getName()) : null;
    }

    public QName getRootSubsitutionGroup() {
        XSElementDecl tmp = this.element;
        XSElementDecl head = null;
        while ((tmp = tmp.getSubstAffiliation()) != null) {
            head = tmp;
        }
        return head != null ? new QName(head.getTargetNamespace(), head.getName()) : null;
    }

    public boolean substitutes(String namespaceURI, String localName) {
        XSElementDecl tmp = this.element;
        while ((tmp = tmp.getSubstAffiliation()) != null) {
            if (!namespaceURI.equals(tmp.getTargetNamespace()) || !localName.equals(tmp.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean substitutesFeature() {
        boolean substitutesFeature = false;
        for (GMLCoreModule module : GMLCoreModule.getInstances()) {
            switch (module.getVersion()) {
                case v3_1_1: {
                    substitutesFeature = this.substitutes(module.getNamespaceURI(), "_Feature");
                }
            }
            if (!substitutesFeature) continue;
            break;
        }
        return substitutesFeature;
    }

    public boolean substitutesGeometry() {
        boolean substitutesGeometry = false;
        for (GMLCoreModule module : GMLCoreModule.getInstances()) {
            switch (module.getVersion()) {
                case v3_1_1: {
                    substitutesGeometry = this.substitutes(module.getNamespaceURI(), "_Geometry");
                }
            }
            if (!substitutesGeometry) continue;
            break;
        }
        return substitutesGeometry;
    }

    public boolean isAbstractGML() {
        if (this.typeFlag.contains((Object)TypeFlag.ABSTRACT_GML)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_ABSTRACT_GML)) {
            return false;
        }
        boolean isAbstractGML = false;
        for (GMLCoreModule module : GMLCoreModule.getInstances()) {
            XSSchema gml = this.schema.schemaSet.getSchema(module.getNamespaceURI());
            if (gml == null) continue;
            switch (module.getVersion()) {
                case v3_1_1: {
                    isAbstractGML = this.isDerivedFromComplexType(gml, "AbstractGMLType");
                }
            }
            if (!isAbstractGML) continue;
            break;
        }
        if (isAbstractGML) {
            this.typeFlag.add(TypeFlag.ABSTRACT_GML);
        } else {
            this.typeFlag.add(TypeFlag.NO_ABSTRACT_GML);
            this.typeFlag.add(TypeFlag.NO_FEATURE);
            this.typeFlag.add(TypeFlag.NO_FEATURE_COLLECTION);
            this.typeFlag.add(TypeFlag.NO_CITY_OBJECT);
            this.typeFlag.add(TypeFlag.NO_GEOMETRY);
        }
        return isAbstractGML;
    }

    public boolean isFeature() {
        if (this.typeFlag.contains((Object)TypeFlag.FEATURE)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_FEATURE)) {
            return false;
        }
        boolean isFeature = false;
        for (GMLCoreModule module : GMLCoreModule.getInstances()) {
            XSSchema gml = this.schema.schemaSet.getSchema(module.getNamespaceURI());
            if (gml == null) continue;
            switch (module.getVersion()) {
                case v3_1_1: {
                    isFeature = this.isDerivedFromComplexType(gml, "AbstractFeatureType");
                }
            }
            if (!isFeature) continue;
            break;
        }
        if (isFeature) {
            this.typeFlag.add(TypeFlag.ABSTRACT_GML);
            this.typeFlag.add(TypeFlag.FEATURE);
        } else {
            this.typeFlag.add(TypeFlag.NO_FEATURE);
            this.typeFlag.add(TypeFlag.NO_CITY_OBJECT);
        }
        return isFeature;
    }

    public boolean isFeatureCollection() {
        if (this.typeFlag.contains((Object)TypeFlag.FEATURE_COLLECTION)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_FEATURE_COLLECTION)) {
            return false;
        }
        boolean isFeatureCollection = false;
        for (GMLCoreModule module : GMLCoreModule.getInstances()) {
            XSSchema gml = this.schema.schemaSet.getSchema(module.getNamespaceURI());
            if (gml == null) continue;
            switch (module.getVersion()) {
                case v3_1_1: {
                    isFeatureCollection = this.isDerivedFromComplexType(gml, "AbstractFeatureCollectionType");
                }
            }
            if (!isFeatureCollection) continue;
            break;
        }
        if (isFeatureCollection) {
            this.typeFlag.add(TypeFlag.ABSTRACT_GML);
            this.typeFlag.add(TypeFlag.FEATURE);
            this.typeFlag.add(TypeFlag.FEATURE_COLLECTION);
        } else {
            this.typeFlag.add(TypeFlag.NO_FEATURE);
            this.typeFlag.add(TypeFlag.NO_FEATURE_COLLECTION);
        }
        return isFeatureCollection;
    }

    public boolean isGeometry() {
        if (this.typeFlag.contains((Object)TypeFlag.GEOMETRY)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_GEOMETRY)) {
            return false;
        }
        boolean isGeometry = false;
        for (GMLCoreModule module : GMLCoreModule.getInstances()) {
            XSSchema gml = this.schema.schemaSet.getSchema(module.getNamespaceURI());
            if (gml == null) continue;
            switch (module.getVersion()) {
                case v3_1_1: {
                    isGeometry = this.isDerivedFromComplexType(gml, "AbstractGeometryType");
                }
            }
            if (!isGeometry) continue;
            break;
        }
        if (isGeometry) {
            this.typeFlag.add(TypeFlag.ABSTRACT_GML);
            this.typeFlag.add(TypeFlag.GEOMETRY);
        } else {
            this.typeFlag.add(TypeFlag.NO_GEOMETRY);
        }
        return isGeometry;
    }

    public boolean isCityObject() {
        CoreModule module;
        XSSchema core;
        if (this.typeFlag.contains((Object)TypeFlag.CITY_OBJECT)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_CITY_OBJECT)) {
            return false;
        }
        boolean isCityObject = false;
        Iterator<CoreModule> iterator = CoreModule.getInstances().iterator();
        while (iterator.hasNext() && ((core = this.schema.schemaSet.getSchema((module = iterator.next()).getNamespaceURI())) == null || !(isCityObject = this.isDerivedFromComplexType(core, "AbstractCityObjectType")))) {
        }
        if (!isCityObject && this.schema.schemaSet.getSchema("http://www.citygml.org/citygml/1/0/0") != null) {
            isCityObject = this.isDerivedFromComplexType(this.schema.schemaSet.getSchema("http://www.citygml.org/citygml/1/0/0"), "_CityObjectType");
        }
        if (isCityObject) {
            this.typeFlag.add(TypeFlag.ABSTRACT_GML);
            this.typeFlag.add(TypeFlag.FEATURE);
            this.typeFlag.add(TypeFlag.CITY_OBJECT);
        } else {
            this.typeFlag.add(TypeFlag.NO_CITY_OBJECT);
        }
        return isCityObject;
    }

    public boolean isFeatureProperty() {
        if (this.typeFlag.contains((Object)TypeFlag.FEATURE_PROPERTY)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_FEATURE_PROPERTY)) {
            return false;
        }
        boolean isFeatureProperty = false;
        for (XSElementDecl child : this.getChildElements()) {
            block10: {
                block9: {
                    Schema childSchema = this.schema.handler.getSchema(child.getTargetNamespace());
                    List<ElementDecl> childElementDecls = childSchema.getElementDecls(child.getName());
                    if (childElementDecls.size() != 1) break block9;
                    if (!childElementDecls.get(0).isFeature()) break block10;
                    isFeatureProperty = true;
                    break block10;
                }
                for (GMLCoreModule module : GMLCoreModule.getInstances()) {
                    XSSchema gml = this.schema.schemaSet.getSchema(module.getNamespaceURI());
                    if (gml == null) continue;
                    switch (module.getVersion()) {
                        case v3_1_1: {
                            isFeatureProperty = child.getType().isDerivedFrom(gml.getType("AbstractFeatureType"));
                        }
                    }
                    if (!isFeatureProperty) continue;
                    break;
                }
            }
            if (!isFeatureProperty) continue;
            break;
        }
        if (isFeatureProperty) {
            this.typeFlag.add(TypeFlag.FEATURE_PROPERTY);
            this.typeFlag.add(TypeFlag.NO_GEOMETRY_PROPERTY);
        } else {
            this.typeFlag.add(TypeFlag.NO_FEATURE_PROPERTY);
        }
        return isFeatureProperty;
    }

    public boolean isGeometryProperty() {
        if (this.typeFlag.contains((Object)TypeFlag.GEOMETRY_PROPERTY)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_GEOMETRY_PROPERTY)) {
            return false;
        }
        boolean isGeometryProperty = false;
        for (XSElementDecl child : this.getChildElements()) {
            block10: {
                block9: {
                    Schema childSchema = this.schema.handler.getSchema(child.getTargetNamespace());
                    List<ElementDecl> childElementDecls = childSchema.getElementDecls(child.getName());
                    if (childElementDecls.size() != 1) break block9;
                    if (!childElementDecls.get(0).isGeometry()) break block10;
                    isGeometryProperty = true;
                    break block10;
                }
                for (GMLCoreModule module : GMLCoreModule.getInstances()) {
                    XSSchema gml = this.schema.schemaSet.getSchema(module.getNamespaceURI());
                    if (gml == null) continue;
                    switch (module.getVersion()) {
                        case v3_1_1: {
                            isGeometryProperty = child.getType().isDerivedFrom(gml.getType("AbstractGeometryType"));
                        }
                    }
                    if (!isGeometryProperty) continue;
                    break;
                }
            }
            if (!isGeometryProperty) continue;
            break;
        }
        if (isGeometryProperty) {
            this.typeFlag.add(TypeFlag.GEOMETRY_PROPERTY);
            this.typeFlag.add(TypeFlag.NO_FEATURE_PROPERTY);
        } else {
            this.typeFlag.add(TypeFlag.NO_GEOMETRY_PROPERTY);
        }
        return isGeometryProperty;
    }

    public boolean hasXLinkAttribute() {
        if (this.typeFlag.contains((Object)TypeFlag.XLINK)) {
            return true;
        }
        if (this.typeFlag.contains((Object)TypeFlag.NO_XLINK)) {
            return false;
        }
        final boolean[] hasXLink = new boolean[1];
        SchemaWalker walker = new SchemaWalker(){

            @Override
            public void elementDecl(XSElementDecl decl) {
            }

            @Override
            public void attributeDecl(XSAttributeDecl decl) {
                if (XLinkModule.v3_1_1.getNamespaceURI().equals(decl.getTargetNamespace()) && decl.getName().equals("href")) {
                    hasXLink[0] = true;
                    this.setShouldWalk(false);
                }
            }
        };
        this.element.getType().visit((XSVisitor)walker);
        if (hasXLink[0]) {
            this.typeFlag.add(TypeFlag.XLINK);
        } else {
            this.typeFlag.add(TypeFlag.NO_XLINK);
        }
        return hasXLink[0];
    }

    private boolean isDerivedFromComplexType(XSSchema schema, String localPart) {
        XSType base = schema.getType(localPart);
        if (base != null) {
            if (base.isSimpleType()) {
                this.typeFlag.add(TypeFlag.NO_ABSTRACT_GML);
                this.typeFlag.add(TypeFlag.NO_FEATURE);
                this.typeFlag.add(TypeFlag.NO_FEATURE_COLLECTION);
                this.typeFlag.add(TypeFlag.NO_CITY_OBJECT);
                this.typeFlag.add(TypeFlag.NO_GEOMETRY);
                this.typeFlag.add(TypeFlag.NO_FEATURE_PROPERTY);
                this.typeFlag.add(TypeFlag.NO_GEOMETRY_PROPERTY);
                return false;
            }
            return this.element.getType().isDerivedFrom(base);
        }
        return false;
    }

    List<XSElementDecl> getChildElements() {
        final ArrayList<XSElementDecl> childs = new ArrayList<XSElementDecl>();
        SchemaWalker schemaWalker = new SchemaWalker(){

            @Override
            public void elementDecl(XSElementDecl child) {
                childs.add(child);
            }
        };
        this.element.getType().visit((XSVisitor)schemaWalker);
        return childs;
    }

    private static enum TypeFlag {
        ABSTRACT_GML,
        FEATURE,
        FEATURE_COLLECTION,
        CITY_OBJECT,
        GEOMETRY,
        FEATURE_PROPERTY,
        GEOMETRY_PROPERTY,
        XLINK,
        NO_ABSTRACT_GML,
        NO_FEATURE,
        NO_FEATURE_COLLECTION,
        NO_CITY_OBJECT,
        NO_GEOMETRY,
        NO_FEATURE_PROPERTY,
        NO_GEOMETRY_PROPERTY,
        NO_XLINK;

    }
}

