/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.index;

import com.occamlab.te.index.IndexEntry;
import com.occamlab.te.util.DomUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParserEntry
extends IndexEntry {
    boolean initialized;
    String className;
    String method;
    List<Node> classParams = null;

    ParserEntry() {
    }

    ParserEntry(Element parser) throws Exception {
        super(parser);
        Element e = (Element)parser.getElementsByTagName("java").item(0);
        if (e != null) {
            this.setClassName(e.getAttribute("class"));
            this.setMethod(e.getAttribute("method"));
            this.setInitialized(Boolean.parseBoolean(e.getAttribute("initialized")));
            NodeList nl = e.getElementsByTagName("with-param");
            if (nl.getLength() > 0) {
                this.setInitialized(true);
                this.classParams = new ArrayList<Node>();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    Node value = null;
                    NodeList children = el.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node n = children.item(j);
                        if (n.getNodeType() == 3) {
                            value = n;
                        }
                        if (n.getNodeType() != 1) continue;
                        value = DomUtils.createDocument(n);
                        break;
                    }
                    this.classParams.add(value);
                }
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<Node> getClassParams() {
        return this.classParams;
    }

    public void setClassParams(List<Node> classParams) {
        this.classParams = classParams;
    }
}

