/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.occamlab.te.TECore;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.URLConnectionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLProtocolException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTTPParser {
    private static final Logger LOGR = Logger.getLogger(HTTPParser.class.getName());
    public static final String PARSERS_NS = "http://www.occamlab.com/te/parsers";
    public static final String EOS_ERR = "Error in multipart stream.  End of stream reached and with no closing boundary delimiter line";

    private static void append_headers(URLConnection uc, Element e) {
        Document doc = e.getOwnerDocument();
        Element headers = doc.createElement("headers");
        e.appendChild(headers);
        int i = 0;
        while (true) {
            String headerKey = uc.getHeaderFieldKey(i);
            String headerValue = uc.getHeaderField(i);
            if (headerKey == null) {
                if (headerValue == null) {
                    break;
                }
            } else {
                Element header = doc.createElement("header");
                headers.appendChild(header);
                header.setAttribute("name", headerKey);
                header.appendChild(doc.createTextNode(headerValue));
            }
            ++i;
        }
        if (LOGR.isLoggable(Level.FINER)) {
            LOGR.finer(DomUtils.serializeNode(e));
        }
    }

    static Node select_parser(int partnum, String mime, Element instruction) {
        if (null == instruction) {
            return null;
        }
        NodeList instructions = instruction.getElementsByTagNameNS(PARSERS_NS, "parse");
        Node parserNode = null;
        block0: for (int i = 0; i < instructions.getLength(); ++i) {
            String mime_i;
            int n;
            String part_i;
            Element parse = (Element)instructions.item(i);
            if (partnum != 0 && (part_i = parse.getAttribute("part")).length() > 0 && (n = Integer.parseInt(part_i)) != partnum) continue;
            if (mime != null && (mime_i = parse.getAttribute("mime")).length() > 0) {
                String[] mime_parts = mime_i.split(";\\s*");
                if (!mime.startsWith(mime_parts[0])) continue;
                boolean ok = true;
                for (int j = 1; j < mime_parts.length; ++j) {
                    if (mime.indexOf(mime_parts[j]) >= 0) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
            }
            NodeList children = parse.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (children.item(j).getNodeType() != 1) continue;
                parserNode = children.item(j);
                break block0;
            }
        }
        return parserNode;
    }

    private static boolean queue_equals(int[] queue, int qPos, int qLen, int[] value) {
        for (int i = 0; i < qLen; ++i) {
            if (queue[(i + qPos) % qLen] == value[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File create_part_file(Reader in, String boundary) throws Exception {
        File temp = File.createTempFile("$te_", ".tmp");
        RandomAccessFile raf = new RandomAccessFile(temp, "rw");
        int qLen = boundary.length() + 2;
        int[] boundary_queue = new int[qLen];
        boundary_queue[0] = 45;
        boundary_queue[1] = 45;
        for (int i = 0; i < boundary.length(); ++i) {
            boundary_queue[i + 2] = boundary.charAt(i);
        }
        int[] queue = new int[qLen];
        for (int i = 0; i < qLen; ++i) {
            queue[i] = in.read();
            if (queue[i] == -1) break;
        }
        int qPos = 0;
        try {
            while (!HTTPParser.queue_equals(queue, qPos, qLen, boundary_queue)) {
                raf.write(queue[qPos]);
                queue[qPos] = in.read();
                if (queue[qPos] == -1) {
                    raf.close();
                    throw new Exception(EOS_ERR);
                }
                qPos = (qPos + 1) % qLen;
            }
        }
        finally {
            raf.close();
        }
        return temp;
    }

    public static Document parse(URLConnection uc, Element instruction, PrintWriter logger, TECore core) throws Throwable {
        try {
            uc.connect();
        }
        catch (SSLProtocolException sslep) {
            throw new SSLProtocolException("[SSL ERROR] Failed to connect with the requested URL due to \"Invalid server_name\" found!! :" + uc.getURL() + ":" + sslep.getClass() + " : " + sslep.getMessage());
        }
        String mime = uc.getContentType();
        boolean multipart = mime != null && mime.startsWith("multipart");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement(multipart ? "multipart-response" : "response");
        if (uc.getHeaderFieldKey(0) == null) {
            Element status = doc.createElement("status");
            String status_line = uc.getHeaderField(0);
            if (status_line != null) {
                String[] status_array = status_line.split("\\s");
                if (status_array.length > 0) {
                    status.setAttribute("protocol", status_array[0]);
                }
                if (status_array.length > 1) {
                    status.setAttribute("code", status_array[1]);
                }
                if (status_array.length > 2) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 2; i < status_array.length; ++i) {
                        sb.append(status_array[i]);
                        sb.append(" ");
                    }
                    status.appendChild(doc.createTextNode(sb.toString().trim()));
                }
            }
            root.appendChild(status);
        }
        HTTPParser.append_headers(uc, root);
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = tf.newTransformer();
        if (multipart) {
            String mime2 = mime + ";";
            int start = mime2.indexOf("boundary=") + 9;
            int endchar = 59;
            if (mime2.charAt(start) == '\"') {
                ++start;
                endchar = 34;
            }
            int end = mime2.indexOf(endchar, start);
            String boundary = mime2.substring(start, end);
            InputStream is = URLConnectionUtils.getInputStream(uc);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            File temp = HTTPParser.create_part_file(in, boundary);
            temp.delete();
            String line = in.readLine();
            int num = 1;
            while (!line.endsWith("--")) {
                Element content;
                String contentType = "text/plain";
                Element part = doc.createElement("part");
                part.setAttribute("num", Integer.toString(num));
                Element headers = doc.createElement("headers");
                line = in.readLine();
                while (line.length() > 0) {
                    Element header = doc.createElement("header");
                    int colon = line.indexOf(":");
                    String name = line.substring(0, colon);
                    String value = line.substring(colon + 1).trim();
                    if (name.toLowerCase().equals("content-type")) {
                        contentType = value;
                    }
                    header.setAttribute("name", name);
                    header.appendChild(doc.createTextNode(value));
                    headers.appendChild(header);
                    line = in.readLine();
                }
                part.appendChild(headers);
                temp = HTTPParser.create_part_file(in, boundary);
                URLConnection pc = temp.toURI().toURL().openConnection();
                pc.setRequestProperty("Content-type", mime);
                Node parser = HTTPParser.select_parser(num, contentType, instruction);
                Element response_e = core.parse(pc, parser);
                temp.delete();
                Element parser_e = (Element)response_e.getElementsByTagName("parser").item(0);
                if (parser_e != null) {
                    logger.print(parser_e.getTextContent());
                }
                if (null != (content = (Element)response_e.getElementsByTagName("content").item(0)) && content.hasChildNodes()) {
                    t.transform(new DOMSource(content), new DOMResult(part));
                }
                root.appendChild(part);
                line = in.readLine();
                ++num;
            }
            in.close();
        } else {
            Element content;
            Element response_e;
            Element parser_e;
            Node parser = HTTPParser.select_parser(0, uc.getContentType(), instruction);
            if (LOGR.isLoggable(Level.FINER)) {
                String msg = String.format("Calling subsidiary parser for resource at %s:%n%s", uc.getURL(), DomUtils.serializeNode(parser));
                LOGR.finer(msg);
            }
            if ((parser_e = (Element)(response_e = core.parse(uc, parser)).getElementsByTagName("parser").item(0)) != null) {
                logger.print(parser_e.getTextContent());
            }
            if (null != (content = (Element)response_e.getElementsByTagName("content").item(0))) {
                root.appendChild(doc.importNode(content, true));
            }
        }
        doc.appendChild(root);
        return doc;
    }
}

