/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opengis.cite.citygml30part2.CommonFixture;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppearanceModuleValidation
extends CommonFixture {
    final boolean MODULE_ENABLE = true;
    String MODULE_NAME = "Appearance";

    @Test(enabled=true, groups={"Module"})
    public void VerifyAppearanceModule() {
        boolean foundAtLeastOne = ValidationUtils.elementValidation(this.testSubject, this.MODULE_NAME);
        Assert.assertTrue(foundAtLeastOne, "No " + this.MODULE_NAME + " element was found in the document.");
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyAppearanceTarget() throws Exception {
        String expressionTarget = "//app:target/text()";
        NodeList nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionTarget);
        List<String> allowedRef = Arrays.asList("gml:MultiSurface", "gml:AbstractSurface", "gml:CompositeSurface", "gml:OrientableSurface", "gml:Polygon", "gml:PolyhedralSurface", "gml:Surface", "gml:Tin", "gml:TriangulatedSurface");
        boolean flag = true;
        for (int i = 0; i < nodes.getLength() && flag; ++i) {
            String referenceTarget = nodes.item(i).getNodeValue().substring(1);
            String findReferenceExpression = "//*[@gml:id='" + referenceTarget + "']";
            Node node = XMLUtils.getNodeByXPath(this.testSubject, findReferenceExpression);
            if (node == null) {
                flag = false;
                break;
            }
            String nodeName = node.getLocalName();
            if (allowedRef.contains(nodeName)) break;
            flag = false;
        }
        Assert.assertTrue(flag, this.MODULE_NAME + " reference invalid.");
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyAppearanceParameterizedTexture() {
        String expressionTextureCoordList = "//app:TexCoordList/app:textureCoordinates/text()";
        NodeList textureCoordinatesNodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionTextureCoordList);
        boolean allCoordValid = true;
        for (int i = 0; i < textureCoordinatesNodes.getLength() && allCoordValid; ++i) {
            String rawValue = textureCoordinatesNodes.item(i).getNodeValue();
            String[] splitString = rawValue.split(" ");
            if (splitString.length > 2) {
                allCoordValid = false;
                break;
            }
            try {
                Double.parseDouble(splitString[0]);
                Double.parseDouble(splitString[1]);
                continue;
            }
            catch (Exception e) {
                allCoordValid = false;
            }
        }
        Assert.assertTrue(allCoordValid, this.MODULE_NAME + " texture coordinates invalid.");
        String expressionTexCoordList = "//app:TexCoordList";
        NodeList texCoordListNodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionTexCoordList);
        boolean propertiesCountValid = true;
        for (int i = 0; i < texCoordListNodes.getLength() && propertiesCountValid; ++i) {
            NodeList children = texCoordListNodes.item(i).getChildNodes();
            int textureCoordinatesCount = 0;
            int ringCount = 0;
            block12: for (int j = 0; j < children.getLength(); ++j) {
                String childName;
                if (children.item(j).getNodeType() != 1) continue;
                Element childElement = (Element)children.item(j);
                switch (childName = childElement.getNodeName()) {
                    case "app:textureCoordinates": {
                        ++textureCoordinatesCount;
                        continue block12;
                    }
                    case "app:ring": {
                        ++ringCount;
                    }
                }
            }
            if (textureCoordinatesCount == ringCount) continue;
            propertiesCountValid = false;
            System.out.println("number of textureCoordinates and ring properties are NOT identical");
        }
        Assert.assertTrue(propertiesCountValid, this.MODULE_NAME + ": number of textureCoordinates and ring properties are NOT identical");
        String expressionPath = "//app:ring/text()";
        NodeList ringNodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        boolean flag = true;
        for (int i = 0; i < ringNodes.getLength(); ++i) {
            Node currentNode = ringNodes.item(i);
            if (currentNode.getNodeType() != 3) continue;
            String ringContent = currentNode.getTextContent();
            String refId = ringContent.substring(1);
            String ringRefIdExpression = "//*[@gml:id='" + refId + "']";
            Node node = XMLUtils.getNodeByXPath(this.testSubject, ringRefIdExpression);
            if (node.getLocalName().equals("gml:LinearRing")) continue;
            flag = false;
            break;
        }
        Assert.assertTrue(flag, this.MODULE_NAME + " ring reference invalid.");
        boolean valueCountValid = true;
        for (int i = 0; i < ringNodes.getLength() && valueCountValid; ++i) {
            Node currentNode = ringNodes.item(i);
            if (currentNode.getNodeType() != 3) continue;
            String ringContent = currentNode.getTextContent();
            String refId = ringContent.substring(1);
            String ringRefIdExpression = "//*[@gml:id='" + refId + "']";
            Node gmlIdNode = XMLUtils.getNodeByXPath(this.testSubject, ringRefIdExpression);
            if (!gmlIdNode.getNodeName().equals("gml:LinearRing")) continue;
            Node postList = XMLUtils.getNodeByXPath(gmlIdNode, "gml:posList");
            Element postListElement = (Element)postList;
            int srsDimensionValue = Integer.parseInt(postListElement.getAttribute("srsDimension"));
            String rawValue = postListElement.getTextContent();
            rawValue = rawValue.replace("\t", " ").replace("\r", " ").replace("\n", " ");
            ArrayList<String> valueList3d = new ArrayList<String>();
            for (String rawString : rawValue.split(" ")) {
                if (rawString.equals("")) continue;
                valueList3d.add(rawString);
            }
            int lengthOf3D = valueList3d.size() / srsDimensionValue;
            if (valueList3d.size() % srsDimensionValue != 0) {
                System.out.println("value size invalid");
                valueCountValid = false;
                break;
            }
            ArrayList<String> valueList2d = new ArrayList<String>();
            for (String rawString : ringContent.split(" ")) {
                if (rawString.equals("")) continue;
                valueList2d.add(rawString);
            }
            int lengthOf2D = valueList2d.size() / 2;
            if (valueList2d.size() % 2 != 0) {
                System.out.println("value size invalid");
                valueCountValid = false;
                break;
            }
            if (lengthOf2D == lengthOf3D) continue;
            System.out.println("value size not match invalid");
            valueCountValid = false;
            break;
        }
        Assert.assertTrue(valueCountValid, "textureCoordinates value count invalid.");
        String expressionLinearRing = "//gml:LinearRing[@gml:id]";
        NodeList linearRingNodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionLinearRing);
        ArrayList<String> linearRingId = new ArrayList<String>();
        for (int i = 0; i < linearRingNodes.getLength(); ++i) {
            Element element = (Element)linearRingNodes.item(i);
            String id = element.getAttribute("gml:id");
            linearRingId.add(id);
        }
        ArrayList<String> ringRef = new ArrayList<String>();
        for (int i = 0; i < ringNodes.getLength(); ++i) {
            Node currentNode = ringNodes.item(i);
            if (currentNode.getNodeType() != 3) continue;
            String ringContent = currentNode.getTextContent();
            String refId = ringContent.substring(1);
            ringRef.add(refId);
        }
        boolean orderValid = true;
        if (ringRef.size() != linearRingId.size()) {
            System.out.println("Invalid ring size");
            orderValid = false;
        }
        for (int i = 0; i < linearRingId.size() && orderValid; ++i) {
            if (((String)linearRingId.get(i)).equals(ringRef.get(i))) continue;
            orderValid = false;
            break;
        }
        Assert.assertTrue(orderValid, "Ring reference and LinearRing invalid.");
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyAppearanceGeoreferencedtexture() {
        String expressionGeoreferencedTexture = "//app:GeoreferencedTexture";
        NodeList geoRefNodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionGeoreferencedTexture);
        boolean allGeorefencedValid = true;
        for (int i = 0; i < geoRefNodes.getLength(); ++i) {
            Node currentGeoRefNode = geoRefNodes.item(i);
            NodeList children = currentGeoRefNode.getChildNodes();
            ArrayList<String> nodeNameList = new ArrayList<String>();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                nodeNameList.add(child.getNodeName());
            }
            if (nodeNameList.contains("app:referencePoint") || nodeNameList.contains("app:orientation")) {
                if (!nodeNameList.contains("app:referencePoint") || !nodeNameList.contains("app:orientation")) {
                    allGeorefencedValid = false;
                    System.out.println("The geo-reference either inline using the referencePoint and orientation properties or externally inside the texture image (e.g., by using the GeoTIFF image format) or through an accompanying world file.");
                }
            } else if (nodeNameList.contains("app:target")) {
                Node preferNode = XMLUtils.getNodeByXPath(currentGeoRefNode, "app:preferWorldFile");
                if (preferNode != null && preferNode.getNodeValue() == "false") {
                    allGeorefencedValid = false;
                    System.out.println("The preferWorldFile property SHALL not be false if there are referencing a external resource");
                }
            } else {
                allGeorefencedValid = false;
                System.out.println("There are no referencePoint and orientation or external references");
            }
            Assert.assertTrue(allGeorefencedValid, "GeoreferencedTexture invalid.");
            boolean referencePointValid = true;
            block2: for (int a = 0; a < geoRefNodes.getLength(); ++a) {
                Node currentGeoRefNode2 = geoRefNodes.item(a);
                NodeList referencePointNodeList = XMLUtils.getNodeListByXPath(currentGeoRefNode2, "app:referencePoint");
                for (int j = 0; j < referencePointNodeList.getLength(); ++j) {
                    String pointRawValue;
                    String[] pointValues;
                    Node referencePointNode = referencePointNodeList.item(j);
                    Node pointNode = XMLUtils.getNodeByXPath(referencePointNode, "gml:Point/gml:pos/text()");
                    if (pointNode == null) {
                        Element elementRefPoint = (Element)referencePointNode;
                        if (elementRefPoint.hasAttribute("xlink:href")) {
                            String hrefName = elementRefPoint.getAttribute("xlink:href");
                            hrefName = hrefName.replace("#", "");
                            String findReferenceExpression = "//*[@gml:id='" + hrefName + "']";
                            NodeList xlinkNode = XMLUtils.getNodeListByXPath(this.testSubject, findReferenceExpression);
                            if (xlinkNode == null) {
                                referencePointValid = false;
                                System.out.println("The referencePoint property (type: gml:PointPropertyType) SHALL only contain or reference a 2D point geometry.");
                                continue block2;
                            }
                        } else {
                            referencePointValid = false;
                            continue block2;
                        }
                    }
                    if ((pointValues = (pointRawValue = pointNode.getNodeValue()).split(" ")).length <= 2) continue;
                    referencePointValid = false;
                    System.out.println("The referencePoint property (type: gml:PointPropertyType) SHALL only contain or reference a 2D point geometry.");
                }
            }
            Assert.assertTrue(referencePointValid, "The referencePoint property invalid");
        }
    }
}

