/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.module;

import java.util.ArrayList;
import java.util.List;
import org.opengis.cite.citygml30part2.CommonFixture;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VersioningModuleValidation
extends CommonFixture {
    final boolean MODULE_ENABLE = true;
    String MODULE_NAME = "Versioning";

    @Test(enabled=true, groups={"Module"})
    public void VerifyVersioningModule() {
        boolean foundAtLeastOne = ValidationUtils.elementValidation(this.testSubject, this.MODULE_NAME);
        Assert.assertTrue(foundAtLeastOne, "No " + this.MODULE_NAME + " element was found in the document.");
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyVersioningReference() {
        boolean isValid;
        ArrayList<String> vers = new ArrayList<String>();
        vers.add("vers:Version");
        try {
            isValid = XMLUtils.isRefValid("//vers:from", "xlink:href", vers, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue(isValid, this.MODULE_NAME + " Module reference invalid.");
        try {
            isValid = XMLUtils.isRefValid("//vers:to", "xlink:href", vers, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue(isValid, this.MODULE_NAME + " Module reference invalid.");
        List<String> allowedAbstractFeatureWithLifespan = ValidationUtils.getTypeData("AbstractFeatureWithLifespan");
        try {
            isValid = XMLUtils.isRefValid("//vers:oldFeature", "xlink:href", allowedAbstractFeatureWithLifespan, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue(isValid, this.MODULE_NAME + " Module reference invalid.");
        try {
            isValid = XMLUtils.isRefValid("//vers:newFeature", "xlink:href", allowedAbstractFeatureWithLifespan, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue(isValid, this.MODULE_NAME + " Module reference invalid.");
        try {
            isValid = XMLUtils.isRefValid("//vers:versionMember", "xlink:href", allowedAbstractFeatureWithLifespan, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue(isValid, this.MODULE_NAME + " Module reference invalid.");
    }
}

