/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.apache.xerces.util.XMLCatalogResolver;
import org.opengis.cite.citygml30part2.Namespaces;
import org.opengis.cite.citygml30part2.util.NamespaceBindings;
import org.opengis.cite.citygml30part2.util.TestSuiteLogger;
import org.opengis.cite.citygml30part2.util.URIUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ValidationUtils {
    static final String ROOT_PKG = "/org/opengis/cite/citygml30part2/";
    private static final XMLCatalogResolver SCH_RESOLVER = ValidationUtils.initCatalogResolver();

    private static XMLCatalogResolver initCatalogResolver() {
        return (XMLCatalogResolver)ValidationUtils.createSchemaResolver(Namespaces.SCH);
    }

    public static LSResourceResolver createSchemaResolver(URI schemaLanguage) {
        String catalogFileName = schemaLanguage.equals(Namespaces.XSD) ? "schema-catalog.xml" : "schematron-catalog.xml";
        URL catalogURL = ValidationUtils.class.getResource(ROOT_PKG + catalogFileName);
        XMLCatalogResolver resolver2 = new XMLCatalogResolver();
        resolver2.setCatalogList(new String[]{catalogURL.toString()});
        return resolver2;
    }

    public static SchematronValidator buildSchematronValidator(String schemaRef, String phase) {
        StreamSource source = null;
        try {
            String catalogRef = SCH_RESOLVER.resolveSystem(schemaRef.toString());
            source = null != catalogRef ? new StreamSource(URI.create(catalogRef).toString()) : new StreamSource(schemaRef);
        }
        catch (IOException x) {
            TestSuiteLogger.log(Level.WARNING, "Error reading Schematron schema catalog.", x);
        }
        SchematronValidator validator = null;
        try {
            validator = new SchematronValidator(source, phase);
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Error creating Schematron validator.", e);
        }
        return validator;
    }

    public static Set<URI> extractSchemaReferences(Source source, String baseURI) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(source);
        StartElement docElem = reader.nextTag().asStartElement();
        Attribute schemaLoc = docElem.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        if (null == schemaLoc) {
            throw new RuntimeException("No xsi:schemaLocation attribute found. See ISO 19136, A.3.1.");
        }
        Object[] uriValues = schemaLoc.getValue().split("\\s+");
        if (uriValues.length % 2 != 0) {
            throw new RuntimeException("xsi:schemaLocation attribute contains an odd number of URI values:\n" + Arrays.toString(uriValues));
        }
        HashSet<URI> schemaURIs = new HashSet<URI>();
        for (int i = 0; i < uriValues.length; i += 2) {
            URI schemaURI = null;
            if (!URI.create((String)uriValues[i + 1]).isAbsolute() && null != source.getSystemId()) {
                String schemaRef = URIUtils.resolveRelativeURI(source.getSystemId(), (String)uriValues[i + 1]).toString();
                if (schemaRef.startsWith("file") && !new File(schemaRef).exists() && null != baseURI) {
                    schemaRef = URIUtils.resolveRelativeURI(baseURI, (String)uriValues[i + 1]).toString();
                }
                schemaURI = URI.create(schemaRef);
            } else {
                schemaURI = URI.create((String)uriValues[i + 1]);
            }
            schemaURIs.add(schemaURI);
        }
        return schemaURIs;
    }

    public static Schema createMultipleSchema(String[] arrXsdPath) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema wpsSchema = null;
        try {
            Source[] arrSource = new Source[arrXsdPath.length];
            for (int i = 0; i < arrXsdPath.length; ++i) {
                String xsdPath = arrXsdPath[i];
                URL schemaURL = ValidationUtils.class.getResource(ROOT_PKG + xsdPath);
                StreamSource xsdSource = new StreamSource(schemaURL.toString());
                arrSource[i] = xsdSource;
            }
            wpsSchema = schemaFactory.newSchema(arrSource);
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create WFS Schema object.", e);
        }
        return wpsSchema;
    }

    public static List<String> getAllowedBoundaries(String spaceName) {
        String jsonPath = "/org/opengis/cite/citygml30part2/boundaries.json";
        InputStream in = ValidationUtils.class.getResourceAsStream(jsonPath);
        ArrayList<String> stringList = new ArrayList<String>();
        Map<String, Map<String, List<String>>> jsonObj = ValidationUtils.readBoundariesJsonObj(in);
        Map<String, List<String>> temp = jsonObj.get(spaceName);
        if (temp == null) {
            return stringList;
        }
        HashSet<String> boundariesSet = new HashSet<String>();
        for (List<String> values : temp.values()) {
            boundariesSet.addAll(values);
        }
        stringList = new ArrayList(boundariesSet);
        return stringList;
    }

    public static List<String> getTypeData(String typeName) {
        String jsonPath = "/org/opengis/cite/citygml30part2/type-inheritance.json";
        InputStream in = ValidationUtils.class.getResourceAsStream(jsonPath);
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, List<String>>>(){}.getType();
        List<String> jsonObj = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader(in);){
            Map jsonObjTemp = (Map)gson.fromJson((Reader)reader, mapType);
            if (jsonObjTemp != null && !jsonObjTemp.isEmpty()) {
                jsonObj = (List)jsonObjTemp.get(typeName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static String getXmlns(String ns) {
        String CITYGML_NS = "http://www.opengis.net/citygml/";
        if (ns.toLowerCase().equals("core")) {
            return CITYGML_NS + "3.0";
        }
        return CITYGML_NS + ns.toLowerCase() + "/3.0";
    }

    public static boolean elementValidation(Document doc, String moduleName) {
        String moduleNS = ValidationUtils.getXmlns(moduleName);
        NodeList rootElementList = doc.getChildNodes();
        boolean validElement = false;
        for (int a = 0; a < rootElementList.getLength(); ++a) {
            String itemClassName = rootElementList.item(a).getClass().toString();
            if (!itemClassName.equals("class org.apache.xerces.dom.DeferredElementNSImpl")) continue;
            DeferredElementNSImpl element = (DeferredElementNSImpl)rootElementList.item(a);
            boolean containCityModel = element.getLocalName().equals("CityModel");
            boolean nsEqual = element.getNamespaceURI().equals(ValidationUtils.getXmlns("Core"));
            if (!containCityModel || !nsEqual) continue;
            if (moduleName != "Core") {
                String prefix = NamespaceBindings.getNameSpacePrefix(moduleNS);
                String expr = "//" + prefix + ":" + moduleName;
                NodeList nodeList = XMLUtils.getNodeListByXPath(doc, expr);
                if (nodeList.getLength() <= 0) continue;
                validElement = true;
                continue;
            }
            validElement = true;
        }
        return validElement;
    }

    public static boolean isBoundariesValid(Document doc, String[] allowedSpace) {
        try {
            XPath xpath = XMLUtils.getCityGMLXPath();
            List<String> spaces = Arrays.asList(allowedSpace);
            String expr = "//*[*[local-name()='boundary']]";
            NodeList boundariesParentList = (NodeList)xpath.evaluate(expr, doc, XPathConstants.NODESET);
            if (boundariesParentList.getLength() == 0) {
                return true;
            }
            for (int i = 0; i < boundariesParentList.getLength(); ++i) {
                Element element = (Element)boundariesParentList.item(i);
                String currentSpaceName = element.getNodeName();
                if (!spaces.contains(currentSpaceName)) {
                    return false;
                }
                NodeList boundaries = element.getElementsByTagName("boundary");
                List<String> allowedBoundaries = ValidationUtils.getAllowedBoundaries(currentSpaceName);
                if (allowedBoundaries.size() == 0 && boundaries.getLength() > 0) {
                    return false;
                }
                for (int j = 0; j < boundaries.getLength(); ++j) {
                    NodeList childNodes = boundaries.item(j).getChildNodes();
                    int elementNodeCount = 0;
                    for (int k = 0; k < childNodes.getLength(); ++k) {
                        Node childNode = childNodes.item(k);
                        if (childNode.getNodeType() != 1) continue;
                        ++elementNodeCount;
                        String childNodeName = childNode.getNodeName();
                        if (allowedBoundaries.contains(childNodeName)) continue;
                        return false;
                    }
                    if (elementNodeCount == true) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public static Map<String, Map<String, List<String>>> readBoundariesJsonObj(InputStream in) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, Map<String, List<String>>>>(){}.getType();
        Map<String, Map<String, List<String>>> jsonObj = new HashMap<String, Map<String, List<String>>>();
        try (InputStreamReader reader = new InputStreamReader(in);){
            Map jsonObjTemp = (Map)gson.fromJson((Reader)reader, mapType);
            if (jsonObjTemp != null && !jsonObjTemp.isEmpty()) {
                jsonObj = jsonObjTemp;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }
}

