/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.NoInjection;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ExpectedExceptionsHolder;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Parameters;
import org.testng.internal.PoolService;
import org.testng.internal.RegexpExpectedExceptionsHolder;
import org.testng.internal.SingleTestMethodWorker;
import org.testng.internal.TestMethodWithDataProviderMethodWorker;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.InvokedMethodListenerInvoker;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class Invoker
implements IInvoker {
    private final ITestContext m_testContext;
    private final ITestResultNotifier m_notifier;
    private final IAnnotationFinder m_annotationFinder;
    private final SuiteRunState m_suiteState;
    private final boolean m_skipFailedInvocationCounts;
    private final Collection<IInvokedMethodListener> m_invokedMethodListeners;
    private final boolean m_continueOnFailedConfiguration;
    private final List<IClassListener> m_classListeners;
    private Map<String, Boolean> m_beforegroupsFailures = Maps.newHashtable();
    private Map<Class<?>, Set<Object>> m_classInvocationResults = Maps.newHashtable();
    private Map<ITestNGMethod, Set<Object>> m_methodInvocationResults = Maps.newHashtable();
    private IConfiguration m_configuration;
    private static Predicate<ITestNGMethod, IClass> CAN_RUN_FROM_CLASS = new CanRunFromClassPredicate();
    private static final Predicate<ITestNGMethod, IClass> SAME_CLASS = new SameClassNamePredicate();

    private void setClassInvocationFailure(Class<?> clazz, Object instance) {
        Set<Object> instances = this.m_classInvocationResults.get(clazz);
        if (instances == null) {
            instances = Sets.newHashSet();
            this.m_classInvocationResults.put(clazz, instances);
        }
        instances.add(instance);
    }

    private void setMethodInvocationFailure(ITestNGMethod method, Object instance) {
        Set<Object> instances = this.m_methodInvocationResults.get(method);
        if (instances == null) {
            instances = Sets.newHashSet();
            this.m_methodInvocationResults.put(method, instances);
        }
        instances.add(this.getMethodInvocationToken(method, instance));
    }

    public Invoker(IConfiguration configuration, ITestContext testContext, ITestResultNotifier notifier, SuiteRunState state, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners) {
        this.m_configuration = configuration;
        this.m_testContext = testContext;
        this.m_suiteState = state;
        this.m_notifier = notifier;
        this.m_annotationFinder = configuration.getAnnotationFinder();
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.m_invokedMethodListeners = invokedMethodListeners;
        this.m_continueOnFailedConfiguration = "continue".equals(testContext.getSuite().getXmlSuite().getConfigFailurePolicy());
        this.m_classListeners = classListeners;
    }

    @Override
    public void invokeConfigurations(IClass testClass, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance) {
        this.invokeConfigurations(testClass, null, allMethods, suite, params, parameterValues, instance, null);
    }

    private void invokeConfigurations(IClass testClass, ITestNGMethod currentTestMethod, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance, ITestResult testMethodResult) {
        ITestNGMethod[] methods;
        if (null == allMethods) {
            this.log(5, "No configuration methods found");
            return;
        }
        for (ITestNGMethod tm : methods = this.filterMethods(testClass, allMethods, SAME_CLASS)) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            TestResult testResult = new TestResult(testClass, instance, tm, null, System.currentTimeMillis(), System.currentTimeMillis(), this.m_testContext);
            IConfigurationAnnotation configurationAnnotation = null;
            try {
                Object inst = tm.getInstance();
                if (inst == null) {
                    inst = instance;
                }
                Class<?> objectClass = inst.getClass();
                Method method = tm.getMethod();
                configurationAnnotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, method);
                boolean alwaysRun = this.isAlwaysRun(configurationAnnotation);
                if (MethodHelper.isEnabled(objectClass, this.m_annotationFinder) || alwaysRun) {
                    if (MethodHelper.isEnabled(configurationAnnotation)) {
                        if (!this.confInvocationPassed(tm, currentTestMethod, testClass, instance) && !alwaysRun) {
                            this.handleConfigurationSkip(tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
                            continue;
                        }
                        this.log(3, "Invoking " + Utils.detailedMethodName(tm, true));
                        Object[] parameters = Parameters.createConfigurationParameters(tm.getMethod(), params, parameterValues, currentTestMethod, this.m_annotationFinder, suite, this.m_testContext, testMethodResult);
                        testResult.setParameters(parameters);
                        Object newInstance = null != instance ? instance : inst;
                        this.runConfigurationListeners(testResult, true);
                        this.invokeConfigurationMethod(newInstance, tm, parameters, testResult);
                        testResult.setEndMillis(System.currentTimeMillis());
                        this.runConfigurationListeners(testResult, false);
                        continue;
                    }
                    this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because it is not enabled");
                    continue;
                }
                this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because " + objectClass.getName() + " is not enabled");
            }
            catch (InvocationTargetException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
            }
            catch (Throwable ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
            }
        }
    }

    private void handleConfigurationSkip(ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        testResult.setStatus(3);
        this.runConfigurationListeners(testResult, false);
    }

    private boolean isAlwaysRun(IConfigurationAnnotation configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean alwaysRun = false;
        if ((configurationAnnotation.getAfterSuite() || configurationAnnotation.getAfterTest() || configurationAnnotation.getAfterTestClass() || configurationAnnotation.getAfterTestMethod() || configurationAnnotation.getBeforeTestMethod() || configurationAnnotation.getBeforeTestClass() || configurationAnnotation.getBeforeTest() || configurationAnnotation.getBeforeSuite()) && configurationAnnotation.getAlwaysRun()) {
            alwaysRun = true;
        }
        return alwaysRun;
    }

    private void handleConfigurationFailure(Throwable ite, ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        Throwable cause;
        Throwable throwable = cause = ite.getCause() != null ? ite.getCause() : ite;
        if (this.isSkipExceptionAndSkip(cause)) {
            testResult.setThrowable(cause);
            this.handleConfigurationSkip(tm, testResult, annotation, currentTestMethod, instance, suite);
            return;
        }
        Utils.log("", 3, "Failed to invoke configuration method " + tm.getRealClass().getName() + "." + tm.getMethodName() + ":" + cause.getMessage());
        this.handleException(cause, tm, testResult, 1);
        this.runConfigurationListeners(testResult, false);
        if (null != annotation) {
            this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        }
    }

    private XmlClass[] findClassesInSameTest(Class<?> cls, XmlSuite suite) {
        Map<String, XmlClass> vResult = Maps.newHashMap();
        String className = cls.getName();
        for (XmlTest test : suite.getTests()) {
            for (XmlClass testClass : test.getXmlClasses()) {
                if (!testClass.getName().equals(className)) continue;
                for (XmlClass thisClass : test.getXmlClasses()) {
                    vResult.put(thisClass.getName(), thisClass);
                }
            }
        }
        XmlClass[] result = vResult.values().toArray(new XmlClass[vResult.size()]);
        return result;
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod tm, IClass testClass, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        if (annotation.getBeforeTestClass() || annotation.getAfterTestClass()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setClassInvocationFailure(testClass.getRealClass(), instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeTestMethod() || annotation.getAfterTestMethod()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setMethodInvocationFailure(currentTestMethod, instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeSuite() || annotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (annotation.getBeforeTest() || annotation.getAfterTest()) {
            this.setClassInvocationFailure(tm.getRealClass(), instance);
            XmlClass[] classes = this.findClassesInSameTest(tm.getRealClass(), suite);
            for (XmlClass xmlClass : classes) {
                this.setClassInvocationFailure(xmlClass.getSupportClass(), instance);
            }
        }
        String[] beforeGroups = annotation.getBeforeGroups();
        if (null != beforeGroups && beforeGroups.length > 0) {
            for (String group : beforeGroups) {
                this.m_beforegroupsFailures.put(group, Boolean.FALSE);
            }
        }
    }

    private boolean classConfigurationFailed(Class<?> cls) {
        for (Class<?> c : this.m_classInvocationResults.keySet()) {
            if (c != cls && !c.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private boolean confInvocationPassed(ITestNGMethod method, ITestNGMethod currentTestMethod, IClass testClass, Object instance) {
        boolean result = true;
        Class cls = testClass.getRealClass();
        if (this.m_suiteState.isFailed()) {
            result = false;
        } else if (this.classConfigurationFailed(cls)) {
            result = !this.m_continueOnFailedConfiguration ? !this.classConfigurationFailed(cls) : !this.m_classInvocationResults.get(cls).contains(instance);
        } else if (this.m_continueOnFailedConfiguration && currentTestMethod != null && this.m_methodInvocationResults.containsKey(currentTestMethod)) {
            result = !this.m_methodInvocationResults.get(currentTestMethod).contains(this.getMethodInvocationToken(currentTestMethod, instance));
        } else if (!this.m_continueOnFailedConfiguration) {
            for (Class<?> clazz : this.m_classInvocationResults.keySet()) {
                if (!clazz.isAssignableFrom(cls)) continue;
                result = false;
                break;
            }
        }
        String[] groups = method.getGroups();
        if (null != groups && groups.length > 0) {
            for (String group : groups) {
                if (!this.m_beforegroupsFailures.containsKey(group)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private Object getMethodInvocationToken(ITestNGMethod method, Object instance) {
        return String.format("%s+%d", instance.toString(), method.getCurrentInvocationCount());
    }

    private void invokeConfigurationMethod(Object targetInstance, ITestNGMethod tm, Object[] params, ITestResult testResult) throws InvocationTargetException, IllegalAccessException {
        tm.setId(ThreadUtil.currentThreadInfo());
        InvokedMethod invokedMethod = new InvokedMethod(targetInstance, tm, params, System.currentTimeMillis(), testResult);
        this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
        this.m_notifier.addInvokedMethod(invokedMethod);
        try {
            IConfigurable configurableInstance;
            Reporter.setCurrentTestResult(testResult);
            Method method = tm.getMethod();
            IConfigurable iConfigurable = configurableInstance = IConfigurable.class.isAssignableFrom(tm.getMethod().getDeclaringClass()) ? (IConfigurable)targetInstance : this.m_configuration.getConfigurable();
            if (configurableInstance != null) {
                MethodInvocationHelper.invokeConfigurable(targetInstance, params, configurableInstance, method, testResult);
            } else if (MethodHelper.calculateTimeOut(tm) <= 0L) {
                MethodInvocationHelper.invokeMethod(method, targetInstance, params);
            } else {
                MethodInvocationHelper.invokeWithTimeout(tm, targetInstance, params, testResult);
                if (!testResult.isSuccess()) {
                    this.throwConfigurationFailure(testResult, testResult.getThrowable());
                    throw testResult.getThrowable();
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            this.throwConfigurationFailure(testResult, ex);
            throw ex;
        }
        catch (Throwable ex) {
            this.throwConfigurationFailure(testResult, ex);
            throw new TestNGException(ex);
        }
        finally {
            Reporter.setCurrentTestResult(testResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
            Reporter.setCurrentTestResult(null);
        }
    }

    private void throwConfigurationFailure(ITestResult testResult, Throwable ex) {
        testResult.setStatus(2);
        testResult.setThrowable(ex.getCause() == null ? ex : ex.getCause());
    }

    private void runInvokedMethodListeners(InvokedMethodListenerMethod listenerMethod, IInvokedMethod invokedMethod, ITestResult testResult) {
        if (this.noListenersPresent()) {
            return;
        }
        InvokedMethodListenerInvoker invoker = new InvokedMethodListenerInvoker(listenerMethod, testResult, this.m_testContext);
        for (IInvokedMethodListener currentListener : this.m_invokedMethodListeners) {
            invoker.invokeListener(currentListener, invokedMethod);
        }
    }

    private boolean noListenersPresent() {
        return this.m_invokedMethodListeners == null || this.m_invokedMethodListeners.size() == 0;
    }

    /*
     * Exception decompiling
     */
    private ITestResult invokeMethod(Object instance, ITestNGMethod tm, Object[] parameterValues, int parametersIndex, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, FailureContext failureContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void collectResults(ITestNGMethod testMethod, Collection<ITestResult> results) {
        for (ITestResult result : results) {
            int status = result.getStatus();
            if (1 == status) {
                this.m_notifier.addPassedTest(testMethod, result);
                continue;
            }
            if (3 == status) {
                this.m_notifier.addSkippedTest(testMethod, result);
                continue;
            }
            if (2 == status) {
                this.m_notifier.addFailedTest(testMethod, result);
                continue;
            }
            if (4 == status) {
                this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, result);
                continue;
            }
            assert (false) : "UNKNOWN STATUS:" + status;
        }
    }

    private ITestNGMethod[] filterConfigurationMethods(ITestNGMethod tm, ITestNGMethod[] methods, boolean isBefore) {
        List result = Lists.newArrayList();
        for (ITestNGMethod m3 : methods) {
            ConfigurationMethod cm = (ConfigurationMethod)m3;
            if (isBefore) {
                if (cm.isFirstTimeOnly() && (!cm.isFirstTimeOnly() || tm.getCurrentInvocationCount() != 0)) continue;
                result.add(m3);
                continue;
            }
            int current = tm.getCurrentInvocationCount();
            boolean isLast = false;
            if (tm.getParameterInvocationCount() > 0) {
                isLast = current == tm.getParameterInvocationCount() * tm.getTotalInvocationCount();
            } else if (tm.getTotalInvocationCount() > 1) {
                boolean bl = isLast = current == tm.getTotalInvocationCount();
            }
            if (cm.isLastTimeOnly() && (!cm.isLastTimeOnly() || !isLast)) continue;
            result.add(m3);
        }
        return result.toArray(new ITestNGMethod[result.size()]);
    }

    protected ITestResult invokeTestMethod(Object instance, ITestNGMethod tm, Object[] parameterValues, int parametersIndex, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, FailureContext failureContext) {
        tm.setId(ThreadUtil.currentThreadInfo());
        ITestResult result = this.invokeMethod(instance, tm, parameterValues, parametersIndex, suite, params, testClass, beforeMethods, afterMethods, groupMethods, failureContext);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBeforeGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            List filteredMethods = Lists.newArrayList();
            String[] groups = currentTestMethod.getGroups();
            Map<String, List<ITestNGMethod>> beforeGroupMap = groupMethods.getBeforeGroupsMap();
            for (String group : groups) {
                List<ITestNGMethod> methods = beforeGroupMap.get(group);
                if (methods == null) continue;
                filteredMethods.addAll(methods);
            }
            ITestNGMethod[] beforeMethodsArray = filteredMethods.toArray(new ITestNGMethod[filteredMethods.size()]);
            if (beforeMethodsArray.length > 0) {
                this.invokeConfigurations(null, beforeMethodsArray, suite, params, null, null);
            }
            groupMethods.removeBeforeGroups(groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAfterGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        if (currentTestMethod.getGroups().length == 0) {
            return;
        }
        Map<String, String> filteredGroups = Maps.newHashMap();
        String[] groups = currentTestMethod.getGroups();
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            for (String group : groups) {
                if (!groupMethods.isLastMethodForGroup(group, currentTestMethod)) continue;
                filteredGroups.put(group, group);
            }
            if (filteredGroups.isEmpty()) {
                return;
            }
            Map<ITestNGMethod, ITestNGMethod> afterMethods = Maps.newHashMap();
            Map<String, List<ITestNGMethod>> map = groupMethods.getAfterGroupsMap();
            for (String g2 : filteredGroups.values()) {
                List<ITestNGMethod> methods = map.get(g2);
                if (methods == null) continue;
                for (ITestNGMethod m3 : methods) {
                    afterMethods.put(m3, m3);
                }
            }
            ITestNGMethod[] afterMethodsArray = afterMethods.keySet().toArray(new ITestNGMethod[afterMethods.size()]);
            this.invokeConfigurations(null, afterMethodsArray, suite, params, null, null);
            groupMethods.removeAfterGroups(filteredGroups.keySet());
        }
    }

    private Object[] getParametersFromIndex(Iterator<Object[]> parametersValues, int index) {
        while (parametersValues.hasNext()) {
            Object[] parameters = parametersValues.next();
            if (index == 0) {
                return parameters;
            }
            --index;
        }
        return null;
    }

    int retryFailed(Object instance, ITestNGMethod tm, XmlSuite suite, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, List<ITestResult> result, int failureCount, ExpectedExceptionsHolder expectedExceptionHolder, ITestContext testContext, Map<String, String> parameters, int parametersIndex) {
        FailureContext failure = new FailureContext();
        failure.count = failureCount;
        do {
            failure.instances = Lists.newArrayList();
            Map<String, String> allParameters = Maps.newHashMap();
            ParameterBag bag = this.createParameters(tm, parameters, allParameters, suite, testContext, null);
            Object[] parameterValues = this.getParametersFromIndex(bag.parameterHolder.parameters, parametersIndex);
            result.add(this.invokeMethod(instance, tm, parameterValues, parametersIndex, suite, allParameters, testClass, beforeMethods, afterMethods, groupMethods, failure));
        } while (!failure.instances.isEmpty());
        return failure.count;
    }

    private ParameterBag createParameters(ITestNGMethod testMethod, Map<String, String> parameters, Map<String, String> allParameterNames, XmlSuite suite, ITestContext testContext, Object fedInstance) {
        Object instance = fedInstance != null ? fedInstance : testMethod.getInstance();
        ParameterBag bag = this.handleParameters(testMethod, instance, allParameterNames, parameters, null, suite, testContext, fedInstance, null);
        return bag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, XmlSuite suite, Map<String, String> testParameters, ConfigurationGroupMethods groupMethods, Object instance, ITestContext testContext) {
        assert (null != testMethod.getTestClass()) : "COULDN'T FIND TESTCLASS FOR " + testMethod.getRealClass();
        if (!MethodHelper.isEnabled(testMethod.getMethod(), this.m_annotationFinder)) {
            return Collections.emptyList();
        }
        String okToProceed = this.checkDependencies(testMethod, testContext.getAllTestMethods());
        if (okToProceed != null) {
            ITestResult result = this.registerSkippedTestResult(testMethod, null, System.currentTimeMillis(), new Throwable(okToProceed));
            this.m_notifier.addSkippedTest(testMethod, result);
            return Collections.singletonList(result);
        }
        Map<String, String> parameters = testMethod.findMethodParameters(testContext.getCurrentXmlTest());
        if (testMethod.getInvocationCount() > 1 && testMethod.getThreadPoolSize() > 1) {
            return this.invokePooledTestMethods(testMethod, suite, parameters, groupMethods, testContext);
        }
        long timeOutInvocationCount = testMethod.getInvocationTimeOut();
        boolean onlyOne = testMethod.getThreadPoolSize() > 1 || timeOutInvocationCount > 0L;
        int invocationCount = onlyOne ? 1 : testMethod.getInvocationCount();
        ExpectedExceptionsHolder expectedExceptionHolder = new ExpectedExceptionsHolder(this.m_annotationFinder, testMethod, new RegexpExpectedExceptionsHolder(this.m_annotationFinder, testMethod));
        ITestClass testClass = testMethod.getTestClass();
        List<ITestResult> result = Lists.newArrayList();
        FailureContext failure = new FailureContext();
        ITestNGMethod[] beforeMethods = this.filterMethods(testClass, testClass.getBeforeTestMethods(), CAN_RUN_FROM_CLASS);
        ITestNGMethod[] afterMethods = this.filterMethods(testClass, testClass.getAfterTestMethods(), CAN_RUN_FROM_CLASS);
        block5: while (invocationCount-- > 0) {
            long start = System.currentTimeMillis();
            Map<String, String> allParameterNames = Maps.newHashMap();
            ParameterBag bag = this.createParameters(testMethod, parameters, allParameterNames, suite, testContext, instance);
            if (bag.hasErrors()) {
                ITestResult tr = bag.errorResult;
                tr.setStatus(3);
                this.runTestListeners(tr);
                this.m_notifier.addSkippedTest(testMethod, tr);
                result.add(tr);
                continue;
            }
            Iterator<Object[]> allParameterValues = bag.parameterHolder.parameters;
            int parametersIndex = 0;
            try {
                Object[] parameterValues;
                List workers = Lists.newArrayList();
                if (bag.parameterHolder.origin == ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER && bag.parameterHolder.dataProviderHolder.annotation.isParallel()) {
                    while (allParameterValues.hasNext()) {
                        parameterValues = this.injectParameters(allParameterValues.next(), testMethod.getMethod(), testContext, null);
                        TestMethodWithDataProviderMethodWorker w = new TestMethodWithDataProviderMethodWorker(this, testMethod, parametersIndex, parameterValues, instance, suite, parameters, testClass, beforeMethods, afterMethods, groupMethods, expectedExceptionHolder, testContext, this.m_skipFailedInvocationCounts, invocationCount, failure.count, this.m_notifier);
                        workers.add(w);
                        ++parametersIndex;
                    }
                    PoolService ps = new PoolService(suite.getDataProviderThreadCount());
                    List r = ps.submitTasksAndWait(workers);
                    for (List l2 : r) {
                        result.addAll(l2);
                    }
                    continue;
                }
                while (allParameterValues.hasNext()) {
                    parameterValues = this.injectParameters(allParameterValues.next(), testMethod.getMethod(), testContext, null);
                    List tmpResults = Lists.newArrayList();
                    try {
                        tmpResults.add(this.invokeTestMethod(instance, testMethod, parameterValues, parametersIndex, suite, parameters, testClass, beforeMethods, afterMethods, groupMethods, failure));
                    }
                    finally {
                        if (failure.instances.isEmpty()) {
                            result.addAll(tmpResults);
                        } else {
                            for (Object failedInstance : failure.instances) {
                                List<ITestResult> retryResults = Lists.newArrayList();
                                failure.count = this.retryFailed(failedInstance, testMethod, suite, testClass, beforeMethods, afterMethods, groupMethods, retryResults, failure.count, expectedExceptionHolder, testContext, parameters, parametersIndex);
                                result.addAll(retryResults);
                            }
                        }
                        if (failure.count > 0 && (this.m_skipFailedInvocationCounts || testMethod.skipFailedInvocations())) {
                            while (invocationCount-- > 0) {
                                result.add(this.registerSkippedTestResult(testMethod, instance, System.currentTimeMillis(), null));
                            }
                            continue block5;
                        }
                    }
                    ++parametersIndex;
                }
            }
            catch (Throwable cause) {
                TestResult r = new TestResult(testMethod.getTestClass(), instance, testMethod, cause, start, System.currentTimeMillis(), this.m_testContext);
                r.setStatus(2);
                result.add(r);
                this.runTestListeners(r);
                this.m_notifier.addFailedTest(testMethod, r);
            }
        }
        return result;
    }

    private ITestResult registerSkippedTestResult(ITestNGMethod testMethod, Object instance, long start, Throwable throwable) {
        TestResult result = new TestResult(testMethod.getTestClass(), instance, testMethod, throwable, start, System.currentTimeMillis(), this.m_testContext);
        result.setStatus(3);
        this.runTestListeners(result);
        return result;
    }

    private Object[] injectParameters(Object[] parameterValues, Method method, ITestContext context, ITestResult testResult) throws TestNGException {
        List vResult = Lists.newArrayList();
        int i = 0;
        int numValues = parameterValues.length;
        int numParams = method.getParameterTypes().length;
        if (numValues > numParams && !method.isVarArgs()) {
            throw new TestNGException("The data provider is trying to pass " + numValues + " parameters but the method " + method.getDeclaringClass().getName() + "#" + method.getName() + " takes " + numParams);
        }
        for (Class<?> cls : method.getParameterTypes()) {
            Object injected;
            Annotation[] annotations = method.getParameterAnnotations()[i];
            boolean noInjection = false;
            for (Annotation a : annotations) {
                if (!(a instanceof NoInjection)) continue;
                noInjection = true;
                break;
            }
            if ((injected = Parameters.getInjectedParameter(cls, method, context, testResult)) != null && !noInjection) {
                vResult.add(injected);
                continue;
            }
            try {
                if (method.isVarArgs()) {
                    vResult.add(parameterValues);
                    continue;
                }
                vResult.add(parameterValues[i++]);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new TestNGException("The data provider is trying to pass " + numValues + " parameters but the method " + method.getDeclaringClass().getName() + "#" + method.getName() + " takes " + numParams + " and TestNG is unable in inject a suitable object", ex);
            }
        }
        return vResult.toArray(new Object[vResult.size()]);
    }

    private ParameterBag handleParameters(ITestNGMethod testMethod, Object instance, Map<String, String> allParameterNames, Map<String, String> parameters, Object[] parameterValues, XmlSuite suite, ITestContext testContext, Object fedInstance, ITestResult testResult) {
        try {
            return new ParameterBag(Parameters.handleParameters(testMethod, allParameterNames, instance, new Parameters.MethodParameters(parameters, testMethod.findMethodParameters(testContext.getCurrentXmlTest()), parameterValues, testMethod.getMethod(), testContext, testResult), suite, this.m_annotationFinder, fedInstance));
        }
        catch (Throwable cause) {
            return new ParameterBag(new TestResult(testMethod.getTestClass(), instance, testMethod, cause, System.currentTimeMillis(), System.currentTimeMillis(), this.m_testContext));
        }
    }

    private List<ITestResult> invokePooledTestMethods(ITestNGMethod testMethod, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ITestContext testContext) {
        List<IWorker<ITestNGMethod>> workers = Lists.newArrayList();
        for (int i = 0; i < testMethod.getInvocationCount(); ++i) {
            ITestNGMethod clonedMethod = testMethod.clone();
            clonedMethod.setInvocationCount(1);
            clonedMethod.setThreadPoolSize(1);
            MethodInstance mi = new MethodInstance(clonedMethod);
            workers.add(new SingleTestMethodWorker(this, mi, suite, parameters, testContext, this.m_classListeners));
        }
        return this.runWorkers(testMethod, workers, testMethod.getThreadPoolSize(), groupMethods, suite, parameters);
    }

    void handleInvocationResults(ITestNGMethod testMethod, List<ITestResult> result, ExpectedExceptionsHolder expectedExceptionsHolder, FailureContext failure) {
        List<ITestResult> resultsToRetry = Lists.newArrayList();
        for (ITestResult testResult : result) {
            boolean willRetry;
            TestException exception;
            Throwable ite = testResult.getThrowable();
            int status = testResult.getStatus();
            boolean handled = false;
            if (ite != null) {
                if (expectedExceptionsHolder != null) {
                    if (expectedExceptionsHolder.isExpectedException(ite)) {
                        testResult.setStatus(1);
                        status = 1;
                    } else if (this.isSkipExceptionAndSkip(ite)) {
                        status = 3;
                    } else {
                        testResult.setThrowable(expectedExceptionsHolder.wrongException(ite));
                        status = 2;
                    }
                } else {
                    this.handleException(ite, testMethod, testResult, failure.count++);
                    handled = true;
                    status = testResult.getStatus();
                }
            } else if (status != 3 && expectedExceptionsHolder != null && (exception = expectedExceptionsHolder.noException(testMethod)) != null) {
                testResult.setThrowable(exception);
                status = 2;
            }
            IRetryAnalyzer retryAnalyzer = testMethod.getRetryAnalyzer();
            boolean bl = willRetry = retryAnalyzer != null && status == 2 && failure.instances != null && retryAnalyzer.retry(testResult);
            if (willRetry) {
                resultsToRetry.add(testResult);
                ++failure.count;
                failure.instances.add(testResult.getInstance());
                testResult.setStatus(3);
            } else {
                testResult.setStatus(status);
                if (status == 2 && !handled) {
                    this.handleException(ite, testMethod, testResult, failure.count++);
                }
            }
            this.collectResults(testMethod, Collections.singleton(testResult));
        }
        this.removeResultsToRetryFromResult(resultsToRetry, result, failure);
    }

    private boolean isSkipExceptionAndSkip(Throwable ite) {
        return SkipException.class.isAssignableFrom(ite.getClass()) && ((SkipException)ite).isSkip();
    }

    private void removeResultsToRetryFromResult(List<ITestResult> resultsToRetry, List<ITestResult> result, FailureContext failure) {
        if (resultsToRetry != null) {
            for (ITestResult res : resultsToRetry) {
                result.remove(res);
                --failure.count;
            }
        }
    }

    private List<ITestResult> runWorkers(ITestNGMethod testMethod, List<IWorker<ITestNGMethod>> workers, int threadPoolSize, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> parameters) {
        Object[] instances;
        ITestClass testClass = testMethod.getTestClass();
        for (Object instance : instances = testClass.getInstances(true)) {
            this.invokeBeforeGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
        }
        long maxTimeOut = -1L;
        for (IWorker<ITestNGMethod> tmw : workers) {
            long mt = tmw.getTimeOut();
            if (mt <= maxTimeOut) continue;
            maxTimeOut = mt;
        }
        ThreadUtil.execute(workers, threadPoolSize, maxTimeOut, true);
        List<ITestResult> result = Lists.newArrayList();
        for (IWorker<ITestNGMethod> tmw : workers) {
            if (!(tmw instanceof TestMethodWorker)) continue;
            result.addAll(((TestMethodWorker)tmw).getTestResults());
        }
        for (Object instance : instances) {
            this.invokeAfterGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
        }
        return result;
    }

    private String checkDependencies(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods) {
        ITestNGMethod[] methods;
        if (testMethod.isAlwaysRun()) {
            return null;
        }
        if (testMethod.getMissingGroup() != null && !testMethod.ignoreMissingDependencies()) {
            return "Method " + testMethod + " depends on nonexistent group \"" + testMethod.getMissingGroup() + "\"";
        }
        String[] groups = testMethod.getGroupsDependedUpon();
        if (null != groups && groups.length > 0) {
            for (String element : groups) {
                ITestNGMethod[] methods2 = MethodGroupsHelper.findMethodsThatBelongToGroup(testMethod, this.m_testContext.getAllTestMethods(), element);
                if (methods2.length == 0 && !testMethod.ignoreMissingDependencies()) {
                    return "Method " + testMethod + " depends on nonexistent group \"" + element + "\"";
                }
                if (this.haveBeenRunSuccessfully(testMethod, methods2)) continue;
                return "Method " + testMethod + " depends on not successfully finished methods in group \"" + element + "\"";
            }
        }
        if (this.dependsOnMethods(testMethod) && !this.haveBeenRunSuccessfully(testMethod, methods = MethodHelper.findDependedUponMethods(testMethod, allTestMethods))) {
            return "Method " + testMethod + " depends on not successfully finished methods";
        }
        return null;
    }

    private Set<ITestResult> keepSameInstances(ITestNGMethod method, Set<ITestResult> results) {
        Set<ITestResult> result = Sets.newHashSet();
        for (ITestResult r : results) {
            Object instance;
            Object o = method.getInstance();
            Object object = instance = r.getInstance() != null ? r.getInstance() : r.getMethod().getInstance();
            if (r.getTestClass() == method.getTestClass() && instance != o) continue;
            result.add(r);
        }
        return result;
    }

    private boolean haveBeenRunSuccessfully(ITestNGMethod testMethod, ITestNGMethod[] methods) {
        for (ITestNGMethod method : methods) {
            Set<ITestResult> results = this.keepSameInstances(testMethod, this.m_notifier.getPassedTests(method));
            Set<ITestResult> failedAndSkippedMethods = Sets.newHashSet();
            failedAndSkippedMethods.addAll(this.m_notifier.getFailedTests(method));
            failedAndSkippedMethods.addAll(this.m_notifier.getSkippedTests(method));
            Set<ITestResult> failedresults = this.keepSameInstances(testMethod, failedAndSkippedMethods);
            if (failedresults != null && failedresults.size() > 0) {
                return false;
            }
            for (ITestResult result : results) {
                if (result.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount) {
        int invocationCount;
        int successPercentage;
        float numberOfTestsThatCanFail;
        if (throwable != null) {
            testResult.setThrowable(throwable);
        }
        if ((float)failureCount < (numberOfTestsThatCanFail = (float)((100 - (successPercentage = testMethod.getSuccessPercentage())) * (invocationCount = testMethod.getInvocationCount())) / 100.0f)) {
            testResult.setStatus(4);
        } else {
            testResult.setStatus(2);
        }
    }

    private ITestNGMethod[] filterMethods(IClass testClass, ITestNGMethod[] methods, Predicate<ITestNGMethod, IClass> predicate) {
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            if (predicate.isTrue(tm, testClass)) {
                this.log(10, "Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(10, "Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private boolean dependsOnMethods(ITestNGMethod tm) {
        String[] methods = tm.getMethodsDependedUpon();
        return null != methods && methods.length > 0;
    }

    private void runConfigurationListeners(ITestResult tr, boolean before) {
        if (before) {
            for (IConfigurationListener icl : this.m_notifier.getConfigurationListeners()) {
                if (!(icl instanceof IConfigurationListener2)) continue;
                ((IConfigurationListener2)icl).beforeConfiguration(tr);
            }
        } else {
            for (IConfigurationListener icl : this.m_notifier.getConfigurationListeners()) {
                switch (tr.getStatus()) {
                    case 3: {
                        icl.onConfigurationSkip(tr);
                        break;
                    }
                    case 2: {
                        icl.onConfigurationFailure(tr);
                        break;
                    }
                    case 1: {
                        icl.onConfigurationSuccess(tr);
                    }
                }
            }
        }
    }

    void runTestListeners(ITestResult tr) {
        Invoker.runTestListeners(tr, this.m_notifier.getTestListeners());
    }

    public static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            assert (false) : "UNKNOWN STATUS:" + tr;
        }
    }

    private void log(int level, String s2) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s2);
    }

    private static class ParameterBag {
        final ParameterHolder parameterHolder;
        final ITestResult errorResult;

        public ParameterBag(ParameterHolder parameterHolder) {
            this.parameterHolder = parameterHolder;
            this.errorResult = null;
        }

        public ParameterBag(ITestResult errorResult) {
            this.parameterHolder = null;
            this.errorResult = errorResult;
        }

        public boolean hasErrors() {
            return this.errorResult != null;
        }
    }

    static class SameClassNamePredicate
    implements Predicate<ITestNGMethod, IClass> {
        SameClassNamePredicate() {
        }

        @Override
        public boolean isTrue(ITestNGMethod m3, IClass c) {
            return c == null || m3.getTestClass().getName().equals(c.getName());
        }
    }

    static class CanRunFromClassPredicate
    implements Predicate<ITestNGMethod, IClass> {
        CanRunFromClassPredicate() {
        }

        @Override
        public boolean isTrue(ITestNGMethod m3, IClass v) {
            return m3.canRunFromClass(v);
        }
    }

    static interface Predicate<K, T> {
        public boolean isTrue(K var1, T var2);
    }

    static class FailureContext {
        int count = 0;
        List<Object> instances = Lists.newArrayList();

        FailureContext() {
        }
    }
}

