/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IResultMap;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Objects;

public class ResultMap
implements IResultMap {
    private static final long serialVersionUID = 80134376515999093L;
    private Map<ITestResult, ITestNGMethod> m_map = new ConcurrentHashMap<ITestResult, ITestNGMethod>();

    @Override
    public void addResult(ITestResult result, ITestNGMethod method) {
        this.m_map.put(result, method);
    }

    @Override
    public Set<ITestResult> getResults(ITestNGMethod method) {
        HashSet<ITestResult> result = new HashSet<ITestResult>();
        for (Map.Entry<ITestResult, ITestNGMethod> entry : this.m_map.entrySet()) {
            if (!entry.getValue().equals(method)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public void removeResult(ITestNGMethod m3) {
        for (Map.Entry<ITestResult, ITestNGMethod> entry : this.m_map.entrySet()) {
            if (!entry.getValue().equals(m3)) continue;
            this.m_map.remove(entry.getKey());
            return;
        }
    }

    @Override
    public void removeResult(ITestResult r) {
        this.m_map.remove(r);
    }

    @Override
    public Set<ITestResult> getAllResults() {
        return this.m_map.keySet();
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public Collection<ITestNGMethod> getAllMethods() {
        return this.m_map.values();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("map", this.m_map).toString();
    }
}

