/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.saxon;

import com.occamlab.te.TECore;
import com.occamlab.te.index.FunctionEntry;
import com.occamlab.te.saxon.GetTypeFunctionCall;
import com.occamlab.te.saxon.TEFunctionCall;
import com.occamlab.te.util.DomUtils;
import java.io.CharArrayReader;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class TEXSLFunctionCall
extends TEFunctionCall {
    FunctionEntry fe;

    public TEXSLFunctionCall(FunctionEntry fe, StructuredQName functionName, Expression[] staticArgs, StaticContext env) {
        super(functionName, staticArgs, env);
        this.fe = fe;
    }

    public static String getType(Expression expr, XPathContext context) throws XPathException {
        ValueRepresentation vr = ExpressionTool.lazyEvaluate(expr, context, 1);
        ItemType it = Value.asValue(vr).getItemType(context.getConfiguration().getTypeHierarchy());
        if (it instanceof SchemaType) {
            return "xs:" + ((SchemaType)((Object)it)).getName();
        }
        return "xs:any";
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        ObjectValue ov = (ObjectValue)controller.getParameter("{http://www.occamlab.com/te}core");
        TECore core = (TECore)ov.getObject();
        Expression[] argExpressions = this.getArguments();
        Object xml = "<params>\n";
        List<QName> params = this.fe.getParams();
        for (int i = 0; i < params.size(); ++i) {
            QName param = params.get(i);
            xml = (String)xml + "<param";
            xml = (String)xml + " local-name=\"" + param.getLocalPart() + "\"";
            xml = (String)xml + " namespace-uri=\"" + param.getNamespaceURI() + "\"";
            xml = (String)xml + " prefix=\"" + param.getPrefix() + "\"";
            ValueRepresentation vr = ExpressionTool.eagerEvaluate(argExpressions[i], context);
            Value v = Value.asValue(vr);
            try {
                Node n = (Node)v.convertToJava(Node.class, context);
                short type = n.getNodeType();
                if (type == 2) {
                    xml = (String)xml + ">\n";
                    Attr attr = (Attr)n;
                    xml = (String)xml + "<value " + attr.getNodeName() + "=\"" + attr.getValue().replace("&", "&amp;") + "\"";
                    if (attr.getPrefix() != null) {
                        xml = (String)xml + " xmlns:" + attr.getPrefix() + "=\"" + attr.getNamespaceURI() + "\"";
                    }
                    xml = (String)xml + "/>\n";
                } else if (type == 1) {
                    xml = (String)xml + " type=\"node()\">\n";
                    xml = (String)xml + "<value>";
                    xml = (String)xml + DomUtils.serializeNode(n);
                    xml = (String)xml + "</value>\n";
                } else if (type == 9) {
                    xml = (String)xml + " type=\"document-node()\">\n";
                    xml = (String)xml + "<value>";
                    xml = (String)xml + DomUtils.serializeNode(n);
                    xml = (String)xml + "</value>\n";
                } else {
                    ItemType it = v.getItemType(context.getConfiguration().getTypeHierarchy());
                    xml = (String)xml + " type=\"" + GetTypeFunctionCall.getTypeName(it) + "\">\n";
                    xml = (String)xml + "<value>" + n.getNodeValue() + "</value>\n";
                }
            }
            catch (Exception e) {
                ItemType it = v.getItemType(context.getConfiguration().getTypeHierarchy());
                xml = (String)xml + " type=\"" + GetTypeFunctionCall.getTypeName(it) + "\">\n";
                xml = (String)xml + "<value>" + v.getStringValue() + "</value>\n";
            }
            xml = (String)xml + "</param>\n";
        }
        xml = (String)xml + "</params>";
        StreamSource src = new StreamSource(new CharArrayReader(((String)xml).toCharArray()));
        NodeInfo result = null;
        try {
            NodeInfo paramsNode = core.getEngine().getBuilder().build(src).getUnderlyingNode();
            result = core.executeXSLFunction(context, this.fe, paramsNode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            return EmptyIterator.getInstance();
        }
        return result.iterateAxis((byte)3);
    }
}

