/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.functions.Current;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.LocalVariable;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.TraceWrapper;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementWithAttributes;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator,
Container,
InstructionInfo {
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected BigDecimal version = null;
    protected StaticContext staticContext = null;
    protected XPathException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    protected String defaultCollationName = null;
    private int lineNumber;
    private boolean explaining = false;
    private StructuredQName objectName;
    private XSLStylesheet containingStylesheet;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;
    public static final int REPORT_UNLESS_FALLBACK_AVAILABLE = 4;

    public Executable getExecutable() {
        return this.getPrincipalStylesheet().getExecutable();
    }

    public LocationProvider getLocationProvider() {
        return this.getExecutable().getLocationMap();
    }

    public StaticContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        return this.staticContext;
    }

    public ExpressionVisitor makeExpressionVisitor() {
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        visitor.setExecutable(this.getExecutable());
        return visitor;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    protected boolean isExplaining() {
        return this.explaining;
    }

    public void substituteFor(StyleElement temp) {
        this.parent = temp.parent;
        this.attributeList = temp.attributeList;
        this.namespaceList = temp.namespaceList;
        this.nameCode = temp.nameCode;
        this.sequence = temp.sequence;
        this.extensionNamespaces = temp.extensionNamespaces;
        this.excludedNamespaces = temp.excludedNamespaces;
        this.version = temp.version;
        this.root = temp.root;
        this.staticContext = temp.staticContext;
        this.validationError = temp.validationError;
        this.reportingCircumstances = temp.reportingCircumstances;
        this.lineNumber = temp.lineNumber;
    }

    protected void setValidationError(TransformerException reason, int circumstances) {
        this.validationError = XPathException.makeXPathException(reason);
        this.reportingCircumstances = circumstances;
    }

    public boolean isInstruction() {
        return false;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    protected ItemType getCommonChildItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType t2 = EmptySequenceTest.getInstance();
        AxisIterator children = this.iterateAxis((byte)3);
        do {
            NodeInfo next;
            if ((next = (NodeInfo)children.next()) == null) {
                return t2;
            }
            if (next instanceof StyleElement) {
                ItemType ret = ((StyleElement)next).getReturnedItemType();
                if (ret == null) continue;
                t2 = Type.getCommonSuperType(t2, ret, th);
                continue;
            }
            t2 = Type.getCommonSuperType(t2, NodeKindTest.TEXT, th);
        } while (t2 != AnyItemType.getInstance());
        return t2;
    }

    protected void markTailCalls() {
    }

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    public XSLStylesheet getContainingStylesheet() {
        if (this.containingStylesheet == null) {
            this.containingStylesheet = this instanceof XSLStylesheet ? (XSLStylesheet)this : ((StyleElement)this.getParent()).getContainingStylesheet();
        }
        return this.containingStylesheet;
    }

    public int getPrecedence() {
        return this.getContainingStylesheet().getPrecedence();
    }

    public final StructuredQName makeQName(String lexicalQName) throws XPathException, NamespaceException {
        StructuredQName qName;
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, false, this.getConfiguration().getNameChecker(), this);
        }
        catch (XPathException e) {
            e.setIsStaticError(true);
            e.setErrorCode("XTSE0020");
            throw e;
        }
        if (NamespaceConstant.isReserved(qName.getNamespaceURI())) {
            XPathException err = new XPathException("Namespace prefix " + qName.getPrefix() + " refers to a reserved namespace");
            err.setIsStaticError(true);
            err.setErrorCode("XTSE0080");
            throw err;
        }
        return qName;
    }

    public SavedNamespaceContext makeNamespaceContext() {
        return new SavedNamespaceContext(this.getInScopeNamespaceCodes(), this.getNamePool());
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    protected void processAllAttributes() throws XPathException {
        if (!(this instanceof LiteralResultElement)) {
            this.processDefaultCollationAttribute("default-collation");
        }
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo child;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).processAllAttributes();
            if (!((StyleElement)child).explaining) continue;
            this.explaining = true;
        }
        return;
    }

    public String getAttributeValue(String clarkName) {
        int fp = this.getNamePool().allocateClarkName(clarkName);
        return this.getAttributeValue(fp);
    }

    protected final void processAttributes() throws XPathException {
        try {
            this.prepareAttributes();
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    protected void checkUnknownAttribute(int nc) throws XPathException {
        String attributeURI = this.getNamePool().getURI(nc);
        String elementURI = this.getURI();
        String clarkName = this.getNamePool().getClarkName(nc);
        if (clarkName.equals("{http://saxon.sf.net/}explain")) {
            this.explaining = "yes".equals(this.getAttributeValue(nc & 0xFFFFF));
        }
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && clarkName.startsWith("{http://www.w3.org/1999/XSL/Transform") && !elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.endsWith("}default-collation") || clarkName.endsWith("}xpath-default-namespace") || clarkName.endsWith("}extension-element-prefixes") || clarkName.endsWith("}exclude-result-prefixes") || clarkName.endsWith("}version") || clarkName.endsWith("}use-when"))) {
            return;
        }
        if (elementURI.equals("http://www.w3.org/1999/XSL/Transform") && (clarkName.equals("default-collation") || clarkName.equals("xpath-default-namespace") || clarkName.equals("extension-element-prefixes") || clarkName.equals("exclude-result-prefixes") || clarkName.equals("version") || clarkName.equals("use-when"))) {
            return;
        }
        if ("".equals(attributeURI) || "http://www.w3.org/1999/XSL/Transform".equals(attributeURI)) {
            this.compileError("Attribute " + Err.wrap(this.getNamePool().getDisplayName(nc), 2) + " is not allowed on element " + Err.wrap(this.getDisplayName(), 1), "XTSE0090");
        }
    }

    protected abstract void prepareAttributes() throws XPathException;

    protected StyleElement getLastChildInstruction() {
        StyleElement last = null;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo child;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof StyleElement) {
                last = (StyleElement)child;
                continue;
            }
            last = null;
        }
        return last;
    }

    public Expression makeExpression(String expression) throws XPathException {
        try {
            return ExpressionTool.make(expression, this.staticContext, 0, 0, this.getLineNumber(), this.getPreparedStylesheet().isCompileWithTracing());
        }
        catch (XPathException err) {
            err.setLocator(this);
            this.compileError(err);
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            erexp.setContainer(this);
            return erexp;
        }
    }

    public Pattern makePattern(String pattern) throws XPathException {
        try {
            return Pattern.make(pattern, this.staticContext, this.getPrincipalStylesheet().getExecutable());
        }
        catch (XPathException err) {
            this.compileError(err);
            return new NodeTestPattern(AnyNodeTest.getInstance());
        }
    }

    protected Expression makeAttributeValueTemplate(String expression) throws XPathException {
        try {
            return AttributeValueTemplate.make(expression, this.getLineNumber(), this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return new StringLiteral(expression);
        }
    }

    public SequenceType makeSequenceType(String sequenceType) throws XPathException {
        this.getStaticContext();
        try {
            ExpressionParser parser = new ExpressionParser();
            return parser.parseSequenceType(sequenceType, this.staticContext);
        }
        catch (XPathException err) {
            this.compileError(err);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(String nc) throws XPathException {
        String ext = this.getAttributeValue(nc);
        if (ext != null) {
            int count = 0;
            StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
            while (st1.hasMoreTokens()) {
                st1.nextToken();
                ++count;
            }
            this.extensionNamespaces = new short[count];
            count = 0;
            StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
            while (st2.hasMoreTokens()) {
                String s2 = st2.nextToken();
                if ("#default".equals(s2)) {
                    s2 = "";
                }
                try {
                    short uriCode = this.getURICodeForPrefix(s2);
                    this.extensionNamespaces[count++] = uriCode;
                }
                catch (NamespaceException err) {
                    this.extensionNamespaces = null;
                    this.compileError(err.getMessage(), "XTSE1430");
                }
            }
        }
    }

    protected void processExcludedNamespaces(String nc) throws XPathException {
        block10: {
            String ext = this.getAttributeValue(nc);
            if (ext == null) break block10;
            if ("#all".equals(Whitespace.trim(ext))) {
                int[] codes = this.getInScopeNamespaceCodes();
                this.excludedNamespaces = new short[codes.length];
                for (int i = 0; i < codes.length; ++i) {
                    this.excludedNamespaces[i] = (short)(codes[i] & 0xFFFF);
                }
            } else {
                int count = 0;
                StringTokenizer st1 = new StringTokenizer(ext, " \t\n\r", false);
                while (st1.hasMoreTokens()) {
                    st1.nextToken();
                    ++count;
                }
                this.excludedNamespaces = new short[count];
                count = 0;
                StringTokenizer st2 = new StringTokenizer(ext, " \t\n\r", false);
                while (st2.hasMoreTokens()) {
                    String s2 = st2.nextToken();
                    if ("#default".equals(s2)) {
                        s2 = "";
                    } else if ("#all".equals(s2)) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values", "XTSE0020");
                    }
                    try {
                        short uriCode = this.getURICodeForPrefix(s2);
                        this.excludedNamespaces[count++] = uriCode;
                        if (s2.length() != 0 || uriCode != 0) continue;
                        this.compileError("Cannot exclude the #default namespace when no default namespace is declared", "XTSE0809");
                    }
                    catch (NamespaceException err) {
                        this.excludedNamespaces = null;
                        this.compileError(err.getMessage(), "XTSE0808");
                    }
                }
            }
        }
    }

    protected void processVersionAttribute(String nc) throws XPathException {
        String v = Whitespace.trim(this.getAttributeValue(nc));
        if (v != null) {
            ConversionResult val = DecimalValue.makeDecimalValue(v, true);
            if (val instanceof ValidationFailure) {
                this.compileError("The version attribute must be a decimal literal", "XTSE0110");
                this.version = new BigDecimal("2.0");
            } else {
                this.version = ((DecimalValue)val).getDecimalValue();
            }
        }
    }

    public BigDecimal getVersion() {
        if (this.version == null) {
            NodeInfo node = this.getParent();
            if (node instanceof StyleElement) {
                this.version = ((StyleElement)node).getVersion();
            } else {
                return new BigDecimal("2.0");
            }
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) > 0;
    }

    public boolean backwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) < 0;
    }

    protected void processDefaultCollationAttribute(String nc) throws XPathException {
        String v = this.getAttributeValue(nc);
        if (v != null) {
            StringTokenizer st = new StringTokenizer(v, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String uri = st.nextToken();
                if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (uri.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = uri;
                    return;
                }
                try {
                    URI collationURI = new URI(uri);
                    if (!collationURI.isAbsolute()) {
                        URI base = new URI(this.getBaseURI());
                        collationURI = base.resolve(collationURI);
                        uri = collationURI.toString();
                    }
                }
                catch (URISyntaxException err) {
                    this.compileError("default collation '" + uri + "' is not a valid URI");
                    uri = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                }
                if (uri.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (this.getPrincipalStylesheet().getExecutable().getNamedCollation(uri) != null) {
                    this.defaultCollationName = uri;
                    return;
                }
                if (this.getPrincipalStylesheet().findCollation(uri) == null) continue;
                this.defaultCollationName = uri;
                return;
            }
            this.compileError("No recognized collation URI found in default-collation attribute", "XTSE0125");
        }
    }

    protected String getDefaultCollationName() {
        StyleElement e = this;
        while (true) {
            if (e.defaultCollationName != null) {
                return e.defaultCollationName;
            }
            NodeInfo p = e.getParent();
            if (!(p instanceof StyleElement)) break;
            e = (StyleElement)p;
        }
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    protected boolean definesExtensionElement(short uriCode) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.extensionNamespaces.length; ++i) {
            if (this.extensionNamespaces[i] != uriCode) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(short uriCode) {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExtensionElement(uriCode)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short uriCode) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.excludedNamespaces.length; ++i) {
            if (this.excludedNamespaces[i] != uriCode) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(short uriCode) {
        if (uriCode == 2 || uriCode == 1) {
            return true;
        }
        if (this.isExtensionNamespace(uriCode)) {
            return true;
        }
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            if (anc.definesExcludedNamespace(uriCode)) {
                return true;
            }
            anc = anc.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String nc) {
        String v = this.getAttributeValue(nc);
        if (v != null) {
            this.defaultXPathNamespace = v;
        }
    }

    protected String getDefaultXPathNamespace() {
        NodeInfo anc = this;
        while (anc instanceof StyleElement) {
            String x = anc.defaultXPathNamespace;
            if (x != null) {
                return x;
            }
            anc = anc.getParent();
        }
        return "";
    }

    public SchemaType getSchemaType(String typeAtt) throws XPathException {
        try {
            String uri;
            String[] parts = this.getConfiguration().getNameChecker().getQNameParts(typeAtt);
            String lname = parts[1];
            if ("".equals(parts[0])) {
                uri = this.getDefaultXPathNamespace();
                this.nameCode = this.getNamePool().allocate(parts[0], uri, lname);
            } else {
                uri = this.getURIForPrefix(parts[0], false);
                if (uri == null) {
                    this.compileError("Namespace prefix for type annotation is undeclared", "XTSE1520");
                    return null;
                }
            }
            int nameCode = this.getNamePool().allocate(parts[0], uri, lname);
            if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType t2;
                if ("untyped".equals(lname)) {
                    this.compileError("Cannot validate a node as 'untyped'", "XTSE1520");
                }
                if ((t2 = BuiltInType.getSchemaType(StandardNames.getFingerprint(uri, lname))) == null) {
                    this.compileError("Unknown built-in type " + typeAtt, "XTSE1520");
                    return null;
                }
                return t2;
            }
            if (!this.getPrincipalStylesheet().isImportedSchema(uri)) {
                this.compileError("There is no imported schema for the namespace of type " + typeAtt, "XTSE1520");
                return null;
            }
            SchemaType stype = this.getConfiguration().getSchemaType(nameCode & 0xFFFFF);
            if (stype == null) {
                this.compileError("There is no type named " + typeAtt + " in an imported schema", "XTSE1520");
            }
            return stype;
        }
        catch (QNameException err) {
            this.compileError("Invalid type name. " + err.getMessage(), "XTSE1520");
            return null;
        }
    }

    public int getTypeAnnotation(SchemaType schemaType) {
        if (schemaType != null) {
            return schemaType.getFingerprint();
        }
        return -1;
    }

    public void validate() throws XPathException {
    }

    public void postValidate() throws XPathException {
    }

    public Expression typeCheck(String name, Expression exp) throws XPathException {
        if (exp == null) {
            return null;
        }
        exp.setContainer(this);
        try {
            exp = this.makeExpressionVisitor().typeCheck(exp, Type.ITEM_TYPE);
            exp = ExpressionTool.resolveCallsToCurrentFunction(exp, this.getConfiguration());
            if (this.getPreparedStylesheet().isCompileWithTracing()) {
                InstructionDetails details = new InstructionDetails();
                details.setConstructType(2011);
                details.setLineNumber(this.getLineNumber());
                details.setSystemId(this.getSystemId());
                details.setProperty("attribute-name", name);
                TraceInstruction trace = new TraceInstruction(exp, details);
                trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                trace.setContainer(this);
                exp = trace;
            }
            return exp;
        }
        catch (XPathException err) {
            if (err.isStaticError() || err.isTypeError()) {
                this.compileError(err);
                return exp;
            }
            ErrorExpression erexp = new ErrorExpression(err);
            erexp.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return erexp;
        }
    }

    public void allocateSlots(Expression exp) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            throw new AssertionError((Object)"Slot manager has not been allocated");
        }
        int firstSlot = slotManager.getNumberOfVariables();
        int highWater = ExpressionTool.allocateSlots(exp, firstSlot, slotManager);
        if (highWater > firstSlot) {
            slotManager.setNumberOfVariables(highWater);
        }
    }

    public void allocatePatternSlots(Pattern match, SlotManager frame) {
        match.allocateSlots((ExpressionContext)this.getStaticContext(), 0, frame);
        int highWater = frame.getNumberOfVariables();
        this.getContainingStylesheet().allocatePatternSlots(highWater);
    }

    public Pattern typeCheck(String name, Pattern pattern) throws XPathException {
        if (pattern == null) {
            return null;
        }
        try {
            pattern = pattern.analyze(this.makeExpressionVisitor(), Type.NODE_TYPE);
            boolean usesCurrent = false;
            if (pattern instanceof LocationPathPattern) {
                Iterator sub = pattern.iterateSubExpressions();
                while (sub.hasNext()) {
                    Expression filter = (Expression)sub.next();
                    if (!ExpressionTool.callsFunction(filter, Current.FN_CURRENT)) continue;
                    usesCurrent = true;
                    break;
                }
                if (usesCurrent) {
                    Configuration config = this.getConfiguration();
                    LetExpression let = new LetExpression();
                    let.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "current" + this.hashCode()));
                    let.setRequiredType(SequenceType.SINGLE_ITEM);
                    let.setSequence(new ContextItemExpression());
                    let.setAction(Literal.makeEmptySequence());
                    PromotionOffer offer = new PromotionOffer(config.getOptimizer());
                    offer.action = 14;
                    offer.containingExpression = let;
                    ((LocationPathPattern)pattern).resolveCurrent(let, offer, true);
                    this.allocateSlots(let);
                }
            }
            return pattern;
        }
        catch (XPathException err) {
            if (err.isStaticError() || err.isTypeError()) {
                XPathException e2 = new XPathException("Error in " + name + " pattern", err);
                e2.setLocator(err.getLocator());
                e2.setErrorCode(err.getErrorCodeLocalPart());
                throw e2;
            }
            LocationPathPattern errpat = new LocationPathPattern();
            errpat.setExecutable(this.getExecutable());
            errpat.addFilter(new ErrorExpression(err));
            return errpat;
        }
    }

    public void fixupReferences() throws XPathException {
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo child;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            ((StyleElement)child).fixupReferences();
        }
        return;
    }

    public SlotManager getContainingSlotManager() {
        NodeInfo node = this;
        while (true) {
            NodeInfo next;
            if ((next = node.getParent()) instanceof XSLStylesheet) {
                if (node instanceof StylesheetProcedure) {
                    return ((StylesheetProcedure)((Object)node)).getSlotManager();
                }
                return null;
            }
            node = next;
        }
    }

    public void validateSubtree() throws XPathException {
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 4) {
                NodeInfo child;
                boolean hasFallback = false;
                AxisIterator kids = this.iterateAxis((byte)3);
                while ((child = (NodeInfo)kids.next()) != null) {
                    if (!(child instanceof XSLFallback)) continue;
                    hasFallback = true;
                    ((XSLFallback)child).validateSubtree();
                }
                if (!hasFallback) {
                    this.compileError(this.validationError);
                }
            }
        } else {
            try {
                this.validate();
            }
            catch (XPathException err) {
                this.compileError(err);
            }
            this.validateChildren();
            this.postValidate();
        }
    }

    protected void validateChildren() throws XPathException {
        NodeInfo child;
        boolean containsInstructions = this.mayContainSequenceConstructor();
        AxisIterator kids = this.iterateAxis((byte)3);
        StyleElement lastChild = null;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof StyleElement)) continue;
            if (containsInstructions && !((StyleElement)child).isInstruction() && !this.isPermittedChild((StyleElement)child)) {
                ((StyleElement)child).compileError("An " + this.getDisplayName() + " element must not contain an " + child.getDisplayName() + " element", "XTSE0010");
            }
            ((StyleElement)child).validateSubtree();
            lastChild = (StyleElement)child;
        }
        if (lastChild instanceof XSLVariable && !(this instanceof XSLStylesheet)) {
            lastChild.compileWarning("A variable with no following sibling instructions has no effect", "SXWN9001");
        }
    }

    protected boolean isPermittedChild(StyleElement child) {
        return false;
    }

    public XSLStylesheet getPrincipalStylesheet() {
        XSLStylesheet sheet = this.getContainingStylesheet();
        XSLStylesheet next;
        while ((next = sheet.getImporter()) != null) {
            sheet = next;
        }
        return sheet;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        return this.getPrincipalStylesheet().getPreparedStylesheet();
    }

    public void checkWithinTemplate() throws XPathException {
    }

    protected void checkSortComesFirst(boolean sortRequired) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        boolean sortFound = false;
        boolean nonSortFound = false;
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLSort) {
                if (nonSortFound) {
                    ((XSLSort)child).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions", "XTSE0010");
                }
                sortFound = true;
                continue;
            }
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                nonSortFound = true;
                continue;
            }
            nonSortFound = true;
        }
        if (sortRequired && !sortFound) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child", "XTSE0010");
        }
    }

    public void checkTopLevel(String errorCode) throws XPathException {
        if (!(this.getParent() instanceof XSLStylesheet)) {
            this.compileError("Element must be used only at top level of stylesheet", errorCode == null ? "XTSE0010" : errorCode);
        }
    }

    public void checkEmpty() throws XPathException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty", "XTSE0260");
        }
    }

    public void reportAbsence(String attribute) throws XPathException {
        this.compileError("Element must have a \"" + attribute + "\" attribute", "XTSE0010");
    }

    public abstract Expression compile(Executable var1) throws XPathException;

    public Expression compileSequenceConstructor(Executable exec, AxisIterator iter, boolean includeParams) throws XPathException {
        Expression result = Literal.makeEmptySequence();
        int locationId = this.allocateLocationId(this.getSystemId(), this.getLineNumber());
        while (true) {
            Expression child;
            int lineNumber = this.getLineNumber();
            NodeInfo node = (NodeInfo)iter.next();
            if (node == null) {
                return result;
            }
            if (node instanceof StyleElement) {
                lineNumber = node.getLineNumber();
            }
            if (node.getNodeKind() == 3) {
                AxisIterator lookahead = node.iterateAxis((byte)7);
                NodeInfo sibling = (NodeInfo)lookahead.next();
                if (sibling instanceof XSLParam || sibling instanceof XSLSort) continue;
                ValueOf text = new ValueOf(new StringLiteral(node.getStringValue()), false, false);
                text.setLocationId(this.allocateLocationId(this.getSystemId(), lineNumber));
                result = Block.makeBlock(result, text);
                result.setLocationId(locationId);
                continue;
            }
            if (node instanceof XSLVariable) {
                Expression var = ((XSLVariable)node).compileLocalVariable(exec);
                if (var == null) continue;
                LocalVariable lv = (LocalVariable)var;
                Expression tail = this.compileSequenceConstructor(exec, iter, includeParams);
                if (tail == null || Literal.isEmptySequence(tail)) {
                    return result;
                }
                LetExpression let = new LetExpression();
                let.setRequiredType(lv.getRequiredType());
                let.setVariableQName(lv.getVariableQName());
                let.setSequence(lv.getSelectExpression());
                let.setAction(tail);
                ((XSLVariable)node).fixupBinding(let);
                locationId = this.allocateLocationId(node.getSystemId(), node.getLineNumber());
                let.setLocationId(locationId);
                if (this.getPreparedStylesheet().isCompileWithTracing()) {
                    TraceExpression t2 = new TraceExpression(let);
                    t2.setConstructType(2013);
                    t2.setObjectName(lv.getVariableQName());
                    t2.setSystemId(node.getSystemId());
                    t2.setLineNumber(node.getLineNumber());
                    result = Block.makeBlock(result, t2);
                } else {
                    result = Block.makeBlock(result, let);
                }
                result.setLocationId(locationId);
                continue;
            }
            if (!(node instanceof StyleElement)) continue;
            StyleElement snode = (StyleElement)node;
            if (snode.validationError != null && !(this instanceof AbsentExtensionElement)) {
                child = this.fallbackProcessing(exec, snode);
            } else {
                child = snode.compile(exec);
                if (child != null) {
                    if (child.getContainer() == null) {
                        child.setContainer(this);
                    }
                    locationId = this.allocateLocationId(this.getSystemId(), snode.getLineNumber());
                    child.setLocationId(locationId);
                    if ((includeParams || !(node instanceof XSLParam)) && this.getPreparedStylesheet().isCompileWithTracing()) {
                        child = StyleElement.makeTraceInstruction(snode, child);
                    }
                }
            }
            if ((result = Block.makeBlock(result, child)) == null) continue;
            result.setLocationId(locationId);
        }
    }

    protected static TraceWrapper makeTraceInstruction(StyleElement source, Expression child) {
        if (child instanceof TraceWrapper) {
            return (TraceWrapper)child;
        }
        TraceInstruction trace = new TraceInstruction(child, source);
        trace.setLocationId(source.allocateLocationId(source.getSystemId(), source.getLineNumber()));
        trace.setContainer(source);
        return trace;
    }

    protected Expression fallbackProcessing(Executable exec, StyleElement instruction) throws XPathException {
        NodeInfo child;
        Expression fallback = null;
        AxisIterator kids = instruction.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof XSLFallback)) continue;
            Expression b = ((XSLFallback)child).compileSequenceConstructor(exec, child.iterateAxis((byte)3), true);
            if (b == null) {
                b = Literal.makeEmptySequence();
            }
            if (fallback == null) {
                fallback = b;
                continue;
            }
            fallback = Block.makeBlock(fallback, b);
            fallback.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        }
        if (fallback != null) {
            return fallback;
        }
        return new ErrorExpression(instruction.validationError);
    }

    protected int allocateLocationId(String systemId, int lineNumber) {
        return this.getStaticContext().getLocationMap().allocateLocationId(systemId, lineNumber);
    }

    protected SortKeyDefinition[] makeSortKeys() throws XPathException {
        Item child;
        int numberOfSortKeys = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLSort)) continue;
            ((XSLSort)child).compile(this.getExecutable());
            if (numberOfSortKeys != 0 && ((XSLSort)child).getStable() != null) {
                this.compileError("stable attribute may appear only on the first xsl:sort element", "XTSE1017");
            }
            ++numberOfSortKeys;
        }
        if (numberOfSortKeys > 0) {
            NodeInfo child2;
            SortKeyDefinition[] keys = new SortKeyDefinition[numberOfSortKeys];
            kids = this.iterateAxis((byte)3);
            int k = 0;
            while ((child2 = (NodeInfo)kids.next()) != null) {
                if (!(child2 instanceof XSLSort)) continue;
                keys[k++] = ((XSLSort)child2).getSortKeyDefinition().simplify(this.makeExpressionVisitor());
            }
            return keys;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String use, List list) throws XPathException {
        if (list == null) {
            list = new ArrayList<XSLAttributeSet>(4);
        }
        XSLStylesheet stylesheet = this.getPrincipalStylesheet();
        List toplevel = stylesheet.getTopLevel();
        StringTokenizer st = new StringTokenizer(use, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            StructuredQName fprint;
            String asetname = st.nextToken();
            try {
                fprint = this.makeQName(asetname);
            }
            catch (NamespaceException err) {
                this.compileError(err.getMessage(), "XTSE0710");
                fprint = null;
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), "XTSE0710");
                fprint = null;
            }
            boolean found = false;
            for (int i = 0; i < toplevel.size(); ++i) {
                XSLAttributeSet t2;
                if (!(toplevel.get(i) instanceof XSLAttributeSet) || !(t2 = (XSLAttributeSet)toplevel.get(i)).getAttributeSetName().equals(fprint)) continue;
                list.add(t2);
                found = true;
            }
            if (found) continue;
            this.compileError("No attribute-set exists named " + asetname, "XTSE0710");
        }
        AttributeSet[] array = new AttributeSet[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            XSLAttributeSet aset = (XSLAttributeSet)list.get(i);
            aset.incrementReferenceCount();
            array[i] = aset.getInstruction();
        }
        return array;
    }

    protected WithParam[] getWithParamInstructions(Executable exec, boolean tunnel, Instruction caller) throws XPathException {
        NodeInfo child;
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            XSLWithParam wp;
            if (!(child instanceof XSLWithParam) || (wp = (XSLWithParam)child).isTunnelParam() != tunnel) continue;
            ++count;
        }
        WithParam[] array = new WithParam[count];
        count = 0;
        kids = this.iterateAxis((byte)3);
        NodeInfo child2;
        while ((child2 = (NodeInfo)kids.next()) != null) {
            XSLWithParam wp;
            if (!(child2 instanceof XSLWithParam) || (wp = (XSLWithParam)child2).isTunnelParam() != tunnel) continue;
            WithParam p = (WithParam)wp.compile(exec);
            ExpressionTool.copyLocationInfo(caller, p);
            array[count++] = p;
        }
        return array;
    }

    protected void compileError(XPathException error) throws XPathException {
        error.setIsStaticError(true);
        if (error.getLocator() == null || error.getLocator() instanceof ExpressionLocation) {
            error.setLocator(this);
        }
        PreparedStylesheet pss = this.getPreparedStylesheet();
        try {
            if (pss == null) {
                throw error;
            }
            pss.reportError(error);
        }
        catch (TransformerException err2) {
            if (err2.getLocator() == null) {
                err2.setLocator(this);
            }
            throw XPathException.makeXPathException(err2);
        }
    }

    protected void compileError(String message) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setLocator(this);
        this.compileError(tce);
    }

    protected void compileError(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        tce.setLocator(this);
        this.compileError(tce);
    }

    protected void undeclaredNamespaceError(String prefix, String errorCode) throws XPathException {
        if (errorCode == null) {
            errorCode = "XTSE0280";
        }
        this.compileError("Undeclared namespace prefix " + Err.wrap(prefix), errorCode);
    }

    protected void compileWarning(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        tce.setLocator(this);
        PreparedStylesheet pss = this.getPreparedStylesheet();
        if (pss != null) {
            pss.reportWarning(tce);
        }
    }

    protected void issueWarning(TransformerException error) {
        PreparedStylesheet pss;
        if (error.getLocator() == null) {
            error.setLocator(this);
        }
        if ((pss = this.getPreparedStylesheet()) != null) {
            pss.reportWarning(error);
        }
    }

    protected void issueWarning(String message, SourceLocator locator) {
        TransformerConfigurationException tce = new TransformerConfigurationException(message);
        if (locator == null) {
            tce.setLocator(this);
        } else {
            tce.setLocator(locator);
        }
        this.issueWarning(tce);
    }

    public boolean isTopLevel() {
        return this.getParent() instanceof XSLStylesheet;
    }

    public XSLVariableDeclaration bindVariable(StructuredQName qName) throws XPathException {
        XSLVariableDeclaration binding = this.getVariableBinding(qName);
        if (binding == null) {
            XPathException err = new XPathException("Variable " + qName.getDisplayName() + " has not been declared");
            err.setErrorCode("XPST0008");
            err.setIsStaticError(true);
            throw err;
        }
        return binding;
    }

    private XSLVariableDeclaration getVariableBinding(StructuredQName qName) {
        block4: {
            NodeInfo curr = this;
            NodeInfo prev = this;
            if (!this.isTopLevel()) {
                XSLVariableDeclaration var;
                AxisIterator preceding = curr.iterateAxis((byte)11);
                do {
                    curr = (NodeInfo)preceding.next();
                    while (curr == null) {
                        curr = prev.getParent();
                        while (curr instanceof XSLFallback) {
                            curr = curr.getParent();
                        }
                        prev = curr;
                        if (curr.getParent() instanceof XSLStylesheet) break;
                        preceding = curr.iterateAxis((byte)11);
                        curr = (NodeInfo)preceding.next();
                    }
                    if (curr.getParent() instanceof XSLStylesheet) break block4;
                } while (!(curr instanceof XSLVariableDeclaration) || !(var = (XSLVariableDeclaration)curr).getVariableQName().equals(qName));
                return var;
            }
        }
        XSLStylesheet root = this.getPrincipalStylesheet();
        return root.getGlobalVariable(qName);
    }

    public XSLFunction getStylesheetFunction(StructuredQName qName, int arity) {
        XSLStylesheet root = this.getPrincipalStylesheet();
        List toplevel = root.getTopLevel();
        for (int i = toplevel.size() - 1; i >= 0; --i) {
            Object child = toplevel.get(i);
            if (!(child instanceof XSLFunction) || !((XSLFunction)child).getObjectName().equals(qName) || arity != -1 && ((XSLFunction)child).getNumberOfArguments() != arity) continue;
            return (XSLFunction)child;
        }
        return null;
    }

    public List getAllStylesheetFunctions() {
        ArrayList output = new ArrayList();
        XSLStylesheet root = this.getPrincipalStylesheet();
        List toplevel = root.getTopLevel();
        for (int i = toplevel.size() - 1; i >= 0; --i) {
            int arity;
            StructuredQName name;
            Object child = toplevel.get(i);
            if (!(child instanceof XSLFunction) || this.getStylesheetFunction(name = ((XSLFunction)child).getObjectName(), arity = ((XSLFunction)child).getNumberOfArguments()) != child) continue;
            output.add(child);
        }
        return output;
    }

    public int getConstructType() {
        return this.getFingerprint();
    }

    public StructuredQName getObjectName(NamePool pool) {
        return this.getObjectName();
    }

    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(StructuredQName qName) {
        this.objectName = qName;
    }

    public Object getProperty(String name) {
        return this.getAttributeValue(name);
    }

    public Iterator getProperties() {
        NodeInfo a;
        NamePool pool = this.getNamePool();
        ArrayList<String> list = new ArrayList<String>(10);
        AxisIterator it = this.iterateAxis((byte)2);
        while ((a = (NodeInfo)it.next()) != null) {
            list.add(pool.getClarkName(a.getNameCode()));
        }
        return list.iterator();
    }

    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    public int getHostLanguage() {
        return 50;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        throw new IllegalArgumentException("Invalid replacement");
    }
}

