/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.apache.jena.atlas.lib.IdentityFinishCollector;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public abstract class ModelCollector
implements IdentityFinishCollector.UnorderedIdentityFinishCollector<Model, Model> {
    @Override
    public Supplier<Model> supplier() {
        return ModelFactory::createDefaultModel;
    }

    public ConcurrentModelCollector concurrent() {
        return new ConcurrentModelCollector(this);
    }

    public static class ConcurrentModelCollector
    extends ModelCollector
    implements IdentityFinishCollector.ConcurrentUnorderedIdentityFinishCollector<Model, Model> {
        private final ModelCollector collector;

        public ConcurrentModelCollector(ModelCollector col) {
            this.collector = col;
        }

        @Override
        public BiConsumer<Model, Model> accumulator() {
            return (m1, m22) -> m22.executeInTxn(() -> m1.executeInTxn(() -> this.collector.accumulator().accept(m1, (Model)m22)));
        }

        @Override
        public BinaryOperator<Model> combiner() {
            return (m1, m22) -> m22.calculateInTxn(() -> m1.calculateInTxn(() -> (Model)this.collector.combiner().apply(m1, m22)));
        }
    }

    public static class IntersectionModelCollector
    extends ModelCollector {
        @Override
        public BinaryOperator<Model> combiner() {
            return Model::intersection;
        }

        @Override
        public BiConsumer<Model, Model> accumulator() {
            return (m1, m22) -> m1.remove(m1.difference((Model)m22));
        }
    }

    public static class UnionModelCollector
    extends ModelCollector {
        @Override
        public BinaryOperator<Model> combiner() {
            return ModelFactory::createUnion;
        }

        @Override
        public BiConsumer<Model, Model> accumulator() {
            return Model::add;
        }
    }
}

