/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.dom.DeferredAttrNSImpl;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.opengis.cite.citygml30part2.CommonFixture;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalValidation
extends CommonFixture {
    final boolean GLOBAL_ENABLE = true;
    String MODULE_NAME = "Global";

    @Test(enabled=true)
    public void VerifyCityGMLInstanceDoc() throws Exception {
        boolean result;
        ArrayList<String> arrayList = XMLUtils.GetToValidateXsdPathArrayList(this.testSubject);
        String exceptionMessage = "";
        try {
            result = XMLUtils.isMultipleXMLSchemaValid(this.testSubject, arrayList);
        }
        catch (Exception e) {
            exceptionMessage = e.getMessage();
            result = false;
        }
        Assert.assertTrue(result, "Invalid CityGML Instance Document. " + exceptionMessage);
    }

    @Test(enabled=true)
    public void VerifyGlobalReferencingGeometries1() throws Exception {
        String xlinkAttribute = "xlink:href";
        String findReferenceExpression = "//*/@" + xlinkAttribute;
        boolean exist = true;
        NodeList xlinkNodeList = XMLUtils.getNodeListByXPath(this.testSubject, findReferenceExpression);
        for (int i = 0; i < xlinkNodeList.getLength(); ++i) {
            DeferredAttrNSImpl n = (DeferredAttrNSImpl)xlinkNodeList.item(i);
            String hrefName = n.getValue();
            String gmlIdItem = "//*[@gml:id='" + (hrefName = hrefName.replace("#", "")) + "']";
            NodeList targetNode = XMLUtils.getNodeListByXPath(this.testSubject, gmlIdItem);
            if (targetNode.getLength() > 0) continue;
            exist = false;
        }
        Assert.assertTrue(exist, "XLinks SHALL NOT be used to reference geometries, except for geometries of ImplicitGeometry elements, from another top-level feature..");
    }

    /*
     * WARNING - void declaration
     */
    @Test(enabled=true)
    public void VerifyGlobalReferencingGeometries2() throws XPathExpressionException {
        boolean valid = true;
        try {
            void var9_16;
            List<String> spaceBoundaryNamesList = ValidationUtils.getTypeData("AbstractSpaceBoundary");
            List<String> spaceNameList = ValidationUtils.getTypeData("AbstractSpace");
            XPath xPath = XMLUtils.getCityGMLXPath();
            String exprBoundary = "//*[local-name()='boundary']";
            NodeList boundariesNode = (NodeList)xPath.evaluate(exprBoundary, this.testSubject, XPathConstants.NODESET);
            for (int i = 0; i < boundariesNode.getLength() && valid; ++i) {
                Node currentBoundaryNode = boundariesNode.item(i);
                Node node = currentBoundaryNode.getParentNode();
                String parentNodeName = node.getNodeName();
                if (spaceNameList.contains(parentNodeName)) continue;
                valid = false;
                break;
            }
            ArrayList<NodeList> allSpaceBoundariesList = new ArrayList<NodeList>();
            for (String string : spaceBoundaryNamesList) {
                String expr = "//" + string;
                NodeList spaceBoundariesNode = (NodeList)xPath.evaluate(expr, this.testSubject, XPathConstants.NODESET);
                if (spaceBoundariesNode == null || spaceBoundariesNode.getLength() == 0) continue;
                allSpaceBoundariesList.add(spaceBoundariesNode);
            }
            ArrayList<NodeList> allSpaceList = new ArrayList<NodeList>();
            for (String spaceName : spaceNameList) {
                String spaceLocalName = spaceName.split(":")[1];
                String expr = "//*[local-name()='" + spaceLocalName + "']";
                NodeList spacesNode = (NodeList)xPath.evaluate(expr, this.testSubject, XPathConstants.NODESET);
                if (spacesNode == null || spacesNode.getLength() == 0) continue;
                allSpaceList.add(spacesNode);
            }
            boolean bl = false;
            while (var9_16 < allSpaceList.size() && valid) {
                NodeList currentSpaceNodeList = (NodeList)allSpaceList.get((int)var9_16);
                for (int j = 0; j < currentSpaceNodeList.getLength() && valid; ++j) {
                    String id;
                    Node gmlIdNode;
                    Node currentSpaceNode = currentSpaceNodeList.item(j);
                    int childCount = currentSpaceNode.getChildNodes().getLength();
                    if (childCount == 0) {
                        this.checkXLink(currentSpaceNode);
                        continue;
                    }
                    Object expr = "//*[@xlink:href]";
                    NodeList refList = (NodeList)xPath.evaluate((String)expr, currentSpaceNode, XPathConstants.NODESET);
                    if (refList.getLength() > 0) {
                        for (int l = 0; l < refList.getLength(); ++l) {
                            Node xlinkHrefNode = refList.item(l);
                            this.checkXLink(xlinkHrefNode);
                        }
                    }
                    if ((gmlIdNode = currentSpaceNode.getAttributes().getNamedItem("gml:id")) == null || (refList = (NodeList)xPath.evaluate((String)(expr = "*[xlink:href='#" + (id = gmlIdNode.getNodeValue()) + "']"), this.testSubject, XPathConstants.NODESET)).getLength() <= 0) continue;
                    valid = false;
                }
                ++var9_16;
            }
        }
        catch (Exception e) {
            valid = false;
            Assert.fail("Invalid XML document. " + e.getMessage());
        }
        Assert.assertTrue(valid, "Referencing geometries of spaces and space boundaries invalid.");
    }

    @Test(enabled=true)
    public void VerifyGlobalReferencingGeometries3() {
        String lodExpr = "//*[starts-with(local-name(), 'lod')]";
        boolean selfContainedStatus = true;
        NodeList lodNodeList = XMLUtils.getNodeListByXPath(this.testSubject, lodExpr);
        for (int i = 0; i < lodNodeList.getLength(); ++i) {
            Node lodNode = lodNodeList.item(i);
            Node parent = lodNode.getParentNode();
            NodeList children = parent.getChildNodes();
            int numChildElements = 0;
            for (int j = 0; j < children.getLength(); ++j) {
                DeferredElementNSImpl element;
                String itemClassName = children.item(j).getClass().toString();
                if (!itemClassName.equals("class org.apache.xerces.dom.DeferredElementNSImpl") || !(element = (DeferredElementNSImpl)children.item(j)).hasAttribute("xlink:href")) continue;
                ++numChildElements;
            }
            if (numChildElements <= true) continue;
            selfContainedStatus = false;
        }
        Assert.assertTrue(selfContainedStatus, "LoDs SHALL be self-contained.");
        boolean notShared = true;
        for (int i = 0; i < lodNodeList.getLength() && notShared; ++i) {
            NodeList children = lodNodeList.item(i).getChildNodes();
            for (int j = 0; j < children.getLength() && notShared; ++j) {
                Element selfContained;
                if (children.item(j).getNodeType() != 1 || !(selfContained = (Element)children.item(j)).hasAttribute("gml:id")) continue;
                String id = "#" + selfContained.getAttribute("gml:id");
                String expressionOfId = "//*[@xlink:href='" + id + "']";
                NodeList xLinkHrefList = XMLUtils.getNodeListByXPath(this.testSubject, expressionOfId);
                for (int k = 0; k < xLinkHrefList.getLength() && notShared; ++k) {
                    Node xlinkHrefNode = xLinkHrefList.item(k);
                    Node parentNode = xlinkHrefNode.getParentNode();
                    String localNameOfXlink = parentNode.getLocalName();
                    if (!localNameOfXlink.startsWith("lod")) continue;
                    notShared = false;
                }
            }
        }
    }

    @Test(enabled=true)
    public void VerifyGlobalReferencingGeometries4() {
        ArrayList<String> topLevelFeature = new ArrayList<String>(Arrays.asList("Bridge", "Building", "CityFurniture", "CityObjectGroup", "GenericLogicalSpace", "GenericOccupiedSpace", "GenericThematicSurface", "GenericUnoccupiedSpace", "LandUse", "OtherConstruction", "PlantCover", "Railway", "ReliefFeature", "Road", "SolitaryVegetationObject", "Square", "Track", "Tunnel", "WaterBody", "Waterway"));
        boolean topLevelSeparately = true;
        String relatedExpression = "//*[core:relatedTo/core:CityObjectRelation/core:relationType='shared']";
        NodeList nodeList = XMLUtils.getNodeListByXPath(this.testSubject, relatedExpression);
        for (int i = 0; i < nodeList.getLength() && topLevelSeparately; ++i) {
            String relatedId;
            String idExpression;
            Node idNode;
            Node n = nodeList.item(i);
            String localName = n.getLocalName();
            if (!topLevelFeature.contains(localName) || (idNode = XMLUtils.getNodeByXPath(n, idExpression = "//*[@gml:id='" + (relatedId = XMLUtils.getNodeByXPath(n, "core:relatedTo/core:CityObjectRelation/core:relatedTo/@xlink:href").getNodeValue()) + "']")) == null) continue;
            topLevelSeparately = false;
        }
        Assert.assertTrue(topLevelSeparately, "The shared geometry is NOT stored for each top-level feature separately.");
        String cityObjectRelationExpr = "//*/core:CityObjectRelation/core:relationType";
        boolean referenceStatus = true;
        NodeList lodNodeList = XMLUtils.getNodeListByXPath(this.testSubject, cityObjectRelationExpr);
        for (int i = 0; i < lodNodeList.getLength(); ++i) {
            Node lodNode = lodNodeList.item(i);
            if (!lodNode.getNodeName().equals("core:relationType") || !lodNode.getTextContent().equals("shared")) continue;
            Node parent = lodNode.getParentNode();
            NodeList parentNodes = parent.getChildNodes();
            for (int j = 0; j < parentNodes.getLength(); ++j) {
                String idString;
                String findReferenceExpression;
                Node idNode;
                Node node = parentNodes.item(j);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("core:relatedTo") || (idNode = XMLUtils.getNodeByXPath(this.testSubject, findReferenceExpression = "//*[@gml:id='" + (idString = ((Element)node).getAttribute("xlink:href")) + "']")) != null) continue;
                referenceStatus = false;
            }
        }
        Assert.assertTrue(referenceStatus, "CityObjectRelation reference invalid.");
    }

    @Test(enabled=true)
    public void VerifyGlobalAlternativeAggregations() {
        String query = "//core:cityObjectMember/*[not(*)]";
        NodeList nodeList = XMLUtils.getNodeListByXPath(this.testSubject, query);
        if (nodeList.getLength() == 0) {
            query = "//core:cityObjectMember/*/*[not(*)]";
            nodeList = XMLUtils.getNodeListByXPath(this.testSubject, query);
        }
        if (nodeList.getLength() != 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.contains("relatedTo") || node.getAttributes().getLength() == 0 || node.getAttributes().getNamedItem("xlink:href") == null) continue;
                this.checkXLink(node);
            }
        }
    }

    private void checkXLink(Node node) {
        try {
            String nodeName = node.getNodeName();
            String xlinkHrefTextContent = node.getAttributes().getNamedItem("xlink:href").getTextContent();
            String xlinkHrefTextContent_Modified = xlinkHrefTextContent.replaceFirst("#", "");
            String query = String.format("//%s/*[@gml:id='%s']", nodeName, xlinkHrefTextContent_Modified);
            NodeList nodeList = XMLUtils.getNodeListByXPath(this.testSubject, query);
            Assert.assertTrue(nodeList.getLength() > 0, String.format("Element '%s' contains non resolvable xlink '%s'.", nodeName, xlinkHrefTextContent));
        }
        catch (Exception e) {
            Assert.fail("Could not check XLink of node.", e);
        }
    }
}

