/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.module;

import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.citygml30part2.CommonFixture;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DynamizerModuleValidation
extends CommonFixture {
    final boolean MODULE_ENABLE = true;
    String MODULE_NAME = "Dynamizer";

    @Test(enabled=true, groups={"Module"})
    public void VerifyDynamizerModule() {
        boolean foundAtLeastOne = ValidationUtils.elementValidation(this.testSubject, this.MODULE_NAME);
        Assert.assertTrue(foundAtLeastOne, "No " + this.MODULE_NAME + " element was found in the document.");
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyDynamizerReference() {
        boolean isValid;
        try {
            List<String> allowedType = ValidationUtils.getTypeData("AbstractCityObject");
            isValid = XMLUtils.isRefValid("//grp:parent", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue(isValid, this.MODULE_NAME + " Module reference invalid.");
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyDynamizerAttributeRef() throws XPathExpressionException {
        String expressionProperty = "//dyn:Dynamizer[dyn:attributeRef]";
        NodeList dynamizerNodeList = XMLUtils.getNodeListByXPath(this.testSubject, expressionProperty);
        boolean allValid = true;
        for (int i = 0; i < dynamizerNodeList.getLength(); ++i) {
            Node currentDynamizerNode = dynamizerNodeList.item(i);
            boolean resultRefValid = true;
            Node attributeRefNode = XMLUtils.getNodeByXPath(currentDynamizerNode, "dyn:attributeRef/text()");
            String refValue = attributeRefNode.getNodeValue();
            refValue = refValue.replace("genericAttribute", "*[local-name()='genericAttribute']");
            Node attributeRefValueNode = XMLUtils.getNodeByXPath(this.testSubject, refValue = refValue.replace("[name='", "[gen:name='"));
            if (attributeRefValueNode == null) {
                resultRefValid = false;
            }
            String typeOfValue = attributeRefValueNode.getParentNode().getLocalName();
            XPath xpath = XMLUtils.getCityGMLXPath();
            String valueNode = (String)xpath.evaluate("text()", attributeRefValueNode, XPathConstants.STRING);
            Class<?> TYPE2 = null;
            try {
                TYPE2 = this.getTYPE(typeOfValue, valueNode);
            }
            catch (Exception e) {
                resultRefValid = false;
            }
            boolean typeEqual = true;
            boolean dynamizerValid = resultRefValid && typeEqual;
            allValid &= dynamizerValid;
        }
    }

    public Class<?> getTYPE(String typeOfValue, String valueNode) throws Exception {
        Class TYPE2;
        if (typeOfValue.equals("DoubleAttribute")) {
            TYPE2 = Double.class;
            Double.parseDouble(valueNode);
        } else if (typeOfValue.equals("CodeAttribute")) {
            TYPE2 = String.class;
        } else if (typeOfValue.equals("DateAttribute")) {
            TYPE2 = Date.class;
            Date.parse(valueNode);
        } else if (typeOfValue.equals("GenericAttribute")) {
            TYPE2 = String.class;
        } else if (typeOfValue.equals("StringAttribute")) {
            TYPE2 = String.class;
        } else if (typeOfValue.equals("IntAttribute")) {
            TYPE2 = Integer.class;
            Integer.parseInt(valueNode);
        } else {
            TYPE2 = typeOfValue.equals("MeasureAttribute") ? String.class : (typeOfValue.equals("UriAttribute") ? String.class : String.class);
        }
        return TYPE2;
    }
}

