/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.opengis.cite.citygml30part2.util.NamespaceBindings;
import org.opengis.cite.citygml30part2.util.TestSuiteLogger;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final Logger LOGR = Logger.getLogger(XMLUtils.class.getPackage().getName());
    private static final XMLInputFactory STAX_FACTORY = XMLUtils.initXMLInputFactory();
    private static final XPathFactory XPATH_FACTORY = XMLUtils.initXPathFactory();

    private static XPathFactory initXPathFactory() {
        XPathFactory factory = XPathFactory.newInstance();
        return factory;
    }

    private static XMLInputFactory initXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return factory;
    }

    public static String writeNodeToString(Node node) {
        if (null == node) {
            return "";
        }
        Object writer = null;
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            writer = new StringWriter();
            idTransformer.transform(new DOMSource(node), new StreamResult((Writer)writer));
        }
        catch (TransformerException ex) {
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize node " + node.getNodeName(), ex);
        }
        return writer.toString();
    }

    public static void writeNode(Node node, OutputStream outputStream) {
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("method", "xml");
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            idTransformer.transform(new DOMSource(node), new StreamResult(outputStream));
        }
        catch (TransformerException ex) {
            String nodeName = node.getNodeType() == 9 ? ((Document)Document.class.cast(node)).getDocumentElement().getNodeName() : node.getNodeName();
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize DOM node: " + nodeName, ex);
        }
    }

    public static NodeList evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings) throws XPathExpressionException {
        Object result = XMLUtils.evaluateXPath(context, expr, namespaceBindings, XPathConstants.NODESET);
        if (!NodeList.class.isInstance(result)) {
            throw new XPathExpressionException("Expression does not evaluate to a NodeList: " + expr);
        }
        return (NodeList)result;
    }

    public static Object evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings, QName returnType) throws XPathExpressionException {
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPathFactory factory = XPATH_FACTORY;
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(bindings);
        Object result = xpath.evaluate(expr, context, returnType);
        return result;
    }

    public static XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        net.sf.saxon.s9api.DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap(domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem(node);
        return xpath.evaluate();
    }

    public static XdmValue evaluateXQuery(Source source, String query, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XQueryCompiler xqCompiler = proc.newXQueryCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                xqCompiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XQueryExecutable xqExec = xqCompiler.compile(query);
        XQueryEvaluator xqEval = xqExec.load();
        xqEval.setSource(source);
        return xqEval.evaluate();
    }

    public static Element createElement(QName qName) {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element elem = doc.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        return elem;
    }

    public static List<Element> getElementsByNamespaceURI(Node node, String namespaceURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(namespaceURI)) continue;
            list.add((Element)child);
        }
        return list;
    }

    public static Document transform(Source xslt, Node source) {
        Document sourceDoc = null;
        Document resultDoc = null;
        try {
            resultDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            if (source.getNodeType() == 9) {
                sourceDoc = (Document)source;
            } else {
                sourceDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                sourceDoc.appendChild(sourceDoc.importNode(source, true));
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        Processor processor = new Processor(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        try {
            XsltExecutable exec = compiler.compile(xslt);
            XsltTransformer transformer = exec.load();
            transformer.setSource(new DOMSource(sourceDoc));
            transformer.setDestination(new DOMDestination(resultDoc));
            transformer.transform();
        }
        catch (SaxonApiException e) {
            throw new RuntimeException(e);
        }
        return resultDoc;
    }

    public static String expandReferencesInText(String value) {
        StringBuilder wrapper = new StringBuilder("<value>");
        wrapper.append(value).append("</value>");
        StringReader reader = new StringReader(wrapper.toString());
        String str = null;
        try {
            XMLStreamReader xsr = STAX_FACTORY.createXMLStreamReader(reader);
            xsr.nextTag();
            str = xsr.getElementText();
        }
        catch (XMLStreamException xse) {
            LOGR.log(Level.WARNING, xse.getMessage(), xse);
        }
        return str;
    }

    public static Document importElement(Element elem) {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOGR.log(Level.WARNING, null, ex);
        }
        Document newDoc = docBuilder.newDocument();
        Node newNode = newDoc.importNode(elem, true);
        newDoc.appendChild(newNode);
        return newDoc;
    }

    public static List<Node> asList(NodeList nodeList) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    public static String TransformXMLDocumentToXMLString(Document xmlDoc) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        StringWriter out = new StringWriter();
        tf.transform(new DOMSource(xmlDoc), new StreamResult(out));
        return ((Object)out).toString();
    }

    public static boolean isMultipleXMLSchemaValid(String xmlString, String[] arrXsdPath) throws Exception {
        try {
            Schema schema = ValidationUtils.createMultipleSchema(arrXsdPath);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xmlString)));
        }
        catch (IOException | SAXException e) {
            System.out.println("Exception: " + e.getMessage());
            String s2 = "Exception: " + e.getMessage();
            throw new Exception(s2);
        }
        return true;
    }

    public static boolean isMultipleXMLSchemaValid(Document doc, ArrayList<String> arrayList) throws Exception {
        String[] arrayXsdPath = new String[arrayList.size()];
        arrayList.toArray(arrayXsdPath);
        return XMLUtils.isMultipleXMLSchemaValid(doc, arrayXsdPath);
    }

    public static boolean isMultipleXMLSchemaValid(Document doc, String[] arrXsdPath) throws Exception {
        String str = XMLUtils.TransformXMLDocumentToXMLString(doc);
        return XMLUtils.isMultipleXMLSchemaValid(str, arrXsdPath);
    }

    public static boolean hasChildWithAttribute(Element element, String attributeName) {
        NodeList childNodes = element.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            if (!(childNode instanceof Element) || !((Element)childNode).hasAttribute(attributeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRefValid(String xpathExpr, String attr, List<String> allowedElement, Document doc) throws Exception {
        NodeList nodeList = XMLUtils.getNodeListByXPath(doc, xpathExpr);
        boolean isRefValid = true;
        for (int i = 0; i < nodeList.getLength() && isRefValid; ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            Element currentElement = (Element)currentNode;
            if (!currentElement.hasAttribute(attr)) {
                return false;
            }
            String hrefName = currentElement.getAttribute("xlink:href").replace("#", "");
            String findReferenceExpression = "//*[@gml:id='" + hrefName + "']";
            Node xlinkNode = XMLUtils.getNodeByXPath(doc, findReferenceExpression);
            String name = xlinkNode.getNodeName();
            if (allowedElement.contains(name)) continue;
            return false;
        }
        return true;
    }

    public static XPath getCityGMLXPath() {
        XPathFactory xpathfactory = XPathFactory.newInstance();
        XPath xpath = xpathfactory.newXPath();
        Map<String, String> namespaceBindings = NamespaceBindings.getNamespaceMap();
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        xpath.setNamespaceContext(bindings);
        return xpath;
    }

    public static NodeList getNodeListByXPath(Document doc, String expression) {
        try {
            XPath xpath = XMLUtils.getCityGMLXPath();
            NodeList nodes = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
            return nodes;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            return null;
        }
    }

    public static NodeList getNodeListByXPath(NodeList node, String expression) {
        try {
            XPath xpath = XMLUtils.getCityGMLXPath();
            NodeList nodes = (NodeList)xpath.evaluate(expression, node, XPathConstants.NODESET);
            return nodes;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            return null;
        }
    }

    public static NodeList getNodeListByXPath(Node node, String expression) {
        try {
            XPath xpath = XMLUtils.getCityGMLXPath();
            NodeList nodes = (NodeList)xpath.evaluate(expression, node, XPathConstants.NODESET);
            return nodes;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            return null;
        }
    }

    public static Node getNodeByXPath(Document doc, String expression) {
        try {
            XPath xpath = XMLUtils.getCityGMLXPath();
            Node nodes = (Node)xpath.evaluate(expression, doc, XPathConstants.NODE);
            return nodes;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            return null;
        }
    }

    public static Node getNodeByXPath(Node node, String expression) {
        try {
            XPath xpath = XMLUtils.getCityGMLXPath();
            Node nodes = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
            return nodes;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            return null;
        }
    }

    public static ArrayList<String> GetToValidateXsdPathArrayList(Document doc) {
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        hashMap.put(ValidationUtils.getXmlns("CORE"), "xsd/opengis/citygml/schema/core.xsd");
        hashMap.put(ValidationUtils.getXmlns("APPEARANCE"), "xsd/opengis/citygml/schema/appearance.xsd");
        hashMap.put(ValidationUtils.getXmlns("BRIDGE"), "xsd/opengis/citygml/schema/bridge.xsd");
        hashMap.put(ValidationUtils.getXmlns("BUILDING"), "xsd/opengis/citygml/schema/building.xsd");
        hashMap.put(ValidationUtils.getXmlns("CITYFURNITURE"), "xsd/opengis/citygml/schema/cityFurniture.xsd");
        hashMap.put(ValidationUtils.getXmlns("CITYOBJECTGROUP"), "xsd/opengis/citygml/schema/cityObjectGroup.xsd");
        hashMap.put(ValidationUtils.getXmlns("CONSTRUCTION"), "xsd/opengis/citygml/schema/construction.xsd");
        hashMap.put(ValidationUtils.getXmlns("DYNAMIZER"), "xsd/opengis/citygml/schema/dynamizer.xsd");
        hashMap.put(ValidationUtils.getXmlns("GENERICS"), "xsd/opengis/citygml/schema/generics.xsd");
        hashMap.put(ValidationUtils.getXmlns("LANDUSE"), "xsd/opengis/citygml/schema/landUse.xsd");
        hashMap.put(ValidationUtils.getXmlns("POINTCLOUD"), "xsd/opengis/citygml/schema/pointCloud.xsd");
        hashMap.put(ValidationUtils.getXmlns("RELIEF"), "xsd/opengis/citygml/schema/relief.xsd");
        hashMap.put(ValidationUtils.getXmlns("TRANSPORTATION"), "xsd/opengis/citygml/schema/transportation.xsd");
        hashMap.put(ValidationUtils.getXmlns("TUNNEL"), "xsd/opengis/citygml/schema/tunnel.xsd");
        hashMap.put(ValidationUtils.getXmlns("VEGETATION"), "xsd/opengis/citygml/schema/vegetation.xsd");
        hashMap.put(ValidationUtils.getXmlns("VERSIONING"), "xsd/opengis/citygml/schema/versioning.xsd");
        hashMap.put(ValidationUtils.getXmlns("WATERBODY"), "xsd/opengis/citygml/schema/waterBody.xsd");
        hashMap.put("urn:oasis:names:tc:ciq:xal:3", "xsd/opengis/citygml/schema/xAL/xAL.xsd");
        Element rootElement = doc.getDocumentElement();
        NamedNodeMap namedNodeMap = rootElement.getAttributes();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attr = namedNodeMap.item(i);
            String attrName = attr.getNodeName();
            String namespaceUri = attr.getNodeValue();
            if (!attrName.contains("xmlns") || !hashMap.containsKey(namespaceUri)) continue;
            arrayList.add((String)((HashMap)hashMap).get(namespaceUri));
        }
        arrayList.add("xsd/opengis/citygml/schema/CityGML.xsd");
        arrayList.add("xsd/opengis/gml/3.2.1/gml-3.2.1.xsd");
        return arrayList;
    }
}

