/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.Optional;
import java.util.concurrent.Callable;
import org.testng.IHookable;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.invokers.MethodInvocationHelper;

public class InvokeMethodRunnable
implements Callable<Boolean> {
    private final ITestNGMethod m_method;
    private final Object m_instance;
    private final Object[] m_parameters;
    private final IHookable m_hookable;
    private final ITestResult m_testResult;

    public InvokeMethodRunnable(ITestNGMethod thisMethod, Object instance, Object[] parameters, IHookable hookable, ITestResult testResult) {
        this.m_method = thisMethod;
        this.m_instance = instance;
        this.m_parameters = parameters;
        this.m_hookable = hookable;
        this.m_testResult = testResult;
    }

    public boolean run() throws TestNGRuntimeException {
        try {
            return this.call();
        }
        catch (Exception e) {
            throw new TestNGRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runOne() {
        try {
            boolean invoked;
            TestNGRuntimeException t2 = null;
            try {
                ConstructorOrMethod m4 = this.m_method.getConstructorOrMethod();
                if (this.m_hookable == null) {
                    invoked = true;
                    MethodInvocationHelper.invokeMethod(m4.getMethod(), this.m_instance, this.m_parameters);
                } else {
                    invoked = MethodInvocationHelper.invokeHookable(this.m_instance, this.m_parameters, this.m_hookable, m4.getMethod(), this.m_testResult);
                }
            }
            catch (Throwable e) {
                invoked = true;
                Throwable cause = Optional.ofNullable(e.getCause()).orElse(e);
                t2 = new TestNGRuntimeException(cause);
            }
            if (null != t2) {
                Thread.currentThread().interrupt();
                throw t2;
            }
            boolean bl = invoked;
            return bl;
        }
        finally {
            this.m_method.incrementCurrentInvocationCount();
        }
    }

    @Override
    public Boolean call() throws Exception {
        boolean flag = true;
        if (this.m_method.getInvocationTimeOut() > 0L) {
            for (int i = 0; i < this.m_method.getInvocationCount(); ++i) {
                flag = flag && this.runOne();
            }
        } else {
            flag = this.runOne();
        }
        return flag;
    }

    public static class TestNGRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -8619899270785596231L;

        public TestNGRuntimeException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

