/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.core;

import java.util.List;
import org.opengis.cite.citygml30part2.CommonFixture;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CoreValidation
extends CommonFixture {
    final boolean CORE_ENABLE = true;
    String MODULE_NAME = "Core";

    @Test(enabled=true)
    public void VerifyCoreModule() {
        boolean foundAtLeastOne = ValidationUtils.elementValidation(this.testSubject, this.MODULE_NAME);
        Assert.assertTrue((boolean)foundAtLeastOne, (String)("No " + this.MODULE_NAME + " element was found in the document."));
    }

    @Test(enabled=true)
    public void VerifyCoreReference() {
        boolean isValid;
        List<String> allowedType = ValidationUtils.getTypeData("AbstractCityObject");
        try {
            isValid = XMLUtils.isRefValid("//core:generalizesTo", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue((boolean)isValid, (String)(this.MODULE_NAME + " Module reference invalid."));
        try {
            isValid = XMLUtils.isRefValid("//core:relatedTo", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue((boolean)isValid, (String)(this.MODULE_NAME + " Module reference invalid."));
    }

    @Test(enabled=true)
    public void VerifyCoreBoundaries() {
        String[] allowedSpace = new String[]{"core:AbstractLogicalSpace", "core:AbstractOccupiedSpace", "core:AbstractPhysicalSpace", "core:AbstractSpace", "core:AbstractUnoccupiedSpace"};
        boolean boundaryStatus = ValidationUtils.isBoundariesValid(this.testSubject, allowedSpace);
        Assert.assertTrue((boolean)boundaryStatus, (String)"None of Allowed Boundaries elements was found in the document.");
    }
}

