/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.module;

import java.util.List;
import org.opengis.cite.citygml30part2.CommonFixture;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CityObjectGroupModuleValidation
extends CommonFixture {
    final boolean MODULE_ENABLE = true;
    String MODULE_NAME = "CityObjectGroup";

    @Test(enabled=true, groups={"Module"})
    public void VerifyBridgeModule() {
        boolean foundAtLeastOne = ValidationUtils.elementValidation(this.testSubject, this.MODULE_NAME);
        Assert.assertTrue((boolean)foundAtLeastOne, (String)("No " + this.MODULE_NAME + " element was found in the document."));
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyCityObjectGroupReference() {
        boolean isValid;
        List<String> allowedType;
        try {
            allowedType = ValidationUtils.getTypeData("AbstractCityObject");
            isValid = XMLUtils.isRefValid("//grp:parent", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue((boolean)isValid, (String)(this.MODULE_NAME + " Module reference invalid."));
        try {
            allowedType = ValidationUtils.getTypeData("AbstractCityObject");
            isValid = XMLUtils.isRefValid("//grp:parent", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue((boolean)isValid, (String)(this.MODULE_NAME + " Module reference invalid."));
        try {
            allowedType = ValidationUtils.getTypeData("AbstractCityObject");
            isValid = XMLUtils.isRefValid("//grp:groupMember/grp:Role", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue((boolean)isValid, (String)(this.MODULE_NAME + " Module reference invalid."));
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyCityObjectGroupElementBoundaries() {
        String[] allowedSpace = new String[]{"grp:CityObjectGroup"};
        boolean boundaryStatus = ValidationUtils.isBoundariesValid(this.testSubject, allowedSpace);
        Assert.assertTrue((boolean)boundaryStatus, (String)"None of Allowed Boundaries elements was found in the document.");
    }
}

