/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2;

import jakarta.ws.rs.core.Response;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.glassfish.jersey.client.ClientResponse;
import org.opengis.cite.citygml30part2.ErrorMessage;
import org.opengis.cite.citygml30part2.util.NamespaceBindings;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class ETSAssert {
    private static final Logger LOGR = Logger.getLogger(ETSAssert.class.getPackage().getName());

    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals((String)node.getLocalName(), (String)qName.getLocalPart(), (String)ErrorMessage.get("LocalName"));
        Assert.assertEquals((String)node.getNamespaceURI(), (String)qName.getNamespaceURI(), (String)ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> namespaceBindings) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            LOGR.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Element elemNode = Document.class.isInstance(context) ? ((Document)Document.class.cast(context)).getDocumentElement() : (Element)context;
        Assert.assertTrue((boolean)result, (String)ErrorMessage.format("XPathResult", elemNode.getNodeName(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler((ErrorHandler)errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource, String activePhase) {
        SchematronValidator validator;
        String phase = null == activePhase || activePhase.isEmpty() ? "#ALL" : activePhase;
        try {
            validator = new SchematronValidator((Source)new StreamSource(schemaRef.toString()), phase);
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        DOMResult result = (DOMResult)validator.validate(xmlSource);
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals((int)features.getLength(), (int)expectedCount, (String)String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertExceptionReport(ClientResponse rsp, String exceptionCode, String locator) {
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document doc = (Document)rsp.readEntity(Document.class);
        String expr = String.format("//ows:Exception[@exceptionCode = '%s']", exceptionCode);
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(doc, expr, null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Assert.assertTrue((nodeList.getLength() > 0 ? 1 : 0) != 0, (String)("Exception not found in response: " + expr));
        if (null != locator && !locator.isEmpty()) {
            Element exception = (Element)nodeList.item(0);
            String locatorValue = exception.getAttribute("locator").toLowerCase();
            Assert.assertTrue((boolean)locatorValue.contains(locator.toLowerCase()), (String)String.format("Expected locator attribute to contain '%s']", locator));
        }
    }
}

