/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.module;

import java.util.ArrayList;
import org.opengis.cite.citygml30part2.CommonFixture;
import org.opengis.cite.citygml30part2.util.ValidationUtils;
import org.opengis.cite.citygml30part2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TransportationModuleValidation
extends CommonFixture {
    final boolean MODULE_ENABLE = true;
    String MODULE_NAME = "Transportation";

    @Test(enabled=true, groups={"Module"})
    public void VerifyTransportationModule() {
        boolean foundAtLeastOne = ValidationUtils.elementValidation(this.testSubject, this.MODULE_NAME);
        Assert.assertTrue((boolean)foundAtLeastOne, (String)("No " + this.MODULE_NAME + " element was found in the document."));
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyTransportationReference() {
        boolean isValid;
        ArrayList<String> allowedType = new ArrayList<String>();
        allowedType.add("tran:TrafficSpace");
        try {
            isValid = XMLUtils.isRefValid("//tran:predecessor", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue((boolean)isValid, (String)(this.MODULE_NAME + " Module reference invalid."));
        try {
            isValid = XMLUtils.isRefValid("//tran:successor", "xlink:href", allowedType, this.testSubject);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            isValid = false;
        }
        Assert.assertTrue((boolean)isValid, (String)(this.MODULE_NAME + " Module reference invalid."));
    }

    @Test(enabled=true, dependsOnGroups={"Module"})
    public void VerifyTransportationBoundaries() throws Exception {
        String[] allowedSpace = new String[]{"tran:AbstractTransportationSpace", "tran:AuxiliaryTrafficSpace", "tran:ClearanceSpace", "tran:Hole", "tran:Intersection", "tran:Railway", "tran:Road", "tran:Section", "tran:Square", "tran:Track", "tran:TrafficSpace", "tran:Waterway"};
        boolean boundaryStatus = ValidationUtils.isBoundariesValid(this.testSubject, allowedSpace);
        Assert.assertTrue((boolean)boundaryStatus, (String)"None of Allowed Boundaries elements was found in the document.");
    }
}

