/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.logging.LoggingFeature;
import org.opengis.cite.citygml30part2.ReusableEntityFilter;
import org.w3c.dom.Document;

public class ClientUtils {
    public static Client buildClient() {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.followRedirects", (Object)true);
        config.property("jersey.config.client.connectTimeout", (Object)10000);
        config.register((Object)new LoggingFeature());
        Client client = JerseyClientBuilder.newClient((Configuration)config);
        client.register((Object)new ReusableEntityFilter());
        return client;
    }

    public static MediaType removeParameters(MediaType mediaType) {
        return new MediaType(mediaType.getType(), mediaType.getSubtype());
    }

    public static Source getResponseEntityAsSource(Response response, String targetURI) {
        Source source = (Source)response.readEntity(DOMSource.class);
        if (null != targetURI && !targetURI.isEmpty()) {
            source.setSystemId(targetURI);
        }
        if (((InputStream)response.readEntity(InputStream.class)).markSupported()) {
            try {
                ((InputStream)response.readEntity(InputStream.class)).reset();
            }
            catch (IOException ex) {
                Logger.getLogger(ClientUtils.class.getName()).log(Level.WARNING, "Failed to reset response entity.", ex);
            }
        }
        return source;
    }

    public static Document getResponseEntityAsDocument(Response response, String targetURI) {
        DOMSource domSource = (DOMSource)ClientUtils.getResponseEntityAsSource(response, targetURI);
        Document entityDoc = (Document)domSource.getNode();
        entityDoc.setDocumentURI(domSource.getSystemId());
        return entityDoc;
    }
}

