/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml30part2.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceBindings
implements NamespaceContext {
    private Map<String, String> bindings = new HashMap<String, String>();

    @Override
    public String getNamespaceURI(String prefix) {
        String nsName = null;
        for (Map.Entry<String, String> binding : this.bindings.entrySet()) {
            if (!binding.getValue().equals(prefix)) continue;
            nsName = binding.getKey();
            break;
        }
        return nsName;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.bindings.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Arrays.asList(this.getPrefix(namespaceURI)).iterator();
    }

    public void addNamespaceBinding(String namespaceURI, String prefix) {
        this.bindings.put(namespaceURI, prefix);
    }

    public void addAllBindings(Map<String, String> nsBindings) {
        if (null != nsBindings) {
            this.bindings.putAll(nsBindings);
        }
    }

    public Map<String, String> getAllBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public static NamespaceBindings withStandardBindings() {
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.addNamespaceBinding("http://www.w3.org/1999/xlink", "xlink");
        nsBindings.addNamespaceBinding("http://www.opengis.net/gml/3.2", "gml");
        return nsBindings;
    }

    public String toString() {
        return "NamespaceBindings:\n" + this.bindings;
    }

    public static Map<String, String> getNamespaceMap() {
        HashMap<String, String> cityGmlMap = new HashMap<String, String>();
        cityGmlMap.put("http://www.opengis.net/citygml/appearance/3.0", "app");
        cityGmlMap.put("http://www.opengis.net/citygml/bridge/3.0", "brid");
        cityGmlMap.put("http://www.opengis.net/citygml/building/3.0", "bldg");
        cityGmlMap.put("http://www.opengis.net/citygml/pointcloud/3.0", "pcl");
        cityGmlMap.put("http://www.opengis.net/citygml/cityfurniture/3.0", "frn");
        cityGmlMap.put("http://www.opengis.net/citygml/cityobjectgroup/3.0", "grp");
        cityGmlMap.put("http://www.opengis.net/citygml/construction/3.0", "con");
        cityGmlMap.put("http://www.opengis.net/citygml/3.0", "core");
        cityGmlMap.put("http://www.opengis.net/citygml/dynamizer/3.0", "dyn");
        cityGmlMap.put("http://www.opengis.net/citygml/generics/3.0", "gen");
        cityGmlMap.put("http://www.opengis.net/citygml/landuse/3.0", "luse");
        cityGmlMap.put("http://www.opengis.net/citygml/relief/3.0", "dem");
        cityGmlMap.put("http://www.opengis.net/citygml/transportation/3.0", "tran");
        cityGmlMap.put("http://www.opengis.net/citygml/tunnel/3.0", "tun");
        cityGmlMap.put("http://www.opengis.net/citygml/vegetation/3.0", "veg");
        cityGmlMap.put("http://www.opengis.net/citygml/versioning/3.0", "vers");
        cityGmlMap.put("http://www.opengis.net/citygml/waterbody/3.0", "wtr");
        cityGmlMap.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        return cityGmlMap;
    }

    public static String getNameSpacePrefix(String ns) {
        Map<String, String> cityGmlMap = NamespaceBindings.getNamespaceMap();
        return cityGmlMap.get(ns);
    }
}

