/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers.xml;

import com.occamlab.te.parsers.xml.SchemaSupplier;
import java.io.CharArrayReader;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class InMemorySchemaSupplier
implements SchemaSupplier {
    private final char[] chars;

    public InMemorySchemaSupplier(char[] pChars) {
        this.chars = Objects.requireNonNull(pChars);
    }

    @Override
    public Source makeSource() {
        return new StreamSource(new CharArrayReader(this.chars));
    }

    public String toString() {
        return String.format("%s{%d chars}", this.getClass().getSimpleName(), this.chars.length);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof InMemorySchemaSupplier) {
            InMemorySchemaSupplier other = (InMemorySchemaSupplier)obj;
            return Arrays.equals(this.chars, other.chars);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.chars);
    }
}

