/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.report;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.Reporter;

public class ReportLog {
    public void generateLogs(ISuite suite) {
        Reporter.clear();
        Reporter.log("The result of the test is-\n\n");
        String suiteName = suite.getName();
        Map<String, ISuiteResult> suiteResults = suite.getResults();
        String input = null;
        String failReport = null;
        Object failReportConformance2 = ",";
        int passedTest = 0;
        int failedTest = 0;
        int skippedTest = 0;
        int finalPassedTest = 0;
        int finalSkippedTest = 0;
        int finalFailedTest = 0;
        int count = 0;
        String date = null;
        for (ISuiteResult sr : suiteResults.values()) {
            ITestContext tc = sr.getTestContext();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            if (++count == 1) {
                date = dateFormat.format(cal.getTime());
                input = tc.getAttribute("Input").toString();
                failReport = tc.getAttribute("TestResultReport").toString();
                passedTest = tc.getPassedTests().getAllResults().size();
                skippedTest = tc.getSkippedTests().getAllResults().size();
                failedTest = tc.getFailedTests().getAllResults().size();
                continue;
            }
            int no_of_failedTest = tc.getFailedTests().getAllResults().size();
            int no_of_skippedTest = tc.getSkippedTests().getAllResults().size();
            int no_of_passedTest = tc.getPassedTests().getAllResults().size();
            if (no_of_failedTest == 0 && no_of_passedTest == 0) continue;
            failReportConformance2 = no_of_failedTest == 0 && no_of_passedTest != 0 ? (String)failReportConformance2 + ", " + input + " conform to the clause A." + count + " of " + suiteName : (String)failReportConformance2 + ", " + input + " does not conform to the clause A." + count + " of " + suiteName;
            finalPassedTest += no_of_passedTest;
            finalSkippedTest += no_of_skippedTest;
            finalFailedTest += no_of_failedTest;
        }
        skippedTest += finalSkippedTest;
        passedTest += finalPassedTest;
        String result = (failedTest += finalFailedTest) > 0 ? "Fail" : "Pass";
        Reporter.log("**RESULT: " + result);
        Reporter.log("**INPUT: " + input);
        Reporter.log("**TEST NAME AND VERSION    :" + suiteName);
        Reporter.log("**DATE AND TIME PERFORMED  :" + date);
        Reporter.log("Passed tests for suite '" + suiteName + "' is:" + passedTest);
        Reporter.log("Failed tests for suite '" + suiteName + "' is:" + failedTest);
        Reporter.log("Skipped tests for suite '" + suiteName + "' is:" + skippedTest);
        Reporter.log("\nREASON:\n\n");
        Reporter.log(failReport);
        Reporter.log((String)failReportConformance2);
    }
}

