/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nvdl;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.nvdl.SchemaImpl;
import com.thaiopensource.validate.nvdl.ValidatorImpl;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.SAXSchemaReader;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String NVDL_SCHEMA = "nvdl.rng";
    private static final String RNC_MEDIA_TYPE = "application/relax-ng-compact-syntax";
    static final String LEGACY_RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final Name attributeOwner;
    private final SchemaReader autoSchemaReader;
    private Schema nvdlSchema = null;
    private static final PropertyId[] subSchemaProperties = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, SchemaReceiverFactory.PROPERTY};

    public SchemaReceiverImpl(PropertyMap propertyMap) {
        this.attributeOwner = propertyMap.get(WrapProperty.ATTRIBUTE_OWNER);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        for (int i = 0; i < subSchemaProperties.length; ++i) {
            Object t2 = propertyMap.get(subSchemaProperties[i]);
            if (t2 == null) continue;
            propertyMapBuilder.put(subSchemaProperties[i], t2);
        }
        this.properties = propertyMapBuilder.toPropertyMap();
        this.autoSchemaReader = new AutoSchemaReader(propertyMap.get(SchemaReceiverFactory.PROPERTY));
    }

    public SchemaFuture installHandlers(XMLReader xMLReader) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (this.attributeOwner != null) {
            propertyMapBuilder.put(WrapProperty.ATTRIBUTE_OWNER, this.attributeOwner);
        }
        return new SchemaImpl(propertyMapBuilder.toPropertyMap()).installHandlers(xMLReader, this);
    }

    Schema getNvdlSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.nvdlSchema == null) {
            String string = SchemaReceiverImpl.class.getName();
            String string2 = string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resources/" + NVDL_SCHEMA;
            URL uRL = SchemaReceiverImpl.getResource(string2);
            InputStream inputStream = uRL.openStream();
            InputSource inputSource = new InputSource(uRL.toString());
            inputSource.setByteStream(inputStream);
            this.nvdlSchema = SAXSchemaReader.getInstance().createSchema(inputSource, this.properties);
        }
        return this.nvdlSchema;
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(SAXSource sAXSource, String string, PropertyMap propertyMap, boolean bl) throws IOException, IncorrectSchemaException, SAXException {
        SchemaReader schemaReader = SchemaReceiverImpl.isRnc(string) ? CompactSchemaReader.getInstance() : this.autoSchemaReader;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (bl) {
            propertyMapBuilder.put(WrapProperty.ATTRIBUTE_OWNER, ValidatorImpl.OWNER_NAME);
        }
        propertyMapBuilder.add(propertyMap);
        return schemaReader.createSchema(sAXSource, propertyMapBuilder.toPropertyMap());
    }

    Option getOption(String string) {
        Option option = this.autoSchemaReader.getOption(string);
        if (option != null) {
            return option;
        }
        return CompactSchemaReader.getInstance().getOption(string);
    }

    private static boolean isRnc(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim()).equals(RNC_MEDIA_TYPE) || string.equals(LEGACY_RNC_MEDIA_TYPE);
    }
}

