/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class RegexGroup
extends SystemFunction
implements XSLTFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        AtomicValue gp0 = (AtomicValue)this.argument[0].evaluateItem(c);
        NumericValue gp = (NumericValue)gp0;
        RegexIterator iter = c.getCurrentRegexIterator();
        if (iter == null) {
            return StringValue.EMPTY_STRING;
        }
        String s2 = iter.getRegexGroup((int)gp.longValue());
        if (s2 == null) {
            return StringValue.EMPTY_STRING;
        }
        return StringValue.makeStringValue(s2);
    }

    public int getIntrinsicDependencies() {
        return 64;
    }
}

