/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.ResourceUtils;

public class DocumentManagerAssembler
extends AssemblerBase {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.DocumentManager);
        OntDocumentManager result = this.createDocumentManager();
        result.setMetadataSearchPath(this.getPath(a, root), false);
        result.configure(ResourceUtils.reachableClosure(root), false);
        result.setFileManager(this.getFileManager(a, root));
        return result;
    }

    private String getPath(Assembler a, Resource root) {
        String s2 = DocumentManagerAssembler.getUniqueString(root, JA.policyPath);
        return s2 == null ? "file:ont-policy.rdf;file:etc/ont-policy.rdf;ont-policy.rdf" : s2;
    }

    private FileManager getFileManager(Assembler a, Resource root) {
        Resource fm = DocumentManagerAssembler.getUniqueResource(root, JA.fileManager);
        return fm == null ? FileManager.getInternal() : (FileManager)a.open(fm);
    }

    protected OntDocumentManager createDocumentManager() {
        return new OntDocumentManager("");
    }
}

