/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.RuleSet;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.rulesys.Rule;

public class RuleSetAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.RuleSet);
        return RuleSetAssembler.createRuleSet(a, root);
    }

    public static RuleSet createRuleSet(Assembler a, Resource root) {
        return RuleSet.create(RuleSetAssembler.addRules(new ArrayList<Rule>(), a, root));
    }

    public static List<Rule> addRules(List<Rule> result, Assembler a, Resource root) {
        RuleSetAssembler.addLiteralRules(root, result);
        RuleSetAssembler.addIndirectRules(a, root, result);
        RuleSetAssembler.addExternalRules(root, result);
        return result;
    }

    private static void addIndirectRules(Assembler a, Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rules);
        while (it.hasNext()) {
            Resource r = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(((RuleSet)a.open(r)).getRules());
        }
    }

    private static void addExternalRules(Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rulesFrom);
        while (it.hasNext()) {
            Resource s2 = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(Rule.rulesFromURL(s2.getURI()));
        }
    }

    private static void addLiteralRules(Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rule);
        while (it.hasNext()) {
            String s2 = RuleSetAssembler.getString(it.nextStatement());
            result.addAll(Rule.parseRules(s2));
        }
    }
}

