/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers.xml;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.occamlab.te.parsers.xml.SchemaLoader;
import com.occamlab.te.parsers.xml.SchemaSupplier;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public class CachingSchemaLoader
implements SchemaLoader {
    private final SchemaLoader wrappedLoader;
    private final LoadingCache<ImmutableList<SchemaSupplier>, Schema> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ImmutableList<SchemaSupplier>, Schema>(){

        public Schema load(ImmutableList<SchemaSupplier> suppliers) throws SAXException {
            return CachingSchemaLoader.this.wrappedLoader.loadSchema(suppliers);
        }
    });

    public CachingSchemaLoader(SchemaLoader pWrappedLoader) {
        this.wrappedLoader = Objects.requireNonNull(pWrappedLoader);
    }

    @Override
    public Schema loadSchema(ImmutableList<SchemaSupplier> suppliers) throws SAXException {
        try {
            return (Schema)this.cache.get(suppliers);
        }
        catch (ExecutionException ex) {
            throw (SAXException)ex.getCause();
        }
    }

    @Override
    public Schema defaultSchema() throws SAXException {
        return this.wrappedLoader.defaultSchema();
    }
}

