/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import com.occamlab.te.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Utils {
    private static Logger jlogger = Logger.getLogger("com.occamlab.te.util.Utils");
    private static String JAR_URI_PREFIX = "jar:file:";

    public static String randomString(int len, Random random) {
        if (len < 1) {
            return "";
        }
        int start = 32;
        int end = 123;
        StringBuffer buffer = new StringBuffer();
        int gap = end - start;
        while (len-- != 0) {
            char ch = (char)(random.nextInt(gap) + start);
            if (Character.isLetterOrDigit(ch)) {
                buffer.append(ch);
                continue;
            }
            ++len;
        }
        return buffer.toString();
    }

    public static String generateMD5(String text) {
        byte[] md5hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md5hash = new byte[8];
            md.update(text.getBytes(StandardCharsets.ISO_8859_1), 0, text.length());
            md5hash = md.digest();
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "Error generating MD5: " + e.getMessage(), e);
            System.out.println("Error generating MD5: " + e.getMessage());
            return "";
        }
        return Utils.convertToHex(md5hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String evaluateXPointer(String xpointer, InputStream is) {
        String results = "";
        int xmlnsStart = xpointer.indexOf("xmlns(") + "xmlns(".length();
        int xmlnsEnd = xpointer.indexOf(")", xmlnsStart);
        int xpathStart = xpointer.indexOf("xpointer(") + "xpointer(".length();
        int xpathEnd = xpointer.indexOf(")", xpathStart);
        String xmlnsStr = xpointer.substring(xmlnsStart, xmlnsEnd);
        String xpathStr = xpointer.substring(xpathStart, xpathEnd);
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String[] namespaces = xmlnsStr.split(",");
            MyNamespaceContext context = new MyNamespaceContext();
            for (int i = 0; i < namespaces.length; ++i) {
                String[] xmlnsParts = namespaces[i].split("=");
                context.setNamespace(xmlnsParts[0], xmlnsParts[1]);
                xpath.setNamespaceContext(context);
            }
            InputSource src = new InputSource(is);
            results = xpath.evaluate(xpathStr, src);
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "Error in evaluating XPointer.  " + e.getMessage(), e);
            System.out.println("Error in evaluating XPointer.  " + e.getMessage());
        }
        return results;
    }

    public static String evaluateXPointer(String xpointer, Document doc) {
        InputStream is = null;
        try {
            is = IOUtils.DocumentToInputStream(doc);
        }
        catch (IOException e) {
            jlogger.log(Level.SEVERE, "evaluateXPointer", e);
        }
        return Utils.evaluateXPointer(xpointer, is);
    }

    public static String evaluateXPointer(String xpointer, byte[] bytes) {
        Document doc = null;
        try {
            ByteArrayInputStream baip = new ByteArrayInputStream(bytes);
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(baip);
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "evaluateXPointer", e);
        }
        return Utils.evaluateXPointer(xpointer, doc);
    }

    public static void copyResourceDir(URL resourceDirUrl, File destDir) throws IOException {
        String resourceDirUrlString = resourceDirUrl.toString();
        String resourceDir = resourceDirUrl.getPath();
        int indexOfExcMark = resourceDirUrlString.indexOf("!");
        if (resourceDirUrlString.startsWith(JAR_URI_PREFIX) && indexOfExcMark > -1) {
            try {
                Utils.copyResourcesFromJar(new JarFile(resourceDirUrlString.substring(JAR_URI_PREFIX.length(), indexOfExcMark)), resourceDirUrlString.substring(indexOfExcMark + 2), destDir);
            }
            catch (IOException e) {
                jlogger.log(Level.SEVERE, "Could not copy resources from jar.", e);
            }
        } else {
            FileUtils.copyDirectory((File)new File(resourceDir), (File)destDir);
        }
    }

    private static void copyResourcesFromJar(JarFile jarFile, String jarDir, File htmlOutput) throws IOException {
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (!jarEntry.getName().startsWith(jarDir + "/") || jarEntry.isDirectory()) continue;
            File dest = new File(htmlOutput.getAbsolutePath() + "/" + jarEntry.getName().substring(jarDir.length() + 1));
            File parent = dest.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            try (FileOutputStream out = new FileOutputStream(dest);){
                InputStream in = jarFile.getInputStream(jarEntry);
                try {
                    byte[] buffer = new byte[8192];
                    int s = 0;
                    while ((s = in.read(buffer)) > 0) {
                        out.write(buffer, 0, s);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                throw new IOException("Could not copy resource from jar file: " + jarEntry.getName(), e);
            }
        }
    }

    public static class MyNamespaceContext
    implements NamespaceContext {
        private Map<String, String> map = new HashMap<String, String>();

        public void setNamespace(String prefix, String namespaceURI) {
            this.map.put(prefix, namespaceURI);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.map.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            Set<String> keys = this.map.keySet();
            for (String prefix : keys) {
                String uri = this.map.get(prefix);
                if (!uri.equals(namespaceURI)) continue;
                return prefix;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            Set<String> keys = this.map.keySet();
            for (String prefix : keys) {
                String uri = this.map.get(prefix);
                if (!uri.equals(namespaceURI)) continue;
                prefixes.add(prefix);
            }
            return prefixes.iterator();
        }
    }
}

