/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.TEClassLoader;
import com.occamlab.te.TeErrorListener;
import com.occamlab.te.index.FunctionEntry;
import com.occamlab.te.index.Index;
import com.occamlab.te.index.TemplateEntry;
import com.occamlab.te.index.TestEntry;
import com.occamlab.te.saxon.TEFunctionLibrary;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;

public class Engine {
    int cacheSize = 50;
    Processor processor = null;
    XsltCompiler compiler = null;
    DocumentBuilder builder = null;
    TeErrorListener errorListener = null;
    XsltExecutable formExecutable = null;
    public Map<String, XsltExecutable> loadedExecutables = Collections.synchronizedMap(new LinkedHashMap(256, 0.75f, true));
    public Map<String, TEClassLoader> classLoaders;

    public Engine(Index index, String sourcesName, TEClassLoader cl) throws Exception {
        this();
        ArrayList<Index> indexes = new ArrayList<Index>();
        indexes.add(index);
        this.classLoaders = new HashMap<String, TEClassLoader>();
        this.classLoaders.put(sourcesName, cl);
        this.addFunctionLibrary(indexes);
    }

    public Engine(Collection<Index> indexes, Map<String, TEClassLoader> classLoaders, int cacheSize) throws Exception {
        this();
        this.classLoaders = classLoaders;
        if (cacheSize > 0) {
            this.cacheSize = cacheSize;
        }
        this.addFunctionLibrary(indexes);
    }

    public Engine() throws Exception {
        String s = System.getProperty("te.cacheSize");
        if (s != null) {
            this.cacheSize = Integer.parseInt(s);
        }
        this.processor = new Processor(false);
        Configuration config = this.processor.getUnderlyingConfiguration();
        config.setVersionWarning(false);
        this.errorListener = new TeErrorListener();
        config.setErrorListener((ErrorListener)this.errorListener);
        this.compiler = this.processor.newXsltCompiler();
        this.builder = this.processor.newDocumentBuilder();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("com/occamlab/te/formfn.xsl");
        this.formExecutable = this.compiler.compile((Source)new StreamSource(is));
        is.close();
    }

    public void addFunctionLibrary(Collection<Index> indexes) {
        Configuration config = this.processor.getUnderlyingConfiguration();
        FunctionLibraryList liblist = new FunctionLibraryList();
        for (Index index : indexes) {
            TEFunctionLibrary telib = new TEFunctionLibrary(config, index);
            liblist.addFunctionLibrary((FunctionLibrary)telib);
        }
        liblist.addFunctionLibrary(config.getExtensionBinder("java"));
        config.setExtensionBinder("java", (FunctionLibrary)liblist);
    }

    public void preload(Index index, String sourcesName) throws Exception {
        for (String key : index.getTestKeys()) {
            TestEntry te = index.getTest(key);
            this.loadExecutable(te, sourcesName);
        }
        for (String key : index.getFunctionKeys()) {
            List<FunctionEntry> functions = index.getFunctions(key);
            for (FunctionEntry fe : functions) {
                if (fe.isJava()) continue;
                this.loadExecutable(fe, sourcesName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean freeExecutable() {
        Set<String> keys = this.loadedExecutables.keySet();
        Map<String, XsltExecutable> map = this.loadedExecutables;
        synchronized (map) {
            Iterator<String> it = keys.iterator();
            if (it.hasNext()) {
                this.loadedExecutables.remove(it.next());
                return true;
            }
        }
        return false;
    }

    public XsltExecutable loadExecutable(TemplateEntry entry, String sourcesName) throws Exception {
        boolean freed;
        String key = sourcesName + "," + entry.getId();
        if (entry instanceof FunctionEntry) {
            key = key + "_" + ((FunctionEntry)entry).getMinArgs();
        }
        XsltExecutable executable = this.loadedExecutables.get(key);
        while (executable == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream console = System.err;
            try {
                System.setErr(new PrintStream(baos));
                StreamSource source = new StreamSource(entry.getTemplateFile());
                executable = this.compiler.compile((Source)source);
                this.loadedExecutables.put(key, executable);
            }
            catch (OutOfMemoryError e) {
                boolean freed2 = this.freeExecutable();
                if (freed2) continue;
                throw e;
            }
            catch (SaxonApiException e) {
                throw new Exception(baos.toString() + e.getMessage(), e.getCause());
            }
            finally {
                System.setErr(console);
            }
        }
        while (this.loadedExecutables.size() > this.cacheSize && (freed = this.freeExecutable())) {
        }
        return executable;
    }

    public Map<String, XsltExecutable> getLoadedExecutables() {
        return this.loadedExecutables;
    }

    public TEClassLoader getClassLoader(String sourcesName) {
        return this.classLoaders.get(sourcesName);
    }

    public DocumentBuilder getBuilder() {
        return this.builder;
    }

    public XsltCompiler getCompiler() {
        return this.compiler;
    }

    public TeErrorListener getErrorListener() {
        return this.errorListener;
    }

    public XsltExecutable getFormExecutable() {
        return this.formExecutable;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setClassLoader(String sourcesName, TEClassLoader cl) {
        if (null == this.classLoaders) {
            this.classLoaders = new HashMap<String, TEClassLoader>();
        }
        this.classLoaders.put(sourcesName, cl);
    }
}

