/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val;

import com.reprezen.jsonoverlay.ListOverlay;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.val.BaseValidationMessages;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.msg.Messages;
import java.util.List;
import java.util.Map;

public class ReferencesChecker {
    public static void checkReferences(ListOverlay<?> list, ValidationResults results) {
        Overlay<List<?>> listAdapter = Overlay.of(list);
        for (int i = 0; i < list.size(); ++i) {
            if (!listAdapter.isReference(i)) continue;
            ReferencesChecker.checkReference(listAdapter.getReference(i), results, Overlay.of(list, i));
        }
    }

    public static void checkReferences(MapOverlay<?> map, ValidationResults results) {
        Overlay<Map<String, ?>> mapAdapter = Overlay.of(map);
        for (String key : map.keySet()) {
            if (!mapAdapter.isReference(key)) continue;
            ReferencesChecker.checkReference(mapAdapter.getReference(key), results, Overlay.of(map, key));
        }
    }

    public static void checkReferences(PropertiesOverlay<?> props, ValidationResults results) {
        if (props._isElaborated()) {
            Overlay<?> propsAdapter = Overlay.of(props);
            for (String name : propsAdapter.getPropertyNames()) {
                if (!propsAdapter.isReference(name)) continue;
                ReferencesChecker.checkReference(propsAdapter.getReference(name), results, Overlay.of(props, name, Object.class));
            }
        }
    }

    public static void checkReference(Reference ref, ValidationResults results, Overlay<?> context) {
        if (ref.isInvalid()) {
            results.addError(Messages.msg(BaseValidationMessages.BadRef, ref.getRefString(), ref.getInvalidReason()), context);
        }
    }
}

