/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.kaizen.oasparser.model3.EncodingProperty;
import com.reprezen.kaizen.oasparser.model3.Example;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.msg.Messages;
import com.reprezen.kaizen.oasparser.val3.EncodingPropertyValidator;
import com.reprezen.kaizen.oasparser.val3.ExampleValidator;
import com.reprezen.kaizen.oasparser.val3.OpenApi3Messages;
import com.reprezen.kaizen.oasparser.val3.SchemaValidator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class MediaTypeValidator
extends ObjectValidatorBase<MediaType> {
    @Override
    public void runObjectValidations() {
        MediaType mediaType = (MediaType)((Object)this.value.getOverlay());
        this.validateField("schema", false, Schema.class, new SchemaValidator(), new Consumer[0]);
        this.validateMapField("encodingProperties", false, false, EncodingProperty.class, new EncodingPropertyValidator());
        this.checkEncodingPropsAreProps(mediaType, this.results);
        this.validateExtensions(mediaType.getExtensions());
        Overlay<Map<String, Example>> examples = this.validateMapField("examples", false, false, Example.class, new ExampleValidator());
        Overlay<Object> example = this.validateField("example", false, Object.class, null, new Consumer[0]);
        this.checkExampleExclusion(examples, example);
    }

    void checkEncodingPropsAreProps(MediaType mediaType, ValidationResults results) {
        Schema schema = mediaType.getSchema(false);
        if (schema != null && Overlay.of(schema).isElaborated()) {
            Set<String> propNames = schema.getProperties().keySet();
            Map<String, EncodingProperty> encProps = mediaType.getEncodingProperties();
            for (String encodingPropertyName : encProps.keySet()) {
                if (propNames.contains(encodingPropertyName)) continue;
                results.addError(Messages.msg(OpenApi3Messages.EncPropNotSchemaProp, encodingPropertyName), Overlay.of(encProps, encodingPropertyName));
            }
        }
    }

    void checkExampleExclusion(Overlay<Map<String, Example>> examples, Overlay<Object> example) {
        boolean examplePresent;
        boolean examplesPresent = examples != null && examples.isPresent() && Overlay.getMapOverlay(examples).size() > 0;
        boolean bl = examplePresent = example != null && example.isPresent();
        if (examplesPresent && examplePresent) {
            this.results.addError("ExmplExclusion|The 'example' and 'exmaples' properties may not both appear", this.value);
        }
    }
}

