/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.NsIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.RDFWriterF;
import org.apache.jena.rdf.model.RSIterator;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceF;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.IteratorFactory;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelListenerAdapter;
import org.apache.jena.rdf.model.impl.ModelReifier;
import org.apache.jena.rdf.model.impl.NsIteratorImpl;
import org.apache.jena.rdf.model.impl.RDFReaderFImpl;
import org.apache.jena.rdf.model.impl.RDFWriterFImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.Command;
import org.apache.jena.shared.InvalidPropertyURIException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRSW;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.shared.WrappedIOException;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.FilterIterator;
import org.apache.jena.util.iterator.Map1Iterator;
import org.apache.jena.vocabulary.RDF;

public class ModelCom
extends EnhGraph
implements Model,
PrefixMapping,
Lock {
    private static final RDFReaderF readerFactory = new RDFReaderFImpl();
    private static final RDFWriterF writerFactory = new RDFWriterFImpl();
    private Lock modelLock = null;
    private static PrefixMapping defaultPrefixMapping = PrefixMapping.Factory.create();
    protected ModelReifier modelReifier = new ModelReifier(this);

    public ModelCom(Graph base) {
        this(base, BuiltinPersonalities.model);
    }

    public ModelCom(Graph base, Personality<RDFNode> personality) {
        super(base, personality);
        this.withDefaultMappings(defaultPrefixMapping);
    }

    public static PrefixMapping getDefaultModelPrefixes() {
        return defaultPrefixMapping;
    }

    public static PrefixMapping setDefaultModelPrefixes(PrefixMapping pm) {
        PrefixMapping result = defaultPrefixMapping;
        defaultPrefixMapping = pm;
        return result;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    protected static Model createWorkModel() {
        return ModelFactory.createDefaultModel();
    }

    @Override
    public RDFNode asRDFNode(Node n) {
        return n.isLiteral() ? this.getNodeAs(n, Literal.class) : this.getNodeAs(n, Resource.class);
    }

    @Override
    public Resource wrapAsResource(Node n) {
        if (n.isLiteral()) {
            throw new UnsupportedOperationException("literal cannot be converted to Resource");
        }
        return this.getNodeAs(n, Resource.class);
    }

    @Override
    @Deprecated
    public Resource getResource(String uri, ResourceF f) {
        try {
            return f.createResource(this.getResource(uri));
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    @Override
    public Model addLiteral(Resource s, Property p, boolean o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, long o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, int o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, char o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, float o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, double o) {
        return this.add(s, p, this.createTypedLiteral(o));
    }

    @Override
    public Model add(Resource s, Property p, String o) {
        return this.add(s, p, o, "", false);
    }

    @Override
    public Model add(Resource s, Property p, String o, boolean wellFormed) {
        this.add(s, p, this.literal(o, "", wellFormed));
        return this;
    }

    public Model add(Resource s, Property p, String o, String lang, boolean wellFormed) {
        this.add(s, p, this.literal(o, lang, wellFormed));
        return this;
    }

    @Override
    public Model add(Resource s, Property p, String lex, RDFDatatype datatype) {
        this.add(s, p, this.literal(lex, datatype));
        return this;
    }

    private Literal literal(String s, String lang, boolean wellFormed) {
        return new LiteralImpl(NodeFactory.createLiteral(s, lang, wellFormed), this);
    }

    private Literal literal(String lex, RDFDatatype datatype) {
        return new LiteralImpl(NodeFactory.createLiteral(lex, datatype), this);
    }

    @Override
    public Model add(Resource s, Property p, String o, String l) {
        return this.add(s, p, o, l, false);
    }

    @Override
    @Deprecated
    public Model addLiteral(Resource s, Property p, Object o) {
        return this.add(s, p, this.asObject(o));
    }

    @Override
    public Model addLiteral(Resource s, Property p, Literal o) {
        return this.add(s, p, o);
    }

    private RDFNode asObject(Object o) {
        return o instanceof RDFNode ? (RDFNode)o : this.createTypedLiteral(o);
    }

    @Override
    public Model add(StmtIterator iter) {
        try {
            GraphUtil.add(this.getGraph(), this.asTriples(iter));
        }
        finally {
            iter.close();
        }
        return this;
    }

    @Override
    public Model add(Model m) {
        GraphUtil.addInto(this.getGraph(), m.getGraph());
        return this;
    }

    @Override
    public RDFReader getReader() {
        return readerFactory.getReader();
    }

    @Override
    public RDFReader getReader(String lang) {
        return readerFactory.getReader(lang);
    }

    @Override
    @Deprecated
    public String setReaderClassName(String lang, String className) {
        return readerFactory.setReaderClassName(lang, className);
    }

    @Override
    @Deprecated
    public void resetRDFReaderF() {
        readerFactory.resetRDFReaderF();
    }

    @Override
    @Deprecated
    public String removeReader(String lang) throws IllegalArgumentException {
        return readerFactory.removeReader(lang);
    }

    @Override
    public Model read(String url) {
        readerFactory.getReader().read(this, url);
        return this;
    }

    @Override
    public Model read(Reader reader, String base) {
        readerFactory.getReader().read((Model)this, reader, base);
        return this;
    }

    @Override
    public Model read(InputStream reader, String base) {
        readerFactory.getReader().read((Model)this, reader, base);
        return this;
    }

    @Override
    public Model read(String url, String lang) {
        readerFactory.getReader(lang).read(this, url);
        return this;
    }

    @Override
    public Model read(String url, String base, String lang) {
        try (InputStream is = new URL(url).openStream();){
            this.read(is, base, lang);
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        return this;
    }

    @Override
    public Model read(Reader reader, String base, String lang) {
        readerFactory.getReader(lang).read((Model)this, reader, base);
        return this;
    }

    @Override
    public Model read(InputStream reader, String base, String lang) {
        readerFactory.getReader(lang).read((Model)this, reader, base);
        return this;
    }

    @Override
    public RDFWriter getWriter() {
        return writerFactory.getWriter();
    }

    @Override
    public RDFWriter getWriter(String lang) {
        return writerFactory.getWriter(lang);
    }

    @Override
    @Deprecated
    public String setWriterClassName(String lang, String className) {
        return writerFactory.setWriterClassName(lang, className);
    }

    @Override
    @Deprecated
    public void resetRDFWriterF() {
        writerFactory.resetRDFWriterF();
    }

    @Override
    @Deprecated
    public String removeWriter(String lang) throws IllegalArgumentException {
        return writerFactory.removeWriter(lang);
    }

    @Override
    public Model write(Writer writer) {
        this.getWriter().write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(Writer writer, String lang) {
        this.getWriter(lang).write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(Writer writer, String lang, String base) {
        this.getWriter(lang).write((Model)this, writer, base);
        return this;
    }

    @Override
    public Model write(OutputStream writer) {
        this.getWriter().write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(OutputStream writer, String lang) {
        this.getWriter(lang).write((Model)this, writer, "");
        return this;
    }

    @Override
    public Model write(OutputStream writer, String lang, String base) {
        this.getWriter(lang).write((Model)this, writer, base);
        return this;
    }

    @Override
    public Model remove(Statement s) {
        this.graph.delete(s.asTriple());
        return this;
    }

    @Override
    public Model remove(Resource s, Property p, RDFNode o) {
        this.graph.delete(Triple.create(s.asNode(), p.asNode(), o.asNode()));
        return this;
    }

    @Override
    public Model remove(StmtIterator iter) {
        GraphUtil.delete(this.getGraph(), this.asTriples(iter));
        return this;
    }

    @Override
    public Model remove(Model m) {
        GraphUtil.deleteFrom(this.getGraph(), m.getGraph());
        return this;
    }

    @Override
    public Model removeAll() {
        this.getGraph().clear();
        return this;
    }

    @Override
    public Model removeAll(Resource s, Property p, RDFNode o) {
        this.getGraph().remove(ModelCom.asNode(s), ModelCom.asNode(p), ModelCom.asNode(o));
        return this;
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, boolean o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, long o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, int o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, char o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, float o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, double o) {
        return this.contains(s, p, this.createTypedLiteral(o));
    }

    @Override
    public boolean contains(Resource s, Property p, String o) {
        return this.contains(s, p, o, "");
    }

    @Override
    public boolean contains(Resource s, Property p, String o, String l) {
        return this.contains(s, p, this.literal(o, l, false));
    }

    @Override
    public boolean containsLiteral(Resource s, Property p, Object o) {
        return this.contains(s, p, this.asObject(o));
    }

    @Override
    public boolean containsAny(Model model) {
        return this.containsAnyThenClose(model.listStatements());
    }

    @Override
    public boolean containsAll(Model model) {
        return this.containsAllThenClose(model.listStatements());
    }

    protected boolean containsAnyThenClose(StmtIterator iter) {
        try {
            boolean bl = this.containsAny(iter);
            return bl;
        }
        finally {
            iter.close();
        }
    }

    protected boolean containsAllThenClose(StmtIterator iter) {
        try {
            boolean bl = this.containsAll(iter);
            return bl;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public boolean containsAny(StmtIterator iter) {
        while (iter.hasNext()) {
            if (!this.contains(iter.nextStatement())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(StmtIterator iter) {
        while (iter.hasNext()) {
            if (this.contains(iter.nextStatement())) continue;
            return false;
        }
        return true;
    }

    protected StmtIterator listStatements(Resource S, Property P, Node O) {
        return IteratorFactory.asStmtIterator(this.graph.find(ModelCom.asNode(S), ModelCom.asNode(P), O), this);
    }

    @Override
    public StmtIterator listStatements(Resource S, Property P, RDFNode O) {
        return this.listStatements(S, P, ModelCom.asNode(O));
    }

    @Override
    public StmtIterator listStatements(Resource S, Property P, String O) {
        return O == null ? this.listStatements(S, P, Node.ANY) : this.listStatements(S, P, NodeFactory.createLiteral(O));
    }

    @Override
    public StmtIterator listStatements(Resource S, Property P, String O, String L) {
        if (O != null) {
            if (L != null) {
                return this.listStatements(S, P, NodeFactory.createLiteral(O, L));
            }
            return new StringFilteredStmtIterator(O, this.listStatements(S, P, Node.ANY));
        }
        return new LangFilteredStmtIterator(L, this.listStatements(S, P, Node.ANY));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, boolean O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, long O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, int O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, char O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, float O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public StmtIterator listLiteralStatements(Resource S, Property P, double O) {
        return this.listStatements(S, P, this.createTypedLiteral(O));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, boolean o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, char o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, long o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, float o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, double o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, Object o) {
        return this.listResourcesWithProperty(p, this.createTypedLiteral(o));
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p, RDFNode o) {
        return this.listResourcesWithProperty(p, o);
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p, String o) {
        return this.listSubjectsWithProperty(p, o, "");
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p, String o, String l) {
        return this.listResourcesWithProperty(p, this.literal(o, l, false));
    }

    @Override
    public Resource createResource(Resource type) {
        return this.createResource().addProperty(RDF.type, type);
    }

    @Override
    public Resource createResource(String uri, Resource type) {
        return this.getResource(uri).addProperty(RDF.type, type);
    }

    @Override
    @Deprecated
    public Resource createResource(ResourceF f) {
        return this.createResource(null, f);
    }

    @Override
    public Resource createResource(AnonId id) {
        return new ResourceImpl(id, this);
    }

    @Override
    @Deprecated
    public Resource createResource(String uri, ResourceF f) {
        return f.createResource(this.createResource(uri));
    }

    @Override
    public Literal createTypedLiteral(boolean v) {
        return this.createTypedLiteral(new Boolean(v));
    }

    @Override
    public Literal createTypedLiteral(int v) {
        return this.createTypedLiteral(new Integer(v));
    }

    @Override
    public Literal createTypedLiteral(long v) {
        return this.createTypedLiteral(new Long(v));
    }

    @Override
    public Literal createTypedLiteral(char v) {
        return this.createTypedLiteral(new Character(v));
    }

    @Override
    public Literal createTypedLiteral(float v) {
        return this.createTypedLiteral(new Float(v));
    }

    @Override
    public Literal createTypedLiteral(double v) {
        return this.createTypedLiteral(new Double(v));
    }

    @Override
    public Literal createTypedLiteral(String v) {
        LiteralLabel ll = LiteralLabelFactory.createTypedLiteral(v);
        return new LiteralImpl(NodeFactory.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(Calendar cal) {
        XSDDateTime value = new XSDDateTime(cal);
        LiteralLabel ll = LiteralLabelFactory.createByValue(value, "", XSDDatatype.XSDdateTime);
        return new LiteralImpl(NodeFactory.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        return new LiteralImpl(NodeFactory.createLiteral(lex, dtype), this);
    }

    @Override
    public Literal createTypedLiteral(Object value, RDFDatatype dtype) {
        LiteralLabel ll = LiteralLabelFactory.createByValue(value, "", dtype);
        return new LiteralImpl(NodeFactory.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(String lex, String typeURI) {
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(typeURI);
        LiteralLabel ll = LiteralLabelFactory.create(lex, dt);
        return new LiteralImpl(NodeFactory.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(Object value, String typeURI) {
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(typeURI);
        LiteralLabel ll = LiteralLabelFactory.createByValue(value, "", dt);
        return new LiteralImpl(NodeFactory.createLiteral(ll), this);
    }

    @Override
    public Literal createTypedLiteral(Object value) {
        if (value instanceof Calendar) {
            return this.createTypedLiteral((Calendar)value);
        }
        LiteralLabel ll = LiteralLabelFactory.createTypedLiteral(value);
        return new LiteralImpl(NodeFactory.createLiteral(ll), this);
    }

    @Override
    public Literal createLiteral(String v) {
        return this.createLiteral(v, "");
    }

    @Override
    public Literal createLiteral(String v, String l) {
        return this.literal(v, l, false);
    }

    @Override
    public Literal createLiteral(String v, boolean wellFormed) {
        return this.literal(v, "", wellFormed);
    }

    public Literal createLiteral(String v, String l, boolean wellFormed) {
        return this.literal(v, l, wellFormed);
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, boolean o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, long o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, int o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, char o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, float o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, double o) {
        return this.createStatement(r, p, this.createTypedLiteral(o));
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o) {
        return this.createStatement(r, p, this.createLiteral(o));
    }

    @Override
    public Statement createLiteralStatement(Resource r, Property p, Object o) {
        return this.createStatement(r, p, this.asObject(o));
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o, boolean wellFormed) {
        return this.createStatement(r, p, o, "", wellFormed);
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o, String l) {
        return this.createStatement(r, p, o, l, false);
    }

    @Override
    public Statement createStatement(Resource r, Property p, String o, String l, boolean wellFormed) {
        return this.createStatement(r, p, this.literal(o, l, wellFormed));
    }

    @Override
    public Bag createBag() {
        return this.createBag(null);
    }

    @Override
    public Alt createAlt() {
        return this.createAlt(null);
    }

    @Override
    public Seq createSeq() {
        return this.createSeq(null);
    }

    @Override
    public RDFList createList() {
        return this.getResource(RDF.nil.getURI()).as(RDFList.class);
    }

    @Override
    public RDFList createList(Iterator<? extends RDFNode> members) {
        RDFList list = this.createList();
        while (members != null && members.hasNext()) {
            list = list.with(members.next());
        }
        return list;
    }

    @Override
    public RDFList createList(RDFNode[] members) {
        return this.createList(Arrays.asList(members).iterator());
    }

    @Override
    public RDFNode getRDFNode(Node n) {
        return this.asRDFNode(n);
    }

    @Override
    public Resource getResource(String uri) {
        return IteratorFactory.asResource(ModelCom.makeURI(uri), this);
    }

    @Override
    public Property getProperty(String uri) {
        if (uri == null) {
            throw new InvalidPropertyURIException(null);
        }
        return IteratorFactory.asProperty(ModelCom.makeURI(uri), this);
    }

    @Override
    public Property getProperty(String nameSpace, String localName) {
        return this.getProperty(nameSpace + localName);
    }

    @Override
    public Seq getSeq(String uri) {
        return (Seq)IteratorFactory.asResource(ModelCom.makeURI(uri), Seq.class, this);
    }

    @Override
    public Seq getSeq(Resource r) {
        return r.inModel(this).as(Seq.class);
    }

    @Override
    public Bag getBag(String uri) {
        return (Bag)IteratorFactory.asResource(ModelCom.makeURI(uri), Bag.class, this);
    }

    @Override
    public Bag getBag(Resource r) {
        return r.inModel(this).as(Bag.class);
    }

    private static Node makeURI(String uri) {
        return uri == null ? NodeFactory.createBlankNode() : NodeFactory.createURI(uri);
    }

    @Override
    public Alt getAlt(String uri) {
        return (Alt)IteratorFactory.asResource(ModelCom.makeURI(uri), Alt.class, this);
    }

    @Override
    public Alt getAlt(Resource r) {
        return r.inModel(this).as(Alt.class);
    }

    @Override
    public long size() {
        return this.graph.size();
    }

    @Override
    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    private void updateNamespace(Set<String> set, Iterator<Node> it) {
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isURI()) continue;
            String uri = node.getURI();
            String ns = uri.substring(0, Util.splitNamespaceXML(uri));
            set.add(ns);
        }
    }

    private ExtendedIterator<Node> listPredicates() {
        return GraphUtil.listPredicates(this.graph, Node.ANY, Node.ANY);
    }

    private Iterator<Node> listTypes() {
        Set types = CollectionFactory.createHashedSet();
        ExtendedIterator<Triple> it = this.graph.find(null, RDF.type.asNode(), null);
        while (it.hasNext()) {
            types.add(((Triple)it.next()).getObject());
        }
        return types.iterator();
    }

    @Override
    public NsIterator listNameSpaces() {
        Set<String> nameSpaces = CollectionFactory.createHashedSet();
        this.updateNamespace(nameSpaces, this.listPredicates());
        this.updateNamespace(nameSpaces, this.listTypes());
        return new NsIteratorImpl(nameSpaces.iterator(), nameSpaces);
    }

    private PrefixMapping getPrefixMapping() {
        return this.getGraph().getPrefixMapping();
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getPrefixMapping().samePrefixMappingAs(other);
    }

    @Override
    public PrefixMapping lock() {
        this.getPrefixMapping().lock();
        return this;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.getPrefixMapping().setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.getPrefixMapping().removeNsPrefix(prefix);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping pm) {
        this.getPrefixMapping().setNsPrefixes(pm);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        this.getPrefixMapping().setNsPrefixes(map);
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        this.getPrefixMapping().withDefaultMappings(other);
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.getPrefixMapping().getNsPrefixURI(prefix);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.getPrefixMapping().getNsURIPrefix(uri);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.getPrefixMapping().getNsPrefixMap();
    }

    @Override
    public String expandPrefix(String prefixed) {
        return this.getPrefixMapping().expandPrefix(prefixed);
    }

    @Override
    public String qnameFor(String uri) {
        return this.getPrefixMapping().qnameFor(uri);
    }

    @Override
    public String shortForm(String uri) {
        return this.getPrefixMapping().shortForm(uri);
    }

    public static void addNamespaces(Model m, Map<String, Set<String>> ns) {
        Model pm = m;
        for (Map.Entry<String, Set<String>> e : ns.entrySet()) {
            String key = e.getKey();
            Set<String> values = e.getValue();
            Set niceValues = CollectionFactory.createHashedSet();
            for (String uri : values) {
                if (!PrefixMappingImpl.isNiceURI(uri)) continue;
                niceValues.add(uri);
            }
            if (niceValues.size() != 1) continue;
            pm.setNsPrefix(key, (String)niceValues.iterator().next());
        }
    }

    @Override
    public StmtIterator listStatements() {
        return IteratorFactory.asStmtIterator(GraphUtil.findAll(this.graph), this);
    }

    @Override
    public Model add(Statement s) {
        this.add(s.getSubject(), s.getPredicate(), s.getObject());
        return this;
    }

    @Override
    public Model add(Statement[] statements) {
        GraphUtil.add(this.getGraph(), StatementImpl.asTriples(statements));
        return this;
    }

    @Override
    public Model add(List<Statement> statements) {
        GraphUtil.add(this.getGraph(), this.asTriples(statements));
        return this;
    }

    private List<Triple> asTriples(List<Statement> statements) {
        ArrayList<Triple> L = new ArrayList<Triple>(statements.size());
        for (Statement statement : statements) {
            L.add(statement.asTriple());
        }
        return L;
    }

    private Iterator<Triple> asTriples(StmtIterator it) {
        return it.mapWith(s -> s.asTriple());
    }

    @Override
    public Model remove(Statement[] statements) {
        GraphUtil.delete(this.getGraph(), StatementImpl.asTriples(statements));
        return this;
    }

    @Override
    public Model remove(List<Statement> statements) {
        GraphUtil.delete(this.getGraph(), this.asTriples(statements));
        return this;
    }

    @Override
    public Model add(Resource s, Property p, RDFNode o) {
        this.modelReifier.noteIfReified(s, p, o);
        this.graph.add(Triple.create(s.asNode(), p.asNode(), o.asNode()));
        return this;
    }

    @Override
    public RSIterator listReifiedStatements() {
        return this.modelReifier.listReifiedStatements();
    }

    @Override
    public RSIterator listReifiedStatements(Statement st) {
        return this.modelReifier.listReifiedStatements(st);
    }

    @Override
    public boolean isReified(Statement s) {
        return this.modelReifier.isReified(s);
    }

    @Override
    public Resource getAnyReifiedStatement(Statement s) {
        return this.modelReifier.getAnyReifiedStatement(s);
    }

    @Override
    public void removeAllReifications(Statement s) {
        this.modelReifier.removeAllReifications(s);
    }

    @Override
    public void removeReification(ReifiedStatement rs) {
        this.modelReifier.removeReification(rs);
    }

    @Override
    public ReifiedStatement createReifiedStatement(Statement s) {
        return this.modelReifier.createReifiedStatement(s);
    }

    @Override
    public ReifiedStatement createReifiedStatement(String uri, Statement s) {
        return this.modelReifier.createReifiedStatement(uri, s);
    }

    @Override
    public boolean contains(Statement s) {
        return this.graph.contains(s.asTriple());
    }

    @Override
    public boolean containsResource(RDFNode r) {
        return GraphUtil.containsNode(this.graph, r.asNode());
    }

    @Override
    public boolean contains(Resource s, Property p) {
        return this.contains(s, p, (RDFNode)null);
    }

    @Override
    public boolean contains(Resource s, Property p, RDFNode o) {
        return this.graph.contains(ModelCom.asNode(s), ModelCom.asNode(p), ModelCom.asNode(o));
    }

    @Override
    public Statement getRequiredProperty(Resource s, Property p) {
        Statement st = this.getProperty(s, p);
        if (st == null) {
            throw new PropertyNotFoundException(p);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getProperty(Resource s, Property p) {
        try (StmtIterator iter = this.listStatements(s, p, (RDFNode)null);){
            Statement statement = iter.hasNext() ? iter.nextStatement() : null;
            return statement;
        }
    }

    public static Node asNode(RDFNode x) {
        return x == null ? Node.ANY : x.asNode();
    }

    private NodeIterator listObjectsFor(RDFNode s, RDFNode p) {
        ExtendedIterator<Node> xit = GraphUtil.listObjects(this.graph, ModelCom.asNode(s), ModelCom.asNode(p));
        return IteratorFactory.asRDFNodeIterator(xit, this);
    }

    private ResIterator listSubjectsFor(RDFNode p, RDFNode o) {
        ExtendedIterator<Node> xit = GraphUtil.listSubjects(this.graph, ModelCom.asNode(p), ModelCom.asNode(o));
        return IteratorFactory.asResIterator(xit, this);
    }

    @Override
    public ResIterator listSubjects() {
        return this.listSubjectsFor(null, null);
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p) {
        return this.listSubjectsFor(p, null);
    }

    @Override
    public ResIterator listSubjectsWithProperty(Property p) {
        return this.listResourcesWithProperty(p);
    }

    @Override
    public ResIterator listResourcesWithProperty(Property p, RDFNode o) {
        return this.listSubjectsFor(p, o);
    }

    @Override
    public NodeIterator listObjects() {
        return this.listObjectsFor(null, null);
    }

    @Override
    public NodeIterator listObjectsOfProperty(Property p) {
        return this.listObjectsFor(null, p);
    }

    @Override
    public NodeIterator listObjectsOfProperty(Resource s, Property p) {
        return this.listObjectsFor(s, p);
    }

    @Override
    public StmtIterator listStatements(Selector selector) {
        StmtIterator sts = IteratorFactory.asStmtIterator(this.findTriplesFrom(selector), this);
        return selector.isSimple() ? sts : new StmtIteratorImpl((Iterator<Statement>)sts.filterKeep(selector));
    }

    public ExtendedIterator<Triple> findTriplesFrom(Selector s) {
        return this.graph.find(ModelCom.asNode(s.getSubject()), ModelCom.asNode(s.getPredicate()), ModelCom.asNode(s.getObject()));
    }

    @Override
    public boolean supportsTransactions() {
        return this.getTransactionHandler().transactionsSupported();
    }

    @Override
    public Model begin() {
        this.getTransactionHandler().begin();
        return this;
    }

    @Override
    public Model abort() {
        this.getTransactionHandler().abort();
        return this;
    }

    @Override
    public Model commit() {
        this.getTransactionHandler().commit();
        return this;
    }

    @Override
    public Object executeInTransaction(Command cmd) {
        return this.getTransactionHandler().executeInTransaction(cmd);
    }

    private TransactionHandler getTransactionHandler() {
        return this.getGraph().getTransactionHandler();
    }

    @Override
    public boolean independent() {
        return true;
    }

    @Override
    public Resource createResource() {
        return IteratorFactory.asResource(NodeFactory.createBlankNode(), this);
    }

    @Override
    public Resource createResource(String uri) {
        return this.getResource(uri);
    }

    @Override
    public Property createProperty(String uri) {
        return this.getProperty(uri);
    }

    @Override
    public Property createProperty(String nameSpace, String localName) {
        return this.getProperty(nameSpace, localName);
    }

    @Override
    public Statement createStatement(Resource r, Property p, RDFNode o) {
        return new StatementImpl(r, p, o, this);
    }

    @Override
    public Bag createBag(String uri) {
        return (Bag)this.getBag(uri).addProperty(RDF.type, RDF.Bag);
    }

    @Override
    public Alt createAlt(String uri) {
        return (Alt)this.getAlt(uri).addProperty(RDF.type, RDF.Alt);
    }

    @Override
    public Seq createSeq(String uri) {
        return (Seq)this.getSeq(uri).addProperty(RDF.type, RDF.Seq);
    }

    @Override
    public Statement asStatement(Triple t) {
        return StatementImpl.toStatement(t, this);
    }

    public Statement[] asStatements(Triple[] triples) {
        Statement[] result = new Statement[triples.length];
        for (int i = 0; i < triples.length; ++i) {
            result[i] = this.asStatement(triples[i]);
        }
        return result;
    }

    public List<Statement> asStatements(List<Triple> triples) {
        ArrayList<Statement> L = new ArrayList<Statement>(triples.size());
        for (Triple triple : triples) {
            L.add(this.asStatement(triple));
        }
        return L;
    }

    public Model asModel(Graph g) {
        return new ModelCom(g);
    }

    public StmtIterator asStatements(Iterator<Triple> it) {
        return new StmtIteratorImpl((Iterator<Statement>)new Map1Iterator<Triple, Statement>(t -> this.asStatement((Triple)t), it));
    }

    public StmtIterator listBySubject(Container cont) {
        return this.listStatements((Resource)cont, null, (RDFNode)null);
    }

    @Override
    public void close() {
        this.graph.close();
    }

    @Override
    public boolean isClosed() {
        return this.graph.isClosed();
    }

    @Override
    public boolean supportsSetOperations() {
        return true;
    }

    @Override
    public Model query(Selector selector) {
        return ModelCom.createWorkModel().add(this.listStatements(selector));
    }

    @Override
    public Model union(Model model) {
        return ModelCom.createWorkModel().add(this).add(model);
    }

    @Override
    public Model intersection(Model other) {
        return this.size() < other.size() ? ModelCom.intersect(this, other) : ModelCom.intersect(other, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model intersect(Model smaller, Model larger) {
        Model result = ModelCom.createWorkModel();
        try (StmtIterator it = smaller.listStatements();){
            Model model = ModelCom.addCommon(result, it, larger);
            return model;
        }
    }

    protected static Model addCommon(Model result, StmtIterator it, Model other) {
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!other.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model difference(Model model) {
        Model resultModel = ModelCom.createWorkModel();
        StmtIterator iter = null;
        try {
            iter = this.listStatements();
            while (iter.hasNext()) {
                Statement stmt = iter.nextStatement();
                if (model.contains(stmt)) continue;
                resultModel.add(stmt);
            }
            Model model2 = resultModel;
            return model2;
        }
        finally {
            if (null != iter) {
                iter.close();
            }
        }
    }

    public String toString() {
        return "<ModelCom  " + this.getGraph() + " | " + this.reifiedToString() + ">";
    }

    public String reifiedToString() {
        return this.statementsToString(this.listStatements());
    }

    protected String statementsToString(StmtIterator it) {
        StringBuilder b = new StringBuilder();
        while (it.hasNext()) {
            b.append(" ").append(it.nextStatement());
        }
        return b.toString();
    }

    @Override
    public boolean isIsomorphicWith(Model m) {
        Graph L = this.getGraph();
        Graph R = m.getGraph();
        return L.isIsomorphicWith(R);
    }

    public synchronized Lock getModelLock() {
        if (this.modelLock == null) {
            this.modelLock = new LockMRSW();
        }
        return this.modelLock;
    }

    @Override
    public synchronized Lock getLock() {
        return this.getModelLock();
    }

    @Override
    public void enterCriticalSection(boolean requestReadLock) {
        this.getModelLock().enterCriticalSection(requestReadLock);
    }

    @Override
    public void leaveCriticalSection() {
        this.getModelLock().leaveCriticalSection();
    }

    @Override
    public Model register(ModelChangedListener listener) {
        this.getGraph().getEventManager().register(this.adapt(listener));
        return this;
    }

    @Override
    public Model unregister(ModelChangedListener listener) {
        this.getGraph().getEventManager().unregister(this.adapt(listener));
        return this;
    }

    public GraphListener adapt(ModelChangedListener L) {
        return new ModelListenerAdapter(this, L);
    }

    @Override
    public Model notifyEvent(Object e) {
        this.getGraph().getEventManager().notifyEvent(this.getGraph(), e);
        return this;
    }

    static {
        JenaSystem.init();
    }

    private class LangFilteredStmtIterator
    extends FilterIterator<Statement>
    implements StmtIterator {
        public LangFilteredStmtIterator(String l, Iterator<Statement> it) {
            super((T s) -> {
                RDFNode o = s.getObject();
                if (o instanceof Literal) {
                    if (l == null) {
                        return true;
                    }
                    return l.equals(o.asLiteral().getLanguage());
                }
                return false;
            }, it);
        }

        @Override
        public Statement nextStatement() {
            return (Statement)this.next();
        }
    }

    private class StringFilteredStmtIterator
    extends FilterIterator<Statement>
    implements StmtIterator {
        public StringFilteredStmtIterator(String str, Iterator<Statement> it) {
            super((T s) -> {
                RDFNode o = s.getObject();
                if (o instanceof Literal) {
                    if (str == null) {
                        return true;
                    }
                    return str.equals(o.asLiteral().getString());
                }
                return false;
            }, it);
        }

        @Override
        public Statement nextStatement() {
            return (Statement)this.next();
        }
    }
}

