/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import org.geotoolkit.math.Vector;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.converter.Numbers;

final class SequenceVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 7980737287789566091L;
    private final Class<? extends Number> type;
    private final double first;
    private final double increment;
    private final int length;

    public SequenceVector(double d, double d2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format(72, "length", n));
        }
        this.first = d;
        this.increment = d2;
        this.length = n;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            this.type = null;
        } else {
            Class<? extends Number> clazz = Numbers.finestClass(d);
            clazz = Numbers.widestClass(clazz, Numbers.finestClass(d + d2));
            clazz = Numbers.widestClass(clazz, Numbers.finestClass(d + d2 * (double)(n - 1)));
            this.type = clazz;
        }
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Class<? extends Number> getElementType() {
        return this.type != null ? this.type : Float.class;
    }

    @Override
    public boolean isNaN(int n) {
        return this.type == null;
    }

    @Override
    public double doubleValue(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.length, n);
        return this.first + this.increment * (double)n;
    }

    @Override
    public float floatValue(int n) throws IndexOutOfBoundsException {
        return (float)this.doubleValue(n);
    }

    @Override
    public long longValue(int n) throws IndexOutOfBoundsException {
        return Math.round(this.doubleValue(n));
    }

    @Override
    public int intValue(int n) throws IndexOutOfBoundsException {
        return (int)this.longValue(n);
    }

    @Override
    public short shortValue(int n) throws IndexOutOfBoundsException {
        return (short)this.longValue(n);
    }

    @Override
    public byte byteValue(int n) throws IndexOutOfBoundsException {
        return (byte)this.longValue(n);
    }

    @Override
    public Number get(int n) throws IndexOutOfBoundsException {
        return this.doubleValue(n);
    }

    @Override
    public Number set(int n, Number number) {
        throw new UnsupportedOperationException();
    }

    @Override
    Vector createSubList(int n, int n2, int n3) {
        return new SequenceVector(this.doubleValue(n), this.increment * (double)n2, n3);
    }
}

