/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.jaxb.gco.DateAsLongAdapter;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

@Immutable
@XmlType(name="AbstractDatumType")
public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String[] LOCALIZABLES = new String[]{"anchorPoint", "scope"};
    @XmlElement
    private final InternationalString anchorPoint;
    @XmlElement
    @XmlJavaTypeAdapter(value=DateAsLongAdapter.class, type=long.class)
    private final long realizationEpoch;
    @XmlElement(name="validArea")
    private final Extent domainOfValidity;
    @XmlElement
    private final InternationalString scope;

    private AbstractDatum() {
        this(NilReferencingObject.INSTANCE);
    }

    public AbstractDatum(Datum datum) {
        super(datum);
        Date date = datum.getRealizationEpoch();
        this.realizationEpoch = date != null ? date.getTime() : Long.MIN_VALUE;
        this.domainOfValidity = datum.getDomainOfValidity();
        this.scope = datum.getScope();
        this.anchorPoint = datum.getAnchorPoint();
    }

    public AbstractDatum(Map<String, ?> map) {
        this(map, new HashMap<String, Object>());
    }

    private AbstractDatum(Map<String, ?> map, Map<String, Object> map2) {
        super(map, map2, LOCALIZABLES);
        this.anchorPoint = (InternationalString)map2.get("anchorPoint");
        Date date = (Date)map2.get("realizationEpoch");
        this.domainOfValidity = (Extent)map2.get("domainOfValidity");
        this.scope = (InternationalString)map2.get("scope");
        this.realizationEpoch = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    static Map<String, Object> name(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        InternationalString internationalString = Vocabulary.formatInternational(n);
        hashMap.put("name", internationalString.toString(null));
        hashMap.put("alias", internationalString);
        return hashMap;
    }

    @Override
    public InternationalString getAnchorPoint() {
        return this.anchorPoint;
    }

    @Override
    public Date getRealizationEpoch() {
        return this.realizationEpoch != Long.MIN_VALUE ? new Date(this.realizationEpoch) : null;
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    int getLegacyDatumType() {
        return 0;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractDatum abstractDatum = (AbstractDatum)object;
                    return this.realizationEpoch == abstractDatum.realizationEpoch && Utilities.equals(this.domainOfValidity, abstractDatum.domainOfValidity) && Utilities.equals(this.anchorPoint, abstractDatum.anchorPoint) && Utilities.equals(this.scope, abstractDatum.scope);
                }
                case BY_CONTRACT: {
                    Datum datum = (Datum)object;
                    return Utilities.deepEquals(this.getRealizationEpoch(), datum.getRealizationEpoch(), comparisonMode) && Utilities.deepEquals(this.getDomainOfValidity(), datum.getDomainOfValidity(), comparisonMode) && Utilities.deepEquals(this.getAnchorPoint(), datum.getAnchorPoint(), comparisonMode) && Utilities.deepEquals(this.getScope(), datum.getScope(), comparisonMode);
                }
            }
            IdentifiedObject identifiedObject = (IdentifiedObject)object;
            return this.nameMatches(identifiedObject.getName().getCode()) || IdentifiedObjects.nameMatches(identifiedObject, this.getName().getCode());
        }
        return false;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.append(this.getLegacyDatumType());
        return Classes.getShortClassName(this);
    }
}

