/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.referencing.Semaphores;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.quality.AbstractPositionalAccuracy;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@Immutable
public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection<PositionalAccuracy> coordinateOperationAccuracy;
    protected final Extent domainOfValidity;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(conversion);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.operationVersion = conversion.getOperationVersion();
        this.coordinateOperationAccuracy = conversion.getCoordinateOperationAccuracy();
        this.domainOfValidity = conversion.getDomainOfValidity();
        this.scope = conversion.getScope();
        this.transform = mathTransform;
    }

    public AbstractCoordinateOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        this(map, new HashMap<String, Object>(), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
    }

    private AbstractCoordinateOperation(Map<String, ?> map, Map<String, Object> map2, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(map, map2, LOCALIZABLES);
        this.domainOfValidity = (Extent)map2.get("domainOfValidity");
        this.scope = (InternationalString)map2.get("scope");
        this.operationVersion = (String)map2.get("operationVersion");
        Object object = map2.get("coordinateOperationAccuracy");
        if (object instanceof PositionalAccuracy[]) {
            Object[] objectArray = (PositionalAccuracy[])((PositionalAccuracy[])object).clone();
            for (int i = 0; i < objectArray.length; ++i) {
                ArgumentChecks.ensureNonNull("coordinateOperationAccuracy", i, objectArray);
            }
            this.coordinateOperationAccuracy = InternalUtilities.nonEmptySet(objectArray);
        } else {
            this.coordinateOperationAccuracy = object == null ? Collections.emptySet() : Collections.singleton((PositionalAccuracy)object);
        }
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.transform = mathTransform;
        this.validate();
    }

    void validate() throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("sourceCRS", this.sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", this.targetCRS);
        ArgumentChecks.ensureNonNull("transform", this.transform);
        AbstractCoordinateOperation.checkDimension("sourceCRS", this.sourceCRS, this.transform.getSourceDimensions());
        AbstractCoordinateOperation.checkDimension("targetCRS", this.targetCRS, this.transform.getTargetDimensions());
    }

    private static void checkDimension(String string, CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        int n2 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n2 != n) {
            throw new IllegalArgumentException(Errors.format(113, string, n2, n));
        }
    }

    @Override
    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    @Override
    public String getOperationVersion() {
        return this.operationVersion;
    }

    @Override
    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        if (this.coordinateOperationAccuracy == null) {
            return Collections.emptySet();
        }
        return this.coordinateOperationAccuracy;
    }

    public double getAccuracy() {
        return AbstractCoordinateOperation.accuracy(this);
    }

    public static double getAccuracy(CoordinateOperation coordinateOperation) {
        if (coordinateOperation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)coordinateOperation).getAccuracy();
        }
        return AbstractCoordinateOperation.accuracy(coordinateOperation);
    }

    private static double accuracy(CoordinateOperation coordinateOperation) {
        Collection<PositionalAccuracy> collection = coordinateOperation.getCoordinateOperationAccuracy();
        if (collection != null) {
            for (PositionalAccuracy positionalAccuracy : collection) {
                if (positionalAccuracy == null) continue;
                for (Result object : positionalAccuracy.getResults()) {
                    Unit<?> unit;
                    QuantitativeResult quantitativeResult;
                    Collection<? extends Record> collection2;
                    if (!(object instanceof QuantitativeResult) || (collection2 = (quantitativeResult = (QuantitativeResult)object).getValues()) == null || !Units.isLinear(unit = quantitativeResult.getValueUnit())) continue;
                    Unit<Length> unit2 = unit.asType(Length.class);
                    for (Record record : collection2) {
                        for (Object object2 : record.getAttributes().values()) {
                            if (!(object2 instanceof Number)) continue;
                            double d = ((Number)object2).doubleValue();
                            d = unit2.getConverterTo(SI.METRE).convert(d);
                            return d;
                        }
                    }
                }
            }
        }
        if (coordinateOperation instanceof Conversion) {
            return 0.0;
        }
        if (coordinateOperation instanceof Transformation) {
            if (!collection.contains(AbstractPositionalAccuracy.DATUM_SHIFT_OMITTED) && collection.contains(AbstractPositionalAccuracy.DATUM_SHIFT_APPLIED)) {
                return 25.0;
            }
            return 1000.0;
        }
        double d = Double.NaN;
        if (coordinateOperation instanceof ConcatenatedOperation) {
            for (SingleOperation singleOperation : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                double d2 = Math.abs(AbstractCoordinateOperation.getAccuracy(singleOperation));
                if (Double.isNaN(d2)) continue;
                if (Double.isNaN(d)) {
                    d = d2;
                    continue;
                }
                d += d2;
            }
        }
        return d;
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class<? extends CoordinateOperation> getType(CoordinateOperation coordinateOperation) {
        if (coordinateOperation instanceof Transformation) {
            return Transformation.class;
        }
        if (coordinateOperation instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (coordinateOperation instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (coordinateOperation instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (coordinateOperation instanceof Projection) {
            return Projection.class;
        }
        if (coordinateOperation instanceof Conversion) {
            return Conversion.class;
        }
        if (coordinateOperation instanceof SingleOperation) {
            return SingleOperation.class;
        }
        if (coordinateOperation instanceof ConcatenatedOperation) {
            return ConcatenatedOperation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    CoordinateOperation coordinateOperation = (AbstractCoordinateOperation)object;
                    if (Utilities.equals(this.sourceCRS, ((AbstractCoordinateOperation)coordinateOperation).sourceCRS) && Utilities.equals(this.transform, ((AbstractCoordinateOperation)coordinateOperation).transform) && Utilities.equals(this.domainOfValidity, ((AbstractCoordinateOperation)coordinateOperation).domainOfValidity) && Utilities.equals(this.scope, ((AbstractCoordinateOperation)coordinateOperation).scope) && Utilities.equals(this.coordinateOperationAccuracy, ((AbstractCoordinateOperation)coordinateOperation).coordinateOperationAccuracy)) break;
                    return false;
                }
                case BY_CONTRACT: {
                    CoordinateOperation coordinateOperation = (CoordinateOperation)object;
                    if (!(Utilities.deepEquals(this.getScope(), coordinateOperation.getScope(), comparisonMode) && Utilities.deepEquals(this.getDomainOfValidity(), coordinateOperation.getDomainOfValidity(), comparisonMode) && Utilities.deepEquals(this.getCoordinateOperationAccuracy(), coordinateOperation.getCoordinateOperationAccuracy(), comparisonMode))) {
                        return false;
                    }
                }
                default: {
                    CoordinateOperation coordinateOperation = (CoordinateOperation)object;
                    if (Utilities.deepEquals(this.getSourceCRS(), coordinateOperation.getSourceCRS(), comparisonMode) && Utilities.deepEquals(this.getMathTransform(), coordinateOperation.getMathTransform(), comparisonMode)) break;
                    return false;
                }
            }
            if (Semaphores.queryAndSet(1)) {
                return true;
            }
            try {
                if (comparisonMode == ComparisonMode.STRICT) {
                    boolean bl = Utilities.equals(this.targetCRS, ((AbstractCoordinateOperation)object).targetCRS);
                    return bl;
                }
                boolean bl = Utilities.deepEquals(this.getTargetCRS(), ((CoordinateOperation)object).getTargetCRS(), comparisonMode);
                return bl;
            }
            finally {
                Semaphores.clear(1);
            }
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.sourceCRS, Utilities.hash(this.targetCRS, Utilities.hash(this.transform, super.computeHashCode())));
    }

    @Override
    public String formatWKT(Formatter formatter) {
        AbstractCoordinateOperation.append(formatter, this.sourceCRS, "SOURCE");
        AbstractCoordinateOperation.append(formatter, this.targetCRS, "TARGET");
        return super.formatWKT(formatter);
    }

    static void append(Formatter formatter, IdentifiedObject identifiedObject, final String string) {
        if (identifiedObject != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("name", formatter.getName(identifiedObject));
            hashMap.put("identifiers", formatter.getIdentifier(identifiedObject));
            formatter.append(new AbstractIdentifiedObject(hashMap){

                @Override
                public String formatWKT(Formatter formatter) {
                    return string;
                }
            });
        }
    }
}

