/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import javax.vecmath.SingularMatrixException;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.VerticalDatumTypes;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultEngineeringCRS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotoolkit.referencing.operation.CachingCoordinateOperationFactory;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.DefaultPassThroughOperation;
import org.geotoolkit.referencing.operation.DefaultSingleOperation;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.Matrix4;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@ThreadSafe
public class DefaultCoordinateOperationFactory
extends AbstractCoordinateOperationFactory {
    private final String molodenskyMethod;
    private final boolean lenientDatumShift;

    public DefaultCoordinateOperationFactory() {
        this(EMPTY_HINTS);
    }

    public DefaultCoordinateOperationFactory(Hints hints) {
        super(hints);
        String string = "Molodensky";
        boolean bl = false;
        if (hints != null) {
            Object object = hints.get(Hints.DATUM_SHIFT_METHOD);
            if (object instanceof String && (string = (String)object).trim().equalsIgnoreCase("Geocentric")) {
                string = null;
            }
            if ((object = hints.get(Hints.LENIENT_DATUM_SHIFT)) instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        this.molodenskyMethod = string;
        this.lenientDatumShift = bl;
        this.hints.put(Hints.DATUM_SHIFT_METHOD, string != null ? string : "Geocentric");
        this.hints.put(Hints.LENIENT_DATUM_SHIFT, bl);
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.after(CachingCoordinateOperationFactory.class, false);
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        DefaultCoordinateOperationFactory.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        DefaultCoordinateOperationFactory.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            int n = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem);
            assert (n == DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem2)) : n;
            return this.createFromAffineTransform(IDENTITY, coordinateReferenceSystem, coordinateReferenceSystem2, Matrices.create(n + 1));
        }
        IdentifiedObject identifiedObject = this.createFromDatabase(coordinateReferenceSystem, coordinateReferenceSystem2);
        if (identifiedObject != null) {
            return identifiedObject;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            identifiedObject = (CompoundCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof CompoundCRS) {
                return this.createOperationStep((CompoundCRS)identifiedObject, (CompoundCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof SingleCRS) {
                return this.createOperationStep((CompoundCRS)identifiedObject, (SingleCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem2 instanceof CompoundCRS) {
            identifiedObject = (CompoundCRS)coordinateReferenceSystem2;
            if (coordinateReferenceSystem instanceof SingleCRS) {
                return this.createOperationStep((SingleCRS)coordinateReferenceSystem, (CompoundCRS)identifiedObject);
            }
        }
        if (coordinateReferenceSystem instanceof GeographicCRS) {
            identifiedObject = (GeographicCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                return this.createOperationStep((GeographicCRS)identifiedObject, (GeographicCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof ProjectedCRS) {
                return this.createOperationStep((GeographicCRS)identifiedObject, (ProjectedCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof GeocentricCRS) {
                return this.createOperationStep((GeographicCRS)identifiedObject, (GeocentricCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                return this.createOperationStep((GeographicCRS)identifiedObject, (VerticalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            identifiedObject = (ProjectedCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof ProjectedCRS) {
                return this.createOperationStep((ProjectedCRS)identifiedObject, (ProjectedCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                return this.createOperationStep((ProjectedCRS)identifiedObject, (GeographicCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof GeocentricCRS) {
            identifiedObject = (GeocentricCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof GeocentricCRS) {
                return this.createOperationStep((GeocentricCRS)identifiedObject, (GeocentricCRS)coordinateReferenceSystem2);
            }
            if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                return this.createOperationStep((GeocentricCRS)identifiedObject, (GeographicCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            identifiedObject = (VerticalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof VerticalCRS) {
                return this.createOperationStep((VerticalCRS)identifiedObject, (VerticalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            identifiedObject = (TemporalCRS)coordinateReferenceSystem;
            if (coordinateReferenceSystem2 instanceof TemporalCRS) {
                return this.createOperationStep((TemporalCRS)identifiedObject, (TemporalCRS)coordinateReferenceSystem2);
            }
        }
        if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
            identifiedObject = (GeneralDerivedCRS)coordinateReferenceSystem2;
            return this.concatenate(this.createOperation(coordinateReferenceSystem, identifiedObject.getBaseCRS()), identifiedObject.getConversionFromBase());
        }
        if (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            identifiedObject = (GeneralDerivedCRS)coordinateReferenceSystem;
            CoordinateReferenceSystem coordinateReferenceSystem3 = identifiedObject.getBaseCRS();
            CoordinateOperation coordinateOperation = identifiedObject.getConversionFromBase();
            MathTransform mathTransform = coordinateOperation.getMathTransform();
            try {
                mathTransform = mathTransform.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(coordinateReferenceSystem, coordinateReferenceSystem3), noninvertibleTransformException);
            }
            coordinateOperation = this.createFromMathTransform(INVERSE_OPERATION, coordinateReferenceSystem, coordinateReferenceSystem3, mathTransform);
            return this.concatenate(coordinateOperation, this.createOperation(coordinateReferenceSystem3, coordinateReferenceSystem2));
        }
        if (coordinateReferenceSystem == DefaultEngineeringCRS.GENERIC_2D || coordinateReferenceSystem2 == DefaultEngineeringCRS.GENERIC_2D || coordinateReferenceSystem == DefaultEngineeringCRS.GENERIC_3D || coordinateReferenceSystem2 == DefaultEngineeringCRS.GENERIC_3D) {
            int n = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem);
            int n2 = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem2);
            if (n2 == n) {
                XMatrix xMatrix = Matrices.create(n2 + 1, n + 1);
                return this.createFromAffineTransform(IDENTITY, coordinateReferenceSystem, coordinateReferenceSystem2, xMatrix);
            }
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(coordinateReferenceSystem, coordinateReferenceSystem2));
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, OperationMethod operationMethod) throws OperationNotFoundException, FactoryException {
        DefaultCoordinateOperationFactory.ensureNonNull("method", operationMethod);
        return this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    private GeocentricCRS normalize(GeocentricCRS geocentricCRS, GeodeticDatum geodeticDatum) throws FactoryException {
        DefaultCartesianCS defaultCartesianCS = DefaultCartesianCS.GEOCENTRIC;
        GeodeticDatum geodeticDatum2 = geocentricCRS.getDatum();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(geodeticDatum2, geodeticDatum) && CRSUtilities.getGreenwichLongitude(geodeticDatum2.getPrimeMeridian()) == CRSUtilities.getGreenwichLongitude(geodeticDatum.getPrimeMeridian()) && DefaultCoordinateOperationFactory.hasStandardAxis(geocentricCRS.getCoordinateSystem(), defaultCartesianCS)) {
            return geocentricCRS;
        }
        CRSFactory cRSFactory = this.factories.getCRSFactory();
        return cRSFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(geocentricCRS), geodeticDatum, defaultCartesianCS);
    }

    private GeographicCRS normalize(GeographicCRS geographicCRS, boolean bl) throws FactoryException {
        DefaultEllipsoidalCS defaultEllipsoidalCS;
        GeodeticDatum geodeticDatum = geographicCRS.getDatum();
        EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
        DefaultEllipsoidalCS defaultEllipsoidalCS2 = defaultEllipsoidalCS = ellipsoidalCS.getDimension() <= 2 ? DefaultEllipsoidalCS.GEODETIC_2D : DefaultEllipsoidalCS.GEODETIC_3D;
        if (bl && CRSUtilities.getGreenwichLongitude(geodeticDatum.getPrimeMeridian()) != 0.0) {
            geodeticDatum = new TemporaryDatum(geodeticDatum);
        } else if (DefaultCoordinateOperationFactory.hasStandardAxis(ellipsoidalCS, defaultEllipsoidalCS)) {
            return geographicCRS;
        }
        CRSFactory cRSFactory = this.factories.getCRSFactory();
        return cRSFactory.createGeographicCRS(DefaultCoordinateOperationFactory.getTemporaryName(geographicCRS), geodeticDatum, defaultEllipsoidalCS);
    }

    private static boolean hasStandardAxis(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        int n = coordinateSystem2.getDimension();
        if (coordinateSystem.getDimension() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            CoordinateSystemAxis coordinateSystemAxis2 = coordinateSystem2.getAxis(i);
            if (coordinateSystemAxis.getDirection().equals(coordinateSystemAxis2.getDirection()) && coordinateSystemAxis.getUnit().equals(coordinateSystemAxis2.getUnit())) continue;
            return false;
        }
        return true;
    }

    private Matrix swapAndScaleAxis(EllipsoidalCS ellipsoidalCS, EllipsoidalCS ellipsoidalCS2, PrimeMeridian primeMeridian, PrimeMeridian primeMeridian2) throws OperationNotFoundException {
        Serializable serializable;
        Object object;
        CoordinateSystemAxis coordinateSystemAxis;
        int n;
        Matrix matrix = null;
        if (ellipsoidalCS.getDimension() == 2 && ellipsoidalCS2.getDimension() == 3) {
            n = 3;
            while (--n >= 0) {
                if (!AxisDirection.UP.equals(AxisDirections.absolute(ellipsoidalCS2.getAxis(n).getDirection()))) continue;
                coordinateSystemAxis = ellipsoidalCS2.getAxis(n != 0 ? 0 : 1);
                object = ellipsoidalCS2.getAxis(n != 2 ? 2 : 1);
                serializable = new DefaultEllipsoidalCS("Step", coordinateSystemAxis, (CoordinateSystemAxis)object);
                Matrix matrix2 = this.swapAndScaleAxis(ellipsoidalCS, (CoordinateSystem)((Object)serializable));
                assert (matrix2.getNumRow() == 3 && matrix2.getNumCol() == 3) : matrix2;
                matrix = Matrices.create(4, 3);
                matrix.setElement(3, 2, 1.0);
                int n2 = 0;
                for (int i = 0; i < 3; ++i) {
                    if (i == n) {
                        matrix.setElement(i, i, 0.0);
                        continue;
                    }
                    int n3 = 3;
                    while (--n3 >= 0) {
                        matrix.setElement(n2, n3, matrix2.getElement(i, n3));
                    }
                    ++n2;
                }
            }
        }
        if (matrix == null) {
            matrix = this.swapAndScaleAxis(ellipsoidalCS, ellipsoidalCS2);
        }
        n = ellipsoidalCS2.getDimension();
        while (--n >= 0) {
            coordinateSystemAxis = ellipsoidalCS2.getAxis(n);
            object = coordinateSystemAxis.getDirection();
            if (!AxisDirection.EAST.equals(AxisDirections.absolute((AxisDirection)object))) continue;
            serializable = coordinateSystemAxis.getUnit().asType(Angle.class);
            double d = CRSUtilities.getGreenwichLongitude(primeMeridian, serializable);
            double d2 = CRSUtilities.getGreenwichLongitude(primeMeridian2, serializable);
            int n4 = matrix.getNumCol() - 1;
            double d3 = d - d2;
            if (AxisDirection.WEST.equals(object)) {
                d3 = -d3;
            }
            matrix.setElement(n, n4, d3 += matrix.getElement(n, n4));
        }
        return matrix;
    }

    protected CoordinateOperation createOperationStep(TemporalCRS temporalCRS, TemporalCRS temporalCRS2) throws FactoryException {
        TemporalDatum temporalDatum = temporalCRS.getDatum();
        TemporalDatum temporalDatum2 = temporalCRS2.getDatum();
        TimeCS timeCS = temporalCRS.getCoordinateSystem();
        TimeCS timeCS2 = temporalCRS2.getCoordinateSystem();
        Unit<Duration> unit = timeCS2.getAxis(0).getUnit().asType(Duration.class);
        double d = temporalDatum.getOrigin().getTime() - temporalDatum2.getOrigin().getTime();
        d = Units.MILLISECOND.getConverterTo(unit).convert(d);
        Matrix matrix = this.swapAndScaleAxis(timeCS, timeCS2);
        int n = matrix.getNumCol() - 1;
        if (n >= 0) {
            double d2 = matrix.getElement(0, n);
            matrix.setElement(0, n, d2 + d);
        }
        return this.createFromAffineTransform(AXIS_CHANGES, temporalCRS, temporalCRS2, matrix);
    }

    protected CoordinateOperation createOperationStep(VerticalCRS verticalCRS, VerticalCRS verticalCRS2) throws FactoryException {
        VerticalDatum verticalDatum;
        VerticalDatum verticalDatum2 = verticalCRS.getDatum();
        if (!CRS.equalsIgnoreMetadata(verticalDatum2, verticalDatum = verticalCRS2.getDatum())) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(verticalDatum2, verticalDatum));
        }
        VerticalCS verticalCS = verticalCRS.getCoordinateSystem();
        VerticalCS verticalCS2 = verticalCRS2.getCoordinateSystem();
        Matrix matrix = this.swapAndScaleAxis(verticalCS, verticalCS2);
        return this.createFromAffineTransform(AXIS_CHANGES, verticalCRS, verticalCRS2, matrix);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, VerticalCRS verticalCRS) throws FactoryException {
        if (VerticalDatumTypes.ELLIPSOIDAL.equals(verticalCRS.getDatum().getVerticalDatumType())) {
            Matrix matrix = this.swapAndScaleAxis(geographicCRS.getCoordinateSystem(), verticalCRS.getCoordinateSystem());
            return this.createFromAffineTransform(AXIS_CHANGES, geographicCRS, verticalCRS, matrix);
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(geographicCRS, verticalCRS));
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, GeographicCRS geographicCRS2) throws FactoryException {
        Object object;
        Object object2;
        Object object3;
        EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
        EllipsoidalCS ellipsoidalCS2 = geographicCRS2.getCoordinateSystem();
        GeodeticDatum geodeticDatum = geographicCRS.getDatum();
        GeodeticDatum geodeticDatum2 = geographicCRS2.getDatum();
        PrimeMeridian primeMeridian = geodeticDatum.getPrimeMeridian();
        PrimeMeridian primeMeridian2 = geodeticDatum2.getPrimeMeridian();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(geodeticDatum, geodeticDatum2)) {
            Matrix matrix = this.swapAndScaleAxis(ellipsoidalCS, ellipsoidalCS2, primeMeridian, primeMeridian2);
            return this.createFromAffineTransform(AXIS_CHANGES, geographicCRS, geographicCRS2, matrix);
        }
        if (this.molodenskyMethod != null) {
            object3 = DATUM_SHIFT;
            object2 = null;
            if (geodeticDatum instanceof DefaultGeodeticDatum) {
                object2 = ((DefaultGeodeticDatum)geodeticDatum).getBursaWolfParameters(geodeticDatum2);
            }
            if (object2 == null) {
                object = DefaultGeodeticDatum.getAffineTransform(geodeticDatum, geodeticDatum2);
                if (object != null) {
                    try {
                        object2 = new BursaWolfParameters(geodeticDatum2);
                        ((BursaWolfParameters)object2).setAffineTransform((Matrix)object, 1.0E-4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (this.lenientDatumShift) {
                    object2 = new BursaWolfParameters(geodeticDatum2);
                    object3 = ELLIPSOID_SHIFT;
                }
            }
            if (object2 != null && ((BursaWolfParameters)object2).isTranslation()) {
                object = geodeticDatum.getEllipsoid();
                Ellipsoid ellipsoid = geodeticDatum2.getEllipsoid();
                if (((BursaWolfParameters)object2).isIdentity() && CRS.equalsIgnoreMetadata(object, ellipsoid)) {
                    Matrix matrix = this.swapAndScaleAxis(ellipsoidalCS, ellipsoidalCS2, primeMeridian, primeMeridian2);
                    return this.createFromAffineTransform((ReferenceIdentifier)object3, geographicCRS, geographicCRS2, matrix);
                }
                int n = DefaultCoordinateOperationFactory.getDimension(geographicCRS);
                int n2 = DefaultCoordinateOperationFactory.getDimension(geographicCRS2);
                ParameterValueGroup parameterValueGroup = this.getMathTransformFactory().getDefaultParameters(this.molodenskyMethod);
                parameterValueGroup.parameter("src_semi_major").setValue(object.getSemiMajorAxis());
                parameterValueGroup.parameter("src_semi_minor").setValue(object.getSemiMinorAxis());
                parameterValueGroup.parameter("tgt_semi_major").setValue(ellipsoid.getSemiMajorAxis());
                parameterValueGroup.parameter("tgt_semi_minor").setValue(ellipsoid.getSemiMinorAxis());
                parameterValueGroup.parameter("dx").setValue(((BursaWolfParameters)object2).dx);
                parameterValueGroup.parameter("dy").setValue(((BursaWolfParameters)object2).dy);
                parameterValueGroup.parameter("dz").setValue(((BursaWolfParameters)object2).dz);
                parameterValueGroup.parameter("dim").setValue(n);
                boolean bl = true;
                if (n != n2) {
                    try {
                        parameterValueGroup.parameter("src_dim").setValue(n);
                        parameterValueGroup.parameter("tgt_dim").setValue(n2);
                    }
                    catch (ParameterNotFoundException parameterNotFoundException) {
                        bl = false;
                        Logging.recoverableException(LOGGER, DefaultCoordinateOperationFactory.class, "createOperationStep", parameterNotFoundException);
                    }
                }
                if (bl) {
                    GeographicCRS geographicCRS3 = this.normalize(geographicCRS, true);
                    GeographicCRS geographicCRS4 = this.normalize(geographicCRS2, true);
                    return this.concatenate(this.createOperationStep(geographicCRS, geographicCRS3), this.createFromParameters((ReferenceIdentifier)object3, geographicCRS3, geographicCRS4, parameterValueGroup), this.createOperationStep(geographicCRS4, geographicCRS2));
                }
            }
        }
        object3 = DefaultCartesianCS.GEOCENTRIC;
        object = this.factories.getCRSFactory();
        object2 = CRSUtilities.getGreenwichLongitude(primeMeridian2) == 0.0 ? object.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(geographicCRS2), geodeticDatum2, (CartesianCS)object3) : object.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(geographicCRS), geodeticDatum, (CartesianCS)object3);
        return this.concatenate(this.createOperationStep(geographicCRS, (GeocentricCRS)object2), this.createOperationStep((GeocentricCRS)object2, geographicCRS2));
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS projectedCRS, ProjectedCRS projectedCRS2) throws FactoryException {
        GeographicCRS geographicCRS = projectedCRS.getBaseCRS();
        GeographicCRS geographicCRS2 = projectedCRS2.getBaseCRS();
        return this.concatenate(this.tryDB(projectedCRS, geographicCRS), this.tryDB(geographicCRS, geographicCRS2), this.tryDB(geographicCRS2, projectedCRS2));
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, ProjectedCRS projectedCRS) throws FactoryException {
        return this.concatenate(this.tryDB(geographicCRS, projectedCRS.getBaseCRS()), projectedCRS.getConversionFromBase());
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS projectedCRS, GeographicCRS geographicCRS) throws FactoryException {
        GeographicCRS geographicCRS2 = projectedCRS.getBaseCRS();
        CoordinateOperation coordinateOperation = projectedCRS.getConversionFromBase();
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(projectedCRS, geographicCRS2), noninvertibleTransformException);
        }
        coordinateOperation = this.createFromMathTransform(INVERSE_OPERATION, projectedCRS, geographicCRS2, mathTransform);
        return this.concatenate(coordinateOperation, this.tryDB(geographicCRS2, geographicCRS));
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS geocentricCRS, GeocentricCRS geocentricCRS2) throws FactoryException {
        Matrix4 matrix4;
        GeodeticDatum geodeticDatum = geocentricCRS.getDatum();
        GeodeticDatum geodeticDatum2 = geocentricCRS2.getDatum();
        CoordinateSystem coordinateSystem = geocentricCRS.getCoordinateSystem();
        CoordinateSystem coordinateSystem2 = geocentricCRS2.getCoordinateSystem();
        double d = CRSUtilities.getGreenwichLongitude(geodeticDatum.getPrimeMeridian());
        double d2 = CRSUtilities.getGreenwichLongitude(geodeticDatum2.getPrimeMeridian());
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(geodeticDatum, geodeticDatum2) && d == d2) {
            Matrix matrix = this.swapAndScaleAxis(coordinateSystem, coordinateSystem2);
            return this.createFromAffineTransform(AXIS_CHANGES, geocentricCRS, geocentricCRS2, matrix);
        }
        if (d != d2) {
            throw new OperationNotFoundException("Rotation of prime meridian not yet implemented");
        }
        DefaultCartesianCS defaultCartesianCS = DefaultCartesianCS.GEOCENTRIC;
        ReferenceIdentifier referenceIdentifier = DATUM_SHIFT;
        try {
            Matrix matrix = DefaultGeodeticDatum.getAffineTransform(TemporaryDatum.unwrap(geodeticDatum), TemporaryDatum.unwrap(geodeticDatum2));
            if (matrix == null) {
                if (this.lenientDatumShift) {
                    matrix = new Matrix4();
                    referenceIdentifier = ELLIPSOID_SHIFT;
                } else {
                    throw new OperationNotFoundException(Errors.format(19));
                }
            }
            Matrix matrix2 = this.swapAndScaleAxis(coordinateSystem, defaultCartesianCS);
            Matrix matrix3 = this.swapAndScaleAxis(defaultCartesianCS, coordinateSystem2);
            matrix4 = new Matrix4(matrix3);
            matrix4.multiply(matrix);
            matrix4.multiply(matrix2);
        }
        catch (SingularMatrixException singularMatrixException) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(geodeticDatum, geodeticDatum2), singularMatrixException);
        }
        return this.createFromAffineTransform(referenceIdentifier, geocentricCRS, geocentricCRS2, matrix4);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS geographicCRS, GeocentricCRS geocentricCRS) throws FactoryException {
        GeographicCRS geographicCRS2 = this.normalize(geographicCRS, true);
        GeodeticDatum geodeticDatum = geographicCRS2.getDatum();
        GeocentricCRS geocentricCRS2 = this.normalize(geocentricCRS, geodeticDatum);
        Ellipsoid ellipsoid = geodeticDatum.getEllipsoid();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        ParameterValueGroup parameterValueGroup = this.getMathTransformFactory().getDefaultParameters("Ellipsoid_To_Geocentric");
        parameterValueGroup.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        parameterValueGroup.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        parameterValueGroup.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(geographicCRS2));
        return this.concatenate(this.createOperationStep(geographicCRS, geographicCRS2), this.createFromParameters(GEOCENTRIC_CONVERSION, geographicCRS2, geocentricCRS2, parameterValueGroup), this.createOperationStep(geocentricCRS2, geocentricCRS));
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS geocentricCRS, GeographicCRS geographicCRS) throws FactoryException {
        GeographicCRS geographicCRS2 = this.normalize(geographicCRS, true);
        GeodeticDatum geodeticDatum = geographicCRS2.getDatum();
        GeocentricCRS geocentricCRS2 = this.normalize(geocentricCRS, geodeticDatum);
        Ellipsoid ellipsoid = geodeticDatum.getEllipsoid();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        ParameterValueGroup parameterValueGroup = this.getMathTransformFactory().getDefaultParameters("Geocentric_To_Ellipsoid");
        parameterValueGroup.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        parameterValueGroup.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        parameterValueGroup.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(geographicCRS2));
        CoordinateOperation coordinateOperation = this.createOperationStep(geocentricCRS, geocentricCRS2);
        CoordinateOperation coordinateOperation2 = this.createFromParameters(GEOCENTRIC_CONVERSION, geocentricCRS2, geographicCRS2, parameterValueGroup);
        CoordinateOperation coordinateOperation3 = this.createOperationStep(geographicCRS2, geographicCRS);
        return this.concatenate(coordinateOperation, coordinateOperation2, coordinateOperation3);
    }

    protected CoordinateOperation createOperationStep(CompoundCRS compoundCRS, SingleCRS singleCRS) throws FactoryException {
        Object object;
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        if (list.size() == 1) {
            return this.createOperation(list.get(0), singleCRS);
        }
        if (DefaultCoordinateOperationFactory.needsGeodetic3D(list, singleCRS, true)) {
            object = this.factories.toGeodetic3D(compoundCRS);
            if (object != compoundCRS) {
                return this.createOperation((CoordinateReferenceSystem)object, singleCRS);
            }
            if (!this.lenientDatumShift && DefaultCoordinateOperationFactory.needsGeodetic3D(list, singleCRS, false)) {
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(compoundCRS, singleCRS));
            }
        }
        object = Collections.singletonList(singleCRS);
        return this.createOperationStep(compoundCRS, list, singleCRS, (List<SingleCRS>)object);
    }

    protected CoordinateOperation createOperationStep(SingleCRS singleCRS, CompoundCRS compoundCRS) throws FactoryException {
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        if (list.size() == 1) {
            return this.createOperation(singleCRS, list.get(0));
        }
        CoordinateReferenceSystem coordinateReferenceSystem = this.factories.toGeodetic3D(compoundCRS);
        if (coordinateReferenceSystem != compoundCRS) {
            return this.createOperation(singleCRS, coordinateReferenceSystem);
        }
        List<SingleCRS> list2 = Collections.singletonList(singleCRS);
        return this.createOperationStep(singleCRS, list2, compoundCRS, list);
    }

    protected CoordinateOperation createOperationStep(CompoundCRS compoundCRS, CompoundCRS compoundCRS2) throws FactoryException {
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        List<SingleCRS> list2 = DefaultCompoundCRS.getSingleCRS(compoundCRS2);
        if (list2.size() == 1) {
            return this.createOperation(compoundCRS, list2.get(0));
        }
        if (list.size() == 1) {
            return this.createOperation(list.get(0), compoundCRS2);
        }
        for (SingleCRS singleCRS : list2) {
            if (!DefaultCoordinateOperationFactory.needsGeodetic3D(list, singleCRS, true)) continue;
            CoordinateReferenceSystem coordinateReferenceSystem = this.factories.toGeodetic3D(compoundCRS);
            CoordinateReferenceSystem coordinateReferenceSystem2 = this.factories.toGeodetic3D(compoundCRS2);
            if (coordinateReferenceSystem != compoundCRS || coordinateReferenceSystem2 != compoundCRS2) {
                return this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
            }
            if (this.lenientDatumShift || !DefaultCoordinateOperationFactory.needsGeodetic3D(list, singleCRS, false)) continue;
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(compoundCRS, compoundCRS2));
        }
        return this.createOperationStep(compoundCRS, list, compoundCRS2, list2);
    }

    private CoordinateOperation createOperationStep(CoordinateReferenceSystem coordinateReferenceSystem, List<SingleCRS> list, CoordinateReferenceSystem coordinateReferenceSystem2, List<SingleCRS> list2) throws FactoryException {
        int n;
        SingleCRS singleCRS;
        int n2;
        Object object;
        int n3 = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem);
        CoordinateOperation[] coordinateOperationArray = new CoordinateOperation[list2.size()];
        boolean[] blArray = new boolean[list.size()];
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new SingleCRS[coordinateOperationArray.length];
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            block12: {
                SingleCRS singleCRS2 = list2.get(i);
                object = null;
                n2 = 0;
                for (int j = 0; j < list.size(); ++j) {
                    singleCRS = list.get(j);
                    n = n2;
                    n2 += DefaultCoordinateOperationFactory.getDimension(singleCRS);
                    if (blArray[j]) continue;
                    try {
                        coordinateOperationArray[n4] = this.createOperation(singleCRS, singleCRS2);
                    }
                    catch (OperationNotFoundException operationNotFoundException) {
                        if (object != null && j != i) continue;
                        object = operationNotFoundException;
                        continue;
                    }
                    coordinateReferenceSystemArray[n4++] = singleCRS;
                    while (n < n2) {
                        nArray[n5++] = n++;
                    }
                    break block12;
                }
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(coordinateReferenceSystem, coordinateReferenceSystem2), (Throwable)object);
            }
            blArray[j] = true;
        }
        assert (n4 == coordinateOperationArray.length) : n4;
        XMatrix xMatrix = Matrices.create(n5 + 1, n3 + 1);
        for (int i = 0; i < n5; ++i) {
            xMatrix.setElement(i, i, 0.0);
            xMatrix.setElement(i, nArray[i], 1.0);
        }
        xMatrix.setElement(n5, n5, 0.0);
        xMatrix.setElement(n5, n3, 1.0);
        CoordinateOperation coordinateOperation = null;
        object = coordinateReferenceSystem;
        if (!xMatrix.isIdentity()) {
            object = coordinateReferenceSystemArray.length == 1 ? coordinateReferenceSystemArray[0] : this.factories.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(coordinateReferenceSystem), coordinateReferenceSystemArray);
            coordinateOperation = this.createFromAffineTransform(AXIS_CHANGES, coordinateReferenceSystem, (CoordinateReferenceSystem)object, xMatrix);
        }
        while (n4 != 0 && coordinateOperationArray[--n4].getMathTransform().isIdentity()) {
        }
        n = 0;
        for (n2 = 0; n2 < coordinateReferenceSystemArray.length; ++n2) {
            CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateReferenceSystemArray[n2];
            singleCRS = list2.get(n2);
            CoordinateOperation coordinateOperation2 = coordinateOperationArray[n2];
            coordinateReferenceSystemArray[n2] = singleCRS;
            MathTransform mathTransform = coordinateOperation2.getMathTransform();
            Object object2 = n2 >= n4 ? coordinateReferenceSystem2 : (mathTransform.isIdentity() ? object : (coordinateReferenceSystemArray.length == 1 ? singleCRS : this.factories.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(singleCRS), coordinateReferenceSystemArray)));
            int n6 = DefaultCoordinateOperationFactory.getDimension(coordinateReferenceSystem3);
            int n7 = n;
            if (n7 != 0 || (n += n6) != n5) {
                MathTransform mathTransform2 = this.getMathTransformFactory().createPassThroughTransform(n7, mathTransform, n5 - n);
                Map<String, ?> map = IdentifiedObjects.getProperties(coordinateOperation2);
                SingleOperation singleOperation = coordinateOperation2 instanceof SingleOperation ? (SingleOperation)coordinateOperation2 : (SingleOperation)DefaultSingleOperation.create(map, coordinateOperation2.getSourceCRS(), coordinateOperation2.getTargetCRS(), mathTransform, new DefaultOperationMethod(mathTransform), coordinateOperation2.getClass());
                coordinateOperation2 = new DefaultPassThroughOperation(map, (CoordinateReferenceSystem)object, (CoordinateReferenceSystem)object2, singleOperation, mathTransform2);
            }
            coordinateOperation = coordinateOperation == null ? coordinateOperation2 : this.concatenate(coordinateOperation, coordinateOperation2);
            object = object2;
            n -= (n6 -= DefaultCoordinateOperationFactory.getDimension(singleCRS));
            n5 -= n6;
        }
        assert (n == n5) : n;
        return coordinateOperation;
    }

    private static boolean needsGeodetic3D(List<SingleCRS> list, SingleCRS singleCRS, boolean bl) {
        Datum datum = singleCRS.getDatum();
        boolean bl2 = datum instanceof GeodeticDatum;
        if (!bl2 && !(datum instanceof VerticalDatum)) {
            return false;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (SingleCRS singleCRS2 : list) {
            if (singleCRS2.getCoordinateSystem().getDimension() >= 3) continue;
            Datum datum2 = singleCRS2.getDatum();
            boolean bl6 = datum2 instanceof GeodeticDatum;
            if (bl6) {
                bl3 = true;
            } else {
                if (!(datum2 instanceof VerticalDatum)) continue;
                bl4 = true;
            }
            if (bl5 || bl6 != bl2) continue;
            assert (Classes.implementSameInterfaces(datum2.getClass(), datum.getClass(), Datum.class)) : datum;
            if (bl6 && bl2) {
                GeodeticDatum geodeticDatum = (GeodeticDatum)datum2;
                GeodeticDatum geodeticDatum2 = (GeodeticDatum)datum;
                if (bl) {
                    bl5 = !DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(geodeticDatum, geodeticDatum2);
                    continue;
                }
                bl5 = DefaultCoordinateOperationFactory.isDatumShiftRequired(geodeticDatum, geodeticDatum2);
                continue;
            }
            bl5 = !CRS.equalsIgnoreMetadata(datum2, datum);
        }
        return bl3 && bl4 && (bl5 || singleCRS.getCoordinateSystem().getDimension() >= 3);
    }

    private static boolean isDatumShiftRequired(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2) {
        BursaWolfParameters bursaWolfParameters;
        if (CRS.equalsApproximatively(geodeticDatum, geodeticDatum2)) {
            return false;
        }
        if (geodeticDatum instanceof DefaultGeodeticDatum && (bursaWolfParameters = ((DefaultGeodeticDatum)geodeticDatum).getBursaWolfParameters(geodeticDatum2)) != null && bursaWolfParameters.isIdentity()) {
            return false;
        }
        return !(geodeticDatum2 instanceof DefaultGeodeticDatum) || (bursaWolfParameters = ((DefaultGeodeticDatum)geodeticDatum2).getBursaWolfParameters(geodeticDatum)) == null || !bursaWolfParameters.isIdentity();
    }

    private static boolean equalsIgnorePrimeMeridian(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2) {
        geodeticDatum = TemporaryDatum.unwrap(geodeticDatum);
        geodeticDatum2 = TemporaryDatum.unwrap(geodeticDatum2);
        if (CRS.equalsApproximatively(geodeticDatum.getEllipsoid(), geodeticDatum2.getEllipsoid())) {
            return IdentifiedObjects.nameMatches((IdentifiedObject)geodeticDatum, geodeticDatum2.getName().getCode()) || IdentifiedObjects.nameMatches((IdentifiedObject)geodeticDatum2, geodeticDatum.getName().getCode());
        }
        return false;
    }

    private CoordinateOperation tryDB(SingleCRS singleCRS, SingleCRS singleCRS2) throws FactoryException {
        if (singleCRS == singleCRS2) {
            return null;
        }
        CoordinateOperation coordinateOperation = this.createFromDatabase(singleCRS, singleCRS2);
        if (coordinateOperation != null) {
            return coordinateOperation;
        }
        return this.createOperation(singleCRS, singleCRS2);
    }

    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        return null;
    }

    private static final class TemporaryDatum
    extends DefaultGeodeticDatum {
        private static final long serialVersionUID = -8964199103509187219L;
        private final GeodeticDatum datum;

        public TemporaryDatum(GeodeticDatum geodeticDatum) {
            super(AbstractCoordinateOperationFactory.getTemporaryName(geodeticDatum), geodeticDatum.getEllipsoid());
            this.datum = geodeticDatum;
        }

        public static GeodeticDatum unwrap(GeodeticDatum geodeticDatum) {
            while (geodeticDatum instanceof TemporaryDatum) {
                geodeticDatum = ((TemporaryDatum)geodeticDatum).datum;
            }
            return geodeticDatum;
        }

        @Override
        public boolean equals(Object object, ComparisonMode comparisonMode) {
            if (object instanceof TemporaryDatum && super.equals(object, comparisonMode)) {
                GeodeticDatum geodeticDatum = ((TemporaryDatum)object).datum;
                switch (comparisonMode) {
                    case STRICT: {
                        return this.datum.equals(geodeticDatum);
                    }
                }
                return CRS.equalsIgnoreMetadata(this.datum, geodeticDatum);
            }
            return false;
        }
    }
}

