/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.temporal.object.DefaultInstant;
import org.geotoolkit.temporal.object.DefaultPeriodDuration;
import org.geotoolkit.temporal.object.DefaultTemporalPosition;
import org.geotoolkit.temporal.object.DefaultTemporalPrimitive;
import org.geotoolkit.util.logging.Logging;
import org.opengis.temporal.Duration;
import org.opengis.temporal.Instant;
import org.opengis.temporal.OrdinalReferenceSystem;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.Separation;
import org.opengis.temporal.TemporalGeometricPrimitive;

public abstract class DefaultTemporalGeometricPrimitive
extends DefaultTemporalPrimitive
implements TemporalGeometricPrimitive,
Separation {
    private static final Logger LOGGER = Logging.getLogger(DefaultTemporalGeometricPrimitive.class);

    @Override
    public Duration distance(TemporalGeometricPrimitive other) {
        DefaultPeriodDuration response = null;
        long diff = 0L;
        if (this instanceof Instant && other instanceof Instant) {
            if (((Instant)((Object)this)).getPosition().anyOther() != null && ((Instant)other).getPosition().anyOther() != null) {
                if (!((DefaultTemporalPosition)((Instant)((Object)this)).getPosition().anyOther()).getFrame().equals(((DefaultTemporalPosition)((Instant)other).getPosition().anyOther()).getFrame())) {
                    try {
                        throw new Exception("the TM_TemporalPositions are not both associated with the same TM_ReferenceSystem !");
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                }
            } else if (((Instant)((Object)this)).getPosition().anyOther() != null) {
                if (((Instant)((Object)this)).getPosition().anyOther().getIndeterminatePosition() != null || ((DefaultTemporalPosition)((Instant)((Object)this)).getPosition().anyOther()).getFrame() instanceof OrdinalReferenceSystem) {
                    try {
                        throw new Exception("either of the two TM_TemporalPositions is indeterminate or is associated with a TM_OrdianlReferenceSystem !");
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                }
            } else if (((Instant)other).getPosition().anyOther() != null && (((Instant)other).getPosition().anyOther().getIndeterminatePosition() != null || ((DefaultTemporalPosition)((Instant)other).getPosition().anyOther()).getFrame() instanceof OrdinalReferenceSystem)) {
                try {
                    throw new Exception("either of the two TM_TemporalPositions is indeterminate or is associated with a TM_OrdianlReferenceSystem !");
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
        }
        if (this.relativePosition(other).equals(RelativePosition.BEFORE) || this.relativePosition(other).equals(RelativePosition.AFTER)) {
            if (this instanceof Instant && other instanceof Instant) {
                diff = Math.min(Math.abs(((Instant)other).getPosition().getDate().getTime() - ((Instant)((Object)this)).getPosition().getDate().getTime()), Math.abs(((Instant)((Object)this)).getPosition().getDate().getTime() - ((Instant)other).getPosition().getDate().getTime()));
            } else if (this instanceof Instant && other instanceof Period) {
                diff = Math.min(Math.abs(((Period)other).getBeginning().getPosition().getDate().getTime() - ((Instant)((Object)this)).getPosition().getDate().getTime()), Math.abs(((Period)other).getEnding().getPosition().getDate().getTime() - ((Instant)((Object)this)).getPosition().getDate().getTime()));
            } else if (this instanceof Period && other instanceof Instant) {
                diff = Math.min(Math.abs(((Instant)other).getPosition().getDate().getTime() - ((Period)((Object)this)).getEnding().getPosition().getDate().getTime()), Math.abs(((Instant)other).getPosition().getDate().getTime() - ((Period)((Object)this)).getBeginning().getPosition().getDate().getTime()));
            } else if (this instanceof Period && other instanceof Period) {
                diff = Math.min(Math.abs(((Period)other).getEnding().getPosition().getDate().getTime() - ((Period)((Object)this)).getBeginning().getPosition().getDate().getTime()), Math.abs(((Period)other).getBeginning().getPosition().getDate().getTime() - ((Period)((Object)this)).getEnding().getPosition().getDate().getTime()));
            }
        } else if (this.relativePosition(other).equals(RelativePosition.BEGINS) || this.relativePosition(other).equals(RelativePosition.BEGUN_BY) || this.relativePosition(other).equals(RelativePosition.CONTAINS) || this.relativePosition(other).equals(RelativePosition.DURING) || this.relativePosition(other).equals(RelativePosition.ENDED_BY) || this.relativePosition(other).equals(RelativePosition.ENDS) || this.relativePosition(other).equals(RelativePosition.EQUALS) || this.relativePosition(other).equals(RelativePosition.MEETS) || this.relativePosition(other).equals(RelativePosition.MET_BY) || this.relativePosition(other).equals(RelativePosition.OVERLAPPED_BY) || this.relativePosition(other).equals(RelativePosition.OVERLAPS)) {
            diff = 0L;
        }
        response = new DefaultPeriodDuration(Math.abs(diff));
        return response;
    }

    @Override
    public Duration length() {
        Duration response = null;
        long diff = 0L;
        if (this instanceof Instant) {
            response = new DefaultPeriodDuration(Math.abs(diff));
            return response;
        }
        if (this instanceof Period && ((Period)((Object)this)).getBeginning() != null && ((Period)((Object)this)).getEnding() != null) {
            response = ((DefaultInstant)((Period)((Object)this)).getBeginning()).distance((DefaultInstant)((Period)((Object)this)).getEnding());
            return response;
        }
        return null;
    }
}

